/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import org.seasar.mayaa.FactoryFactory;
import org.seasar.mayaa.cycle.Response;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.cycle.scope.RequestScope;
import org.seasar.mayaa.cycle.scope.SessionScope;
import org.seasar.mayaa.impl.cycle.AbstractServiceCycle;
import org.seasar.mayaa.impl.cycle.web.RequestScopeImpl;
import org.seasar.mayaa.impl.cycle.web.ResponseImpl;
import org.seasar.mayaa.impl.cycle.web.SessionScopeImpl;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.PageForwarded;
import org.seasar.mayaa.impl.engine.RenderingTerminated;
import org.seasar.mayaa.impl.util.StringUtil;

public class ServiceCycleImpl
extends AbstractServiceCycle {
    private static final long serialVersionUID = 5971443264903384152L;
    private ApplicationScope _application;
    private RequestScopeImpl _request = new RequestScopeImpl();
    private ResponseImpl _response;
    private SessionScopeImpl _session;

    public ApplicationScope getApplicationScope() {
        if (this._application == null) {
            this._application = FactoryFactory.getApplicationScope();
        }
        return this._application;
    }

    public RequestScope getRequestScope() {
        return this._request;
    }

    public SessionScope getSessionScope() {
        if (this._session == null) {
            this._session = new SessionScopeImpl();
            Object underlying = this._request.getUnderlyingContext();
            this._session.setUnderlyingContext(underlying);
        }
        return this._session;
    }

    public Response getResponse() {
        if (this._response == null) {
            this._response = new ResponseImpl();
        }
        return this._response;
    }

    public void forward(String forwardPath) {
        if (StringUtil.isRelativePath(forwardPath)) {
            String sourcePath = EngineUtil.getSourcePath();
            forwardPath = StringUtil.adjustRelativePath(sourcePath, forwardPath);
        }
        this._request.setForwardPath(forwardPath);
        this._response.clearBuffer();
        throw new PageForwarded();
    }

    public void redirect(String url) {
        if (!this._response.isFlushed()) {
            if (StringUtil.isRelativePath(url)) {
                String sourcePath = EngineUtil.getSourcePath();
                url = StringUtil.adjustRelativePath(this._request.getContextPath() + sourcePath, url);
            }
            this._response.clearBuffer();
            this._response.redirect(url);
            this._response.flush();
            throw new RenderingTerminated();
        }
    }

    public void error(int errorCode) {
        this.error(errorCode, null);
    }

    public void error(int errorCode, String message) {
        if (!this._response.isFlushed()) {
            this._response.clearBuffer();
            this._response.error(errorCode, message);
            this._response.flush();
            throw new RenderingTerminated();
        }
    }
}

