/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script.rhino;

import org.mozilla.javascript.EvaluatorException;

public class OffsetLineRhinoException
extends EvaluatorException {
    private static final long serialVersionUID = 2330731436282320920L;
    int _offsetLine;

    public OffsetLineRhinoException(String detail, String sourceName, int lineNumber, String lineSource, int columnNumber, int offsetLine, Throwable cause) {
        super(detail, sourceName, lineNumber, lineSource, columnNumber);
        if (cause != null) {
            ((Throwable)((Object)this)).initCause(cause);
        }
        this._offsetLine = offsetLine;
    }

    public int getOffsetLine() {
        return this._offsetLine;
    }

    public String details() {
        return super.details();
    }

    public String emphasizeDetails() {
        String message = super.details();
        String[] lines = message.split("\n");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            if (i == this._offsetLine) {
                lines[i] = this.decorate(lines[i]);
            }
            sb.append(lines[i]);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String decorate(String line) {
        for (int j = 0; j < line.length(); ++j) {
            if (line.charAt(j) == '\t' || line.charAt(j) == ' ') continue;
            return line.substring(0, j) + "<span style=\"color: red; text-decoration: underline\">" + line.substring(j) + "</span>";
        }
        return line;
    }
}

