/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.jsp;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import org.seasar.mayaa.cycle.CycleWriter;

public class JspWriterImpl
extends JspWriter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean _closed;
    private boolean _flushed;
    private CycleWriter _writer;

    public JspWriterImpl(CycleWriter writer) {
        super(-1, false);
        if (writer == null) {
            throw new IllegalArgumentException();
        }
        this._writer = writer;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        if (len == 0) {
            return;
        }
        this._writer.write(cbuf, off, len);
    }

    public final void clear() throws IOException {
        if (this._closed || this._flushed) {
            throw new IOException();
        }
        this._writer.clearBuffer();
    }

    public void clearBuffer() {
        this._writer.clearBuffer();
    }

    public void close() {
        this._closed = true;
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new IOException();
        }
        this._writer.flush();
        this._flushed = true;
    }

    public int getRemaining() {
        return 0;
    }

    public void newLine() throws IOException {
        ((Writer)((Object)this)).write(LINE_SEPARATOR);
    }

    public void print(boolean b) throws IOException {
        ((Writer)((Object)this)).write(Boolean.toString(b));
    }

    public void print(char c) throws IOException {
        ((Writer)((Object)this)).write(Character.toString(c));
    }

    public void print(char[] c) throws IOException {
        ((Writer)((Object)this)).write(c);
    }

    public void print(double d) throws IOException {
        ((Writer)((Object)this)).write(Double.toString(d));
    }

    public void print(float f) throws IOException {
        ((Writer)((Object)this)).write(Float.toString(f));
    }

    public void print(int i) throws IOException {
        ((Writer)((Object)this)).write(Integer.toString(i));
    }

    public void print(long l) throws IOException {
        ((Writer)((Object)this)).write(Long.toString(l));
    }

    public void print(Object o) throws IOException {
        ((Writer)((Object)this)).write(o == null ? "null" : o.toString());
    }

    public void print(String s) throws IOException {
        ((Writer)((Object)this)).write(s == null ? "null" : s);
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(char[] c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.newLine();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.newLine();
    }
}

