/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.seasar.mayaa.builder.library.TemplateAttributeReader;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class TemplateAttributeReaderImpl
extends ParameterAwareImpl
implements TemplateAttributeReader {
    private static final long serialVersionUID = -7340519771743083660L;
    private Set _ignoreAttributes = new LinkedHashSet();
    private Map _aliasAttributes = new LinkedHashMap();
    private boolean _enabled = false;
    private static final Pattern QNAME_PATTERN = Pattern.compile("^\\{[^\\{\\}]+\\}[^\\{\\}]+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreAttribute(String qName, String attribute) {
        if (!this.isQName(qName) || StringUtil.isEmpty(attribute)) {
            throw new IllegalArgumentException();
        }
        Set set = this._ignoreAttributes;
        synchronized (set) {
            this._ignoreAttributes.add(this.toKey(qName, attribute));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAliasAttribute(String qName, String attribute, String templateAttribute) {
        if (!this.isQName(qName) || StringUtil.isEmpty(attribute) || !this.isQNameOrLocalName(templateAttribute)) {
            throw new IllegalArgumentException();
        }
        Map map = this._aliasAttributes;
        synchronized (map) {
            this._aliasAttributes.put(this.toKey(qName, attribute), templateAttribute);
        }
    }

    public void setParameter(String name, String value) {
        if ("enabled".equals(name)) {
            this._enabled = Boolean.valueOf(value);
        }
        super.setParameter(name, value);
    }

    public String getValue(QName qName, String attributeName, SpecificationNode original) {
        AttributeKey key;
        if (this._enabled && this.isTarget(key = this.qNameToKey(qName, attributeName))) {
            Iterator it = this._aliasAttributes.keySet().iterator();
            while (it.hasNext()) {
                NodeAttribute attribute;
                AttributeKey aliasKey = (AttributeKey)it.next();
                if (!aliasKey.match(key) || (attribute = original.getAttribute(this.getQName(original, (String)this._aliasAttributes.get(aliasKey)))) == null) continue;
                return attribute.getValue();
            }
            NodeAttribute attribute = original.getAttribute(this.getQName(original, attributeName));
            if (attribute != null) {
                return attribute.getValue();
            }
        }
        return null;
    }

    private boolean isTarget(AttributeKey key) {
        Iterator it = this._ignoreAttributes.iterator();
        while (it.hasNext()) {
            AttributeKey ignoreKey = (AttributeKey)it.next();
            if (!ignoreKey.match(key)) continue;
            return false;
        }
        return true;
    }

    private QName getQName(SpecificationNode original, String attribute) {
        if (attribute.startsWith("{")) {
            String[] split = attribute.split("[\\{\\}]");
            return SpecificationUtil.createQName(SpecificationUtil.createURI(split[1]), split[2]);
        }
        return SpecificationUtil.createQName(original.getQName().getNamespaceURI(), attribute);
    }

    private AttributeKey toKey(String qName, String attribute) {
        if (StringUtil.isEmpty(qName) || StringUtil.isEmpty(attribute)) {
            throw new IllegalArgumentException();
        }
        return new AttributeKey(qName, attribute);
    }

    private AttributeKey qNameToKey(QName qName, String attribute) {
        if (qName == null || StringUtil.isEmpty(attribute)) {
            throw new IllegalArgumentException();
        }
        return new AttributeKey(qName.toString(), attribute);
    }

    private boolean isQName(String test) {
        return StringUtil.hasValue(test) && QNAME_PATTERN.matcher(test).matches();
    }

    private boolean isQNameOrLocalName(String test) {
        return StringUtil.hasValue(test) && (QNAME_PATTERN.matcher(test).matches() || test.indexOf(123) == -1 && test.indexOf(125) == -1);
    }

    private class AttributeKey {
        private String _tagName;
        private String _attributeName;

        protected AttributeKey(String tagName, String attributeName) {
            this._tagName = tagName;
            this._attributeName = attributeName;
        }

        protected boolean match(AttributeKey other) {
            return this.matchWildCard(this._tagName, other._tagName) && this.matchWildCard(this._attributeName, other._attributeName);
        }

        private boolean matchWildCard(String pattern, String test) {
            if (pattern.charAt(pattern.length() - 1) == '*') {
                return test.startsWith(pattern.substring(0, pattern.length() - 1));
            }
            return test.equals(pattern);
        }
    }
}

