/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.library.LibraryDefinition;
import org.seasar.mayaa.builder.library.LibraryManager;
import org.seasar.mayaa.builder.library.ProcessorDefinition;
import org.seasar.mayaa.builder.library.PropertyDefinition;
import org.seasar.mayaa.builder.library.PropertySet;
import org.seasar.mayaa.builder.library.converter.PropertyConverter;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.ConverterNotFoundException;
import org.seasar.mayaa.impl.builder.library.FinalProcessorPropertyException;
import org.seasar.mayaa.impl.builder.library.NoRequiredPropertyException;
import org.seasar.mayaa.impl.engine.specification.NodeAttributeImpl;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class PropertyDefinitionImpl
extends ParameterAwareImpl
implements PropertyDefinition,
CONST_IMPL {
    private static final long serialVersionUID = -9121229054380668801L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl = PropertyDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.PropertyDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl));
    private PropertySet _propertySet;
    private String _name;
    private String _implName;
    private boolean _required;
    private Class _expectedClass;
    private String _defaultValue;
    private String _finalValue;
    private String _propertyConverterName;
    private PropertyConverter _propertyConverter;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$processor$VirtualPropertyAcceptable;

    public void setPropertySet(PropertySet propertySet) {
        if (propertySet == null) {
            throw new IllegalArgumentException();
        }
        this._propertySet = propertySet;
    }

    public PropertySet getPropertySet() {
        if (this._propertySet == null) {
            throw new IllegalStateException();
        }
        return this._propertySet;
    }

    public void setName(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public String getName() {
        if (StringUtil.isEmpty(this._name)) {
            throw new IllegalStateException();
        }
        return this._name;
    }

    public void setImplName(String implName) {
        this._implName = implName;
    }

    public String getImplName() {
        if (StringUtil.isEmpty(this._implName)) {
            return this.getName();
        }
        return this._implName;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setExpectedClass(Class expectedClass) {
        this._expectedClass = expectedClass;
    }

    public Class getExpectedClass() {
        if (this._expectedClass == null) {
            return class$java$lang$Object == null ? (class$java$lang$Object = PropertyDefinitionImpl.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return this._expectedClass;
    }

    public void setDefaultValue(String defaultValue) {
        this._defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setFinalValue(String finalValue) {
        this._finalValue = finalValue;
    }

    public String getFinalValue() {
        return this._finalValue;
    }

    public void setPropertyConverterName(String propertyConverterName) {
        this._propertyConverterName = propertyConverterName;
    }

    public String getPropertyConverterName() {
        return this._propertyConverterName;
    }

    public void setPropertyConverter(PropertyConverter propertyConverter) {
        if (propertyConverter == null) {
            throw new IllegalArgumentException();
        }
        this._propertyConverter = propertyConverter;
    }

    protected PropertyConverter getPropertyConverter(ProcessorDefinition processorDef) {
        if (this._propertyConverter != null) {
            return this._propertyConverter;
        }
        LibraryDefinition library = this.getPropertySet().getLibraryDefinition();
        String converterName = this.getPropertyConverterName();
        if (StringUtil.hasValue(converterName)) {
            PropertyConverter converter = library.getPropertyConverter(converterName);
            if (converter == null) {
                throw new ConverterNotFoundException(converterName, this.getSystemID(), this.getLineNumber());
            }
            return converter;
        }
        Class propertyClass = this.getPropertyClass(processorDef);
        if (propertyClass != null) {
            return library.getPropertyConverter(propertyClass);
        }
        return null;
    }

    protected Class getPropertyClass(ProcessorDefinition processorDef) {
        Class processorClass = processorDef.getProcessorClass();
        return ObjectUtil.getPropertyClass(processorClass, this.getImplName());
    }

    protected QName getQName(SpecificationNode node) {
        return SpecificationUtil.createQName(node.getQName().getNamespaceURI(), this._name);
    }

    public Object createProcessorProperty(ProcessorDefinition processorDef, SpecificationNode original, SpecificationNode injected) {
        if (injected == null) {
            throw new IllegalArgumentException();
        }
        QName qName = this.getQName(injected);
        String value = this.getFinalValue();
        NodeAttribute attribute = injected.getAttribute(qName);
        if (value == null) {
            value = this.getDefaultValue();
            if (attribute != null) {
                value = attribute.getValue();
            } else if (value != null) {
                attribute = new NodeAttributeImpl(qName, value);
            }
        } else if (attribute != null) {
            String processorName = processorDef.getName();
            throw new FinalProcessorPropertyException(processorName, qName);
        }
        if (value != null) {
            Class processotClass;
            Class propertyClass = this.getPropertyClass(processorDef);
            if (propertyClass == null && !(class$org$seasar$mayaa$engine$processor$VirtualPropertyAcceptable == null ? (class$org$seasar$mayaa$engine$processor$VirtualPropertyAcceptable = PropertyDefinitionImpl.class$("org.seasar.mayaa.engine.processor.VirtualPropertyAcceptable")) : class$org$seasar$mayaa$engine$processor$VirtualPropertyAcceptable).isAssignableFrom(processotClass = processorDef.getProcessorClass())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)StringUtil.getMessage(class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl == null ? (class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl = PropertyDefinitionImpl.class$("org.seasar.mayaa.impl.builder.library.PropertyDefinitionImpl")) : class$org$seasar$mayaa$impl$builder$library$PropertyDefinitionImpl, 0, processorDef.getName(), this.getName()));
                }
                return null;
            }
            PropertyConverter converter = this.getPropertyConverter(processorDef);
            if (converter == null && propertyClass != null) {
                LibraryManager manager = ProviderUtil.getLibraryManager();
                converter = manager.getPropertyConverter(propertyClass);
            }
            if (converter == null) {
                return value;
            }
            return converter.convert(attribute, value, this.getExpectedClass());
        }
        if (this._required) {
            String processorName = processorDef.getName();
            throw new NoRequiredPropertyException(processorName, qName);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

