/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.builder.parser.AdditionalHandler;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;
import org.seasar.mayaa.impl.util.StringUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class SpecificationNodeHandler
implements EntityResolver,
DTDHandler,
ContentHandler,
ErrorHandler,
LexicalHandler,
AdditionalHandler,
CONST_IMPL {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$builder$SpecificationNodeHandler == null ? (class$org$seasar$mayaa$impl$builder$SpecificationNodeHandler = SpecificationNodeHandler.class$("org.seasar.mayaa.impl.builder.SpecificationNodeHandler")) : class$org$seasar$mayaa$impl$builder$SpecificationNodeHandler));
    protected static final QName QM_DATA = SpecificationUtil.createQName("data");
    protected static final QName QM_PUBLIC_ID = SpecificationUtil.createQName("publicID");
    protected static final QName QM_SYSTEM_ID = SpecificationUtil.createQName("systemID");
    protected static final QName QM_TARGET = SpecificationUtil.createQName("target");
    private Specification _specification;
    private SequenceIDGenerator _sequenceIDGenerator;
    private NodeTreeWalker _current;
    private Locator _locator;
    private Namespace _namespace;
    private StringBuffer _charactersBuffer;
    private int _charactersStartLineNumber;
    private boolean _outputMayaaWhitespace = false;
    private int _inEntity;
    private Map _internalNamespacePrefixMap;
    private boolean _inCData;
    private static final int DEFAULT_BUFFER_SIZE = 128;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$builder$SpecificationNodeHandler;

    public SpecificationNodeHandler(Specification specification) {
        if (specification == null) {
            throw new IllegalArgumentException();
        }
        this._specification = specification;
        this._current = this._specification;
        this._sequenceIDGenerator = specification;
    }

    protected Specification getSpecification() {
        return this._specification;
    }

    public void setOutputMayaaWhitespace(boolean outputMayaaWhitespace) {
        this._outputMayaaWhitespace = outputMayaaWhitespace;
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    protected void initNamespace() {
        this._namespace = SpecificationUtil.createNamespace();
        this.getCurrentInternalNamespacePrefixMap().put("", CONST_IMPL.URI_HTML);
        this.getCurrentInternalNamespacePrefixMap().put("xml", CONST_IMPL.URI_XML);
    }

    protected void pushNamespace(Namespace newNamespace) {
        this._namespace = newNamespace;
    }

    protected void popNamespace() {
        this._namespace = this._namespace.getParentSpace();
        if (this._namespace == null) {
            throw new IllegalStateException(this.getClass().getName());
        }
    }

    protected void initCharactersBuffer() {
        this._charactersBuffer = new StringBuffer(128);
        this._charactersStartLineNumber = this._locator.getLineNumber();
    }

    protected void appendCharactersBuffer(String str) {
        if (this._charactersStartLineNumber == -1) {
            this._charactersStartLineNumber = this._locator.getLineNumber();
        }
        this._charactersBuffer.append(str);
    }

    protected void appendCharactersBuffer(char[] str, int offset, int len) {
        if (this._charactersStartLineNumber == -1) {
            this._charactersStartLineNumber = this._locator.getLineNumber();
        }
        this._charactersBuffer.append(str, offset, len);
    }

    public void startDocument() {
        this._sequenceIDGenerator.resetSequenceID(1);
        this.initCharactersBuffer();
        this._charactersStartLineNumber = -1;
        this._current = this._specification;
        this._internalNamespacePrefixMap = new HashMap();
        this.initNamespace();
    }

    protected Map getCurrentInternalNamespacePrefixMap() {
        HashMap result = (HashMap)this._internalNamespacePrefixMap.get(this._current);
        if (result == null) {
            result = new HashMap();
            this._internalNamespacePrefixMap.put(this._current, result);
        }
        return result;
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.getCurrentInternalNamespacePrefixMap().put(prefix, SpecificationUtil.createURI(uri));
    }

    public void endPrefixMapping(String prefix) {
        this.getCurrentInternalNamespacePrefixMap().remove(prefix);
    }

    protected SpecificationNode addNode(QName qName) {
        int lineNumber = this._locator.getLineNumber();
        return this.addNode(qName, lineNumber);
    }

    protected SpecificationNode createChildNode(QName qName, String systemID, int lineNumber, int sequenceID) {
        return SpecificationUtil.createSpecificationNode(qName, systemID, lineNumber, false, sequenceID);
    }

    protected SpecificationNode addNode(QName qName, int lineNumber) {
        String systemID = StringUtil.removeFileProtocol(this._locator.getSystemId());
        SpecificationNode child = this.createChildNode(qName, systemID, lineNumber, this._sequenceIDGenerator.nextSequenceID());
        child.setParentSpace(SpecificationUtil.getFixedNamespace(this._namespace));
        this._current.addChildNode(child);
        return child;
    }

    protected boolean isRemoveWhitespace() {
        return !this._outputMayaaWhitespace && !this._inCData;
    }

    protected void addCharactersNode() {
        if (this._charactersBuffer.length() > 0) {
            String characters = this._charactersBuffer.toString();
            if (this.isRemoveWhitespace()) {
                characters = this.removeIgnorableWhitespace(characters);
            }
            if (characters.length() > 0) {
                SpecificationNode node = this.addNode(CONST_IMPL.QM_CHARACTERS, this._charactersStartLineNumber);
                node.addAttribute(CONST_IMPL.QM_TEXT, characters);
            }
            this.initCharactersBuffer();
        }
    }

    private String removeIgnorableWhitespace(String characters) {
        StringBuffer buffer = new StringBuffer(characters.length());
        String[] line = characters.split("\n");
        for (int i = 0; i < line.length; ++i) {
            if (line[i].trim().length() <= 0) continue;
            String token = line[i].replaceAll("^[ \t]+", "");
            token = token.replaceAll("[ \t]+$", "");
            buffer.append(token.replaceAll("[ \t]+", " "));
            if (i >= line.length - 1 || i + 1 >= line.length - 1 && line[i + 1].trim().length() <= 0) continue;
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected void saveToCycle(NodeTreeWalker originalNode) {
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.setOriginalNode(originalNode);
    }

    protected boolean checkAttribute(String qName, String value) {
        if (StringUtil.isEmpty(qName)) {
            throw new IllegalArgumentException();
        }
        return !"xmlns".equals(qName) && !qName.startsWith("xmlns:");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.addCharactersNode();
        Namespace elementNS = SpecificationUtil.createNamespace();
        Iterator it = this.getCurrentInternalNamespacePrefixMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            elementNS.addPrefixMapping((String)entry.getKey(), (URI)entry.getValue());
        }
        elementNS.setParentSpace(SpecificationUtil.getFixedNamespace(this._namespace));
        PrefixAwareName parsedName = BuilderUtil.parseName(elementNS, qName);
        QName nodeQName = parsedName.getQName();
        URI nodeURI = nodeQName.getNamespaceURI();
        elementNS.setDefaultNamespaceURI(nodeURI);
        elementNS = SpecificationUtil.getFixedNamespace(elementNS);
        SpecificationNode node = this.addNode(nodeQName);
        it = this.getCurrentInternalNamespacePrefixMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            node.addPrefixMapping((String)entry.getKey(), (URI)entry.getValue());
        }
        node.setDefaultNamespaceURI(nodeURI);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrValue;
            String attrName = attributes.getQName(i);
            if (!this.checkAttribute(attrName, attrValue = attributes.getValue(i))) continue;
            PrefixAwareName parsedAttrName = BuilderUtil.parseName(elementNS, attrName);
            QName attrQName = parsedAttrName.getQName();
            node.addAttribute(attrQName, attrName, attrValue);
        }
        NodeTreeWalker parent = this._current;
        this._current = node;
        this._current.setParentNode(parent);
        this.saveToCycle(this._current);
        this.pushNamespace(elementNS);
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.popNamespace();
        this.addCharactersNode();
        this._current = this._current.getParentNode();
        this.saveToCycle(this._current);
    }

    public void endDocument() {
        this.saveToCycle(this._specification);
        this._internalNamespacePrefixMap.clear();
        this._internalNamespacePrefixMap = null;
        this._current = null;
    }

    public void characters(char[] buffer, int start, int length) {
        if (this._inEntity == 0) {
            this.appendCharactersBuffer(buffer, start, length);
        }
    }

    public void ignorableWhitespace(char[] buffer, int start, int length) {
    }

    public void xmlDecl(String version, String encoding, String standalone) {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(CONST_IMPL.QM_PI);
        node.addAttribute(QM_TARGET, "xml");
        StringBuffer buffer = new StringBuffer();
        if (StringUtil.hasValue(version)) {
            buffer.append("version=\"").append(version).append("\" ");
        }
        if (StringUtil.hasValue(encoding)) {
            buffer.append("encoding=\"").append(encoding).append("\" ");
        }
        if (StringUtil.hasValue(standalone)) {
            buffer.append("standalone=\"").append(standalone).append("\" ");
        }
        if (buffer.length() > 0) {
            node.addAttribute(QM_DATA, buffer.toString());
        }
    }

    public void processingInstruction(String target, String data) {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(CONST_IMPL.QM_PI);
        node.addAttribute(QM_TARGET, target);
        if (StringUtil.hasValue(data)) {
            node.addAttribute(QM_DATA, data);
        }
    }

    public void skippedEntity(String name) {
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    protected void processEntity(String name) {
        this.appendCharactersBuffer(StringUtil.resolveEntity('&' + name + ';'));
    }

    public void startEntity(String name) {
        this.processEntity(name);
        ++this._inEntity;
    }

    public void endEntity(String name) {
        --this._inEntity;
    }

    public void comment(char[] buffer, int start, int length) {
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    public void startDTD(String name, String publicID, String systemID) {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(CONST_IMPL.QM_DOCTYPE);
        node.addAttribute(CONST_IMPL.QM_NAME, name);
        if (StringUtil.hasValue(publicID)) {
            node.addAttribute(QM_PUBLIC_ID, publicID);
        }
        if (StringUtil.hasValue(systemID)) {
            node.addAttribute(QM_SYSTEM_ID, systemID);
        }
        this.appendCharactersBuffer("\r\n");
    }

    public void endDTD() {
    }

    public void startCDATA() {
        this.addCharactersNode();
        SpecificationNode node = this.addNode(CONST_IMPL.QM_CDATA);
        NodeTreeWalker parent = this._current;
        this._current = node;
        this._current.setParentNode(parent);
        this._inCData = true;
    }

    public void endCDATA() {
        this.addCharactersNode();
        this._current = this._current.getParentNode();
        this._inCData = false;
    }

    private String exceptionMessage(SAXParseException e) {
        return "The problem occurred during Perse. " + this._specification.getSystemID() + (e.getMessage() != null ? " - " + e.getMessage() : "");
    }

    public void warning(SAXParseException e) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)this.exceptionMessage(e), (Throwable)e);
        }
    }

    public void fatalError(SAXParseException e) {
        if (LOG.isFatalEnabled()) {
            LOG.fatal((Object)this.exceptionMessage(e), (Throwable)e);
        }
        throw new RuntimeException(this.exceptionMessage(e), e);
    }

    public void error(SAXParseException e) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)this.exceptionMessage(e), (Throwable)e);
        }
        throw new RuntimeException(this.exceptionMessage(e), e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

