/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.FactoryFactory;
import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.impl.AutoPageBuilder;
import org.seasar.mayaa.impl.FactoryFactoryImpl;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.specification.serialize.SerializeThreadManager;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class MayaaServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$MayaaServlet == null ? (class$org$seasar$mayaa$impl$MayaaServlet = MayaaServlet.class$("org.seasar.mayaa.impl.MayaaServlet")) : class$org$seasar$mayaa$impl$MayaaServlet));
    private static final long serialVersionUID = -5816552218525836552L;
    private static boolean _initialized;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$MayaaServlet;

    public void init() {
        if (!_initialized) {
            LOG.info((Object)"init start");
            FactoryFactory.setInstance(new FactoryFactoryImpl());
            FactoryFactory.setContext(this.getServletContext());
            _initialized = true;
        }
        this.getServletContext().getInitParameter("");
        LOG.info((Object)"prepareLibraries start");
        ProviderUtil.getLibraryManager().prepareLibraries();
        LOG.info((Object)"prepareLibraries end");
        this.initAutoPageBuilder();
        LOG.info((Object)"init end");
    }

    protected void initAutoPageBuilder() {
        AutoPageBuilder.INSTANCE.init(this.getServletConfig());
    }

    public void destroy() {
        AutoPageBuilder.INSTANCE.destroy();
        ProviderUtil.getEngine().kill();
        SerializeThreadManager.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doService(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doService(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) {
        CycleUtil.initialize(request, response);
        try {
            Engine engine = ProviderUtil.getEngine();
            this.setupCharacterEncoding(request, engine.getParameter("requestCharacterEncoding"));
            engine.doService(null, true);
        }
        finally {
            CycleUtil.cycleFinalize();
        }
    }

    protected void setupCharacterEncoding(HttpServletRequest request, String encoding) {
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException e) {
                String message = StringUtil.getMessage(class$org$seasar$mayaa$impl$MayaaServlet == null ? (class$org$seasar$mayaa$impl$MayaaServlet = MayaaServlet.class$("org.seasar.mayaa.impl.MayaaServlet")) : class$org$seasar$mayaa$impl$MayaaServlet, 0, encoding);
                LOG.warn((Object)message, (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

