/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.servlet.SingletonS2ContainerInitializer;
import org.seasar.framework.log.Logger;

public class S2ContainerListener
implements ServletContextListener {
    public static final String CONFIG_PATH_KEY = "org.seasar.framework.container.configPath";
    private static Logger logger = Logger.getLogger(S2ContainerListener.class);

    private void initializeContainer(ServletContext servletContext) {
        String configPath = servletContext.getInitParameter(CONFIG_PATH_KEY);
        SingletonS2ContainerInitializer initializer = new SingletonS2ContainerInitializer();
        initializer.setConfigPath(configPath);
        initializer.setApplication(servletContext);
        initializer.initialize();
    }

    public void contextInitialized(ServletContextEvent event) {
        logger.debug("S2Container initialize start");
        ServletContext servletContext = event.getServletContext();
        try {
            this.initializeContainer(servletContext);
        }
        catch (RuntimeException e) {
            logger.log(e);
            throw e;
        }
        logger.debug("S2Container initialize end");
    }

    public void contextDestroyed(ServletContextEvent event) {
        SingletonS2ContainerFactory.destroy();
    }
}

