/**
 * # CHAPTER #
 * ============================================================================
 * MUSASHIѤǡνϴϢδؿ
 * 20040824 -z ץ̵ (ɸϤϰ̵)˻ѹ
 *             (mssOpenFPWؿѹ)
 * ============================================================================
 */

#include <musashi/mssConfig.h>
#include <musashi/mssOutput.h>
#include <musashi/mssBase.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <zlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>

/**
 * # FUNCTION #
 * ̥եν񤭹ߥץ󥨥顼ɽλ
 */
static void zwOpenErr(char *fName)
{
  mssShowErrMsg("gz file write open error :\"%s\"",fName);
  mssEnd(mssErrorNoDefault);
}

/**
 * # FUNCTION #
 * ̾եν񤭹ߥץ󥨥顼ɽλ
 */
static void fwOpenErr(char *fName)
{
  mssShowErrMsg("file write open error :\"%s\"",fName);
  mssEnd(mssErrorNoDefault);
}

/**
 * # FUNCTION #
 * ե̾ɬפʥǥ쥯ȥ롣
 * ex.)
 * fileName="abc/def/ghi/dat.xt"
 *  -> ȥǥ쥯ȥˤơabc/dec/ghiΥǥ쥯ȥ
 *     Ǹ/ʲ̾եȤߤʤ
 */
static void mkDir(char *fileName)
{
  char fn[MssFileNameMaxLen];
  char *slaPos;
  char *dirTbl[100];
  int cnt=0;
  int i;
  int rt=0; /*롼ȤꤵƤ뤫ե饰'/tmp'*/
  int err;
  char dirStr[MssFileNameMaxLen];

  if(*fileName=='/'){
    fileName++;
    rt=1;
  }

  strcpy(fn,fileName);

  slaPos = strtok(fn,"/");
  while(slaPos != NULL) {
    dirTbl[cnt]=slaPos;    
    slaPos = strtok(NULL,"/");
    cnt++;
    if(cnt>=100) {
      mssShowErrMsg("too deep");
      mssEnd(mssErrorNoDefault);
    }
  }
  if(cnt<=1) return;

  if(rt){
    dirStr[0]='/'; dirStr[1]='\0';
  }else{
    dirStr[0]='\0';
  }

  for(i=0; i<cnt-1; i++){
    strcat(dirStr,dirTbl[i]);
    strcat(dirStr,"/");
    err=mkdir(dirStr,S_IRWXU|S_IRWXG|S_IRWXO);
    if(err==-1 && errno==EEXIST) continue;
    if(err==0) continue;
    mssShowErrMsg("can not make directory(%d) : \"%s\"",errno,dirStr);
    mssEnd(mssErrorNoDefault);
  }
}

/**
 * # FUNCTION #
 * 񤭹ߥե򥪡ץ󤹤롣
 * ե̾(fileName)NULLξɸϡξɸ२顼ϤȤ
 * ץ󤹤롣
 * ξϡ̥եȤƥץ󤷡񤭹߷̤
 * gzip̤롣
 * 軰ξϡե̾˴ޤޤǥ쥯ȥŪ˺롣
 *
 * ե̾ȽǤư̤뤫ɤ롣
 * θϤϤʤ(1.1.0Ǥѻߤ)
 */
struct mssFPW *mssOpenFPW( char *fileName, int z, int d)
{
  struct mssFPW *fp;
  int len;
  char *pos;

  if(d) mkDir(fileName);

  fp=mssMalloc(sizeof(struct mssFPW),"openFPW");

  if(fileName == NULL){          /*stdout*/
    fp->fp=stdout;
    //fp->fp=fopen("/dev/stdout","wb");//stdout;
    fp->fName=mssStrdup("stdout");
    fp->zflg=0;
  }else if(fileName==(char *)1){ /*stderr*/
    fp->fp=stderr;
    //fp->fp=fopen("/dev/stderr","wb");//stderr;
    fp->fName=mssStrdup("stderr");
    fp->zflg=0;
  }else{
    len=strlen(fileName);
    fp->zflg=0;
    if(len>=3){
      pos=fileName+len-3;
      if(*pos=='.' && *(pos+1)=='g' && *(pos+2)=='z'){
        fp->zflg=1;
      }
    }
    if(fp->zflg){
      fp->zfd=gzopen(fileName,"wb");
      if(fp->zfd == NULL) zwOpenErr(fileName);
    }else{
      fp->fp=fopen(fileName,"wb");
      if(fp->fp == NULL) fwOpenErr(fileName);
    }
    fp->fName=mssStrdup(fileName);
  }
  return(fp);
}

/**
 * # FUNCTION #
 * 񤭹ߥե򥯥롣
 */
void mssCloseFPW(struct mssFPW *fp){

  if(fp==NULL) return;

  if(fp->zflg){
    gzclose(fp->zfd);
  }else{
    if(fp->fp != stdout && fp->fp != stderr){
      fclose(fp->fp);
    }
  }

  mssFree(fp->fName);
  mssFree(fp);
}

/**
 * # FUNCTION #
 * xmlTableιܥǥߥʸ(MssFieldDelim)νϡ
 */
void mssWriteDlm(struct mssFPW *fp){
  if(fp->zflg){
    gzputc(fp->zfd,MssFieldDelim);
  }else{
    fputc(MssFieldDelim,fp->fp);
  }
}

/**
 * # FUNCTION #
 * ʸνϡ
 */
void mssWriteRet(struct mssFPW *fp){
  if(fp->zflg){
    gzputc(fp->zfd,'\n');
  }else{
    fputc('\n',fp->fp);
  }
}

/**
 * # FUNCTION #
 * ʸνϡ
 */
void mssWriteStr(char *str,struct mssFPW *fp){
  if(fp->zflg){
    gzputs(fp->zfd, str);
  }else{
    fputs(str, fp->fp);
  }
}

/**
 * # FUNCTION #
 * ʸνϡ
 */
void mssWriteChr(char chr,struct mssFPW *fp){
  if(fp->zflg){
    gzputc(fp->zfd, chr);
  }else{
    fputc(chr, fp->fp);
  }
}

/**
 * # FUNCTION #
 * (int)νϡ
 */
void mssWriteInt(int num,struct mssFPW *fp){
  if(fp->zflg){
    gzprintf(fp->zfd,"%d",num);
  }else{
    fprintf(fp->fp,"%d",num);
  }
}

/**
 * # FUNCTION #
 * Long(long)νϡ
 */
void mssWriteLong(long num,struct mssFPW *fp){
  if(fp->zflg){
    gzprintf(fp->zfd,"%ld",num);
  }else{
    fprintf(fp->fp,"%ld",num);
  }
}

/**
 * # FUNCTION #
 * Double¿(double)ƣưɽ(".")ν񼰤ǽϡ
 */
void mssWriteDbl(double num, struct mssFPW *fp){
  char *buf;

  buf=mssFtoA(num);
  mssWriteStr(buf,fp);
  mssFree(buf);
}

/**
 * # FUNCTION #
 * Double¿(double)礭˱ƣưɽ⤷
 * ʻؿɽ(ex.3.14152e+10)ν񼰤ǽϡ
 */
void mssWriteDbe(double num, struct mssFPW *fp){
  char buf[100];

  sprintf(buf,"%g",num);
  mssWriteStr(buf,fp);
}

/**
 * # FUNCTION #
 * NULL(MssNullChr)νϡ
 */
void mssWriteNull(struct mssFPW *fp){
  mssWriteChr(MssNullChr,fp);
}

/**
 * # FUNCTION #
 * ߻νϡ
 * sepFlg򣱤˻ꤹȡ"HH:MM:SS"ν񼰤ǽϡ
 * ʳ"HHMMSS"ν񼰤ǽϡ
 */
void mssWriteTime(struct mssFPW *fp,int sepFlg){
  time_t  long_time;
  struct tm     *nt;
  char msg[100];

  time(&long_time);
  nt = localtime(&long_time);

  if(sepFlg){
    sprintf(msg, "%02d:%02d:%02d",
          nt->tm_hour,
          nt->tm_min,
          nt->tm_sec);
  }else{
    sprintf(msg, "%02d%02d%02d",
          nt->tm_hour,
          nt->tm_min,
          nt->tm_sec);
  }
  mssWriteStr(msg,fp);
}

/**
 * # FUNCTION #
 * դνϡ
 * sepFlg򣱤˻ꤹȡ"YYYY/MM/DD"ν񼰤ǽϡ
 * ʳ"YYYYMMDD"ν񼰤ǽϡ
 */
void mssWriteDate(struct mssFPW *fp,int sepFlg){
  time_t  long_time;
  struct tm     *nt;
  char msg[100];

  time(&long_time);
  nt = localtime(&long_time);

  /**/
  if(sepFlg){
    sprintf(msg, "%04d/%02d/%02d",
          nt->tm_year + 1900,
          nt->tm_mon + 1,
          nt->tm_mday);
  }else{
    sprintf(msg, "%04d%02d%02d",
          nt->tm_year + 1900,
          nt->tm_mon + 1,
          nt->tm_mday);
  }
  mssWriteStr(msg,fp);
}

/**
 * # FUNCTION #
 * ʸcntĤʸϤʸȤendStrϤ롣
 * Ϥʸʸδ֤ˤMssFieldDelimϤ롣
 * δؿϡ̾ǡԤϤ뤿Ѥ롣
 * 
 */
void mssWriteFld(char **str, int cnt, char *endStr, struct mssFPW *fp){
  int i;
  for(i=0; i<cnt-1; i++){
    mssWriteStr(*(str+i),fp);
    mssWriteDlm(fp);
  }
  mssWriteStr(*(str+i),fp);
  mssWriteStr(endStr,fp);
}
