
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "xmlからxmlTableへの変更"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define KEYT "一行の単位となるxmlのパス"
#define KEYC "ここで指定したパスがxmlTableの一行に対応する"

/*-f*/
#define FLDT "項目タグ名"
#define FLDC "項目として出力するタグ名を指定する"

/*-s*/
#define SPCT "文字列"
#define SPCC "テキスト内のスペースをどの文字列に置き換えるかを指定する"

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "xmlをxmlTableに変換する。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xml2xt -k /購買/顧客/日付/行 -f 商品,数量,金額 -i dat.xml -o rsl.xt\n\
xml2xt -k /購買/顧客/日付/行 -f /購買/顧客コード@value,商品 -i dat.xml -o rsl.xt\n\
xml2xt -k /購買/顧客/日付/行 -f 商品%n,数量%f,金額 -i dat.xml -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xt2xml,xt2txt,txt2xt"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
