/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 :  2004/06/08                                                  */
/*============================================================================*/

#include <musashi.h>

enum SVGelementType {
  SVG_SYMBOL, /* symbol element */
  SVG_RECT,   /* rect element */
  SVG_LINE,   /* line element */
};

/* ɸ¤ */
struct SVGcoord {
  double x;
  double y;
  double w;
  double h;
};

/* ɸ¤(from-to) */
struct SVGcoord2 {
  double x1;
  double y1;
  double x2;
  double y2;
};

/*
 * SVGʸ¤
 *
 * <symbol id="id" viewBox="0 0 10*c.w/c.h 10" preserveAspectRatio="none">
 *   <text x="(10*c.w/c.h)/2" y="8" font-size="8" text-anchor="middle">s</text>
 *   ### rFlg==1 ʤ<rect>ϽϤʤ
 *   <rect x="0" y="0" width="c.w" height="c.h" fill="none" stroke="black" stroke-width="1"/>
 * </symbol>
 *
 * ### vFlg==0 ʤ
 * <use x="c.x" y="c.y" width="c.w" height="c.h" xlink:href="#id"/>
 * ### vFlg==1 ʤ
 * <use x="0" y="0" width="c.w" height="c.h" xlink:href="#id" transform="translate(c.x+c.y,c.y) rotate(90)"/>
 *
 */
struct SVGstring {
  char  *id;
  struct SVGcoord c;   /* ɸ */
  int    vflg;         /* ľɽե饰 0ǿʿɽ */
  double swidth;       /* Ϥ (0ǰϤʤ) */
  char  *anchor;       /* l:() m: r:() */
  char  *s;            /* ʸ */
};

struct SVGrect {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGline {
  char  *id;
  struct SVGcoord2 c2;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /*  */
  char  *color;  /* ο (NULL"black") */
  char  *dash;   /* ") */
};

struct SVGsymbol {
  char  *id;
  struct SVGcoord c; /* viewBox */
  char  *par;   /* preserveAspectRatio */
};

struct SVGuse {
  struct SVGcoord c; /* viewBox */
  void   *add;       /* element address for xlink:href attribute */
  enum SVGelementType et; /* element type */
};


void writeSVGstartTag(double pwd, double pht,double wd, double ht, struct mssFPW *fpw);
void writeSVGendTag(struct mssFPW *fpw);

struct SVGcoord *initSVGcoord(double x, double y, double w, double h);
void freeSVGcoord(struct SVGcoord *c);
void showSVGcoord(struct SVGcoord *c);

struct SVGcoord2 *initSVGcoord2(double x1, double y1, double x2, double y2);
void freeSVGcoord2(struct SVGcoord2 *c);
void showSVGcoord2(struct SVGcoord2 *c);

struct SVGrect *initSVGrect( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGrect(struct SVGrect *rect);
void writeSVGrect(struct SVGrect *rect, struct mssFPW *fpw);
void showSVGrect(struct SVGrect *r);

struct SVGline *initSVGline( double x1, double y1, double x2, double y2, double swidth, char *color, char *dash, char *id);
void freeSVGline(struct SVGline *line);
void writeSVGline(struct SVGline *line, struct mssFPW *fpw);
void showSVGline(struct SVGline *l);

struct SVGstring *initSVGstring( double x, double y, double w, double h, int vflg, double swidth, char *anchor, char *id, char *s);
void freeSVGstring(struct SVGstring *str);
void writeSVGstring( struct SVGstring *str, struct mssFPW *fpw);
void showSVGstring(struct SVGstring *s);

struct SVGsymbol *initSVGsymbol(double x,double y, double w, double h, char *id, char *par);
void freeSVGsymbol(struct SVGsymbol *sym);
void writeSVGsymbolStartTag(struct SVGsymbol *s, struct mssFPW *fpw);
void writeSVGsymbolEndTag(struct mssFPW *fpw);

struct SVGuse *initSVGuse( double x,double y, double w, double h, void *add, enum SVGelementType et);
void freeSVGuse(struct SVGuse *use);
void writeSVGuse(struct SVGuse *use, struct mssFPW *fpw);

/********** 20 Shapes **********/
/***** Shape 0 -- square *****/
struct SVGsq {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGsq *initSVGsq( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGsq(struct SVGsq *sq);
void writeSVGsq(struct SVGsq *sq, struct mssFPW *fpw);
void showSVGsq(struct SVGsq *r);

/***** Shape 1 -- circle *****/
struct SVGcircle {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGcircle *initSVGcircle( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGcircle(struct SVGcircle *circle);
void writeSVGcircle(struct SVGcircle *circle, struct mssFPW *fpw);
void showSVGcircle(struct SVGcircle *r);

/***** Shape 2 -- rectangle *****/
struct SVGv_rect {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGv_rect *initSVGv_rect( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGv_rect(struct SVGv_rect *v_rect);
void writeSVGv_rect(struct SVGv_rect *v_rect, struct mssFPW *fpw);
void showSVGv_rect(struct SVGv_rect *r);

/***** Shape 3 -- funnel *****/
struct SVGfun {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGfun *initSVGfun( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGfun(struct SVGfun *fun);
void writeSVGfun(struct SVGfun *fun, struct mssFPW *fpw);
void showSVGfun(struct SVGfun *r);

/***** Shape 4 -- ellipse *****/
struct SVGell {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGell *initSVGell( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGell(struct SVGell *ell);
void writeSVGell(struct SVGell *ell, struct mssFPW *fpw);
void showSVGell(struct SVGell *r);

/***** Shape 5 -- i *****/
struct SVGi {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGi *initSVGi( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGi(struct SVGi *i);
void writeSVGi(struct SVGi *i, struct mssFPW *fpw);
void showSVGi(struct SVGi *r);

/***** Shape 6 -- diamond *****/
struct SVGdia {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGdia *initSVGdia( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGdia(struct SVGdia *dia);
void writeSVGdia(struct SVGdia *dia, struct mssFPW *fpw);
void showSVGdia(struct SVGdia *r);

/***** Shape 7 -- triangle *****/
struct SVGtri {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGtri *initSVGtri( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGtri(struct SVGtri *tri);
void writeSVGtri(struct SVGtri *tri, struct mssFPW *fpw);
void showSVGtri(struct SVGtri *r);

/***** Shape 8 -- cross *****/
struct SVGcross {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGcross *initSVGcross( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGcross(struct SVGcross *cross);
void writeSVGcross(struct SVGcross *cross, struct mssFPW *fpw);
void showSVGcross(struct SVGcross *r);

/***** Shape 9 -- hexagon *****/
struct SVGhex {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGhex *initSVGhex( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGhex(struct SVGhex *hex);
void writeSVGhex(struct SVGhex *hex, struct mssFPW *fpw);
void showSVGhex(struct SVGhex *r);

/***** Shape 10 -- crown *****/
struct SVGcrown {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGcrown *initSVGcrown( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGcrown(struct SVGcrown *crown);
void writeSVGcrown(struct SVGcrown *crown, struct mssFPW *fpw);
void showSVGcrown(struct SVGcrown *r);

/***** Shape 11 -- u *****/
struct SVGu {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGu *initSVGu( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGu(struct SVGu *u);
void writeSVGu(struct SVGu *u, struct mssFPW *fpw);
void showSVGu(struct SVGu *r);

/***** Shape 12 -- star *****/
struct SVGstar {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGstar *initSVGstar( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGstar(struct SVGstar *star);
void writeSVGstar(struct SVGstar *star, struct mssFPW *fpw);
void showSVGstar(struct SVGstar *r);

/***** Shape 13 -- arrow *****/
struct SVGarrow {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGarrow *initSVGarrow( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGarrow(struct SVGarrow *arrow);
void writeSVGarrow(struct SVGarrow *arrow, struct mssFPW *fpw);
void showSVGarrow(struct SVGarrow *r);

/***** Shape 14 -- fugo *****/
struct SVGfugo {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGfugo *initSVGfugo( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGfugo(struct SVGfugo *fugo);
void writeSVGfugo(struct SVGfugo *fugo, struct mssFPW *fpw);
void showSVGfugo(struct SVGfugo *r);

/***** Shape 15 -- tree *****/
struct SVGtree {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGtree *initSVGtree( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGtree(struct SVGtree *tree);
void writeSVGtree(struct SVGtree *tree, struct mssFPW *fpw);
void showSVGtree(struct SVGtree *r);

/***** Shape 16 -- house *****/
struct SVGhouse {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGhouse *initSVGhouse( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGhouse(struct SVGhouse *house);
void writeSVGhouse(struct SVGhouse *house, struct mssFPW *fpw);
void showSVGhouse(struct SVGhouse *r);

/***** Shape 17 -- male *****/
struct SVGmale {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGmale *initSVGmale( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGmale(struct SVGmale *male);
void writeSVGmale(struct SVGmale *male, struct mssFPW *fpw);
void showSVGmale(struct SVGmale *r);

/***** Shape 18 -- cone *****/
struct SVGcone {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGcone *initSVGcone( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGcone(struct SVGcone *cone);
void writeSVGcone(struct SVGcone *cone, struct mssFPW *fpw);
void showSVGcone(struct SVGcone *r);

/***** Shape 19 -- watch *****/
struct SVGwatch {
  char  *id;
  struct SVGcoord c;
  int    dflg;   /* ե饰 0褷ʤ */
  double swidth; /* Ϥ (0ǰϤʤ) */
  char  *color;  /* ɤĤ֤ (NULLɤĤ֤ʤ) */
};

struct SVGwatch *initSVGwatch( double x, double y, double w, double h, double swidth, char *color, char *id);
void freeSVGwatch(struct SVGwatch *watch);
void writeSVGwatch(struct SVGwatch *watch, struct mssFPW *fpw);
void showSVGwatch(struct SVGwatch *r);

