/*
 * setup2.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ᥤץ
 */


#include"types.h"
#include"lib.h"
#include"except.h"
#include"sp.h"
#include"mp.h"
#include"mm.h"
#include"interrupt.h"
#include"fs.h"
#include"console.h"
#include"proc.h"
#include"floppy.h"
#include"ata.h"
#include"device.h"
#include"serial.h"
#include"time.h"
#include"ext2_fs.h"
#include"keyboard.h"
#include"miscdev.h"
#include"test.h"


enum{
	CPU_FAMILY_OTHER=0,			/* ¾cpuեߥ꡼ */
	CPU_FAMILY_386=3,			/* 386ߴ */
	CPU_FAMILY_486=4,			/* 486ߴ */
	CPU_FAMILY_PENTIUM=5,		/* pentiumߴ */
	CPU_FAMILY_PENTIUMPRO=6,	/* pentiumproߴ */
	CPU_FAMILY_PENTIUM4=0xf		/* pentium4ߴ */
};


int cpu_family;		/* cpuեߥ꡼ */


/*
 * ɥ쥹饤20ӥåܤBIOS̵ˤƤΤͭˤ롣
 * return : 0,Error -1
 */
static int enable_a20()
{
	volatile int *test1,*test2;
	int i;


	/* Enable A20 */
	while(inb(KEYBOARD_STAT_REG)&2);
	outb(KEYBOARD_COMMAND_REG,0xad);	/* Disable keyboard */
	while(inb(KEYBOARD_STAT_REG)&2);
	outb(KEYBOARD_COMMAND_REG,0xd1);	/* Write to output */
	while(inb(KEYBOARD_STAT_REG)&2);
	outb(KEYBOARD_OUTPUT_REG,0xdf);		/* A20enable */
	while(inb(KEYBOARD_STAT_REG)&2);
	outb(KEYBOARD_COMMAND_REG,0xae);	/* Enable keyboard */
	while(inb(KEYBOARD_STAT_REG)&2);

	/* A20ͭˤʤäå */
	test1=(int*)0x00007c;
	test2=(int*)0x10007c;
	for(i=1;i<=2;++i)
	{
		*test1=i;
		if(*test2!=i)return 0;
	}

	return -1;
}


/*
 * int cpuid()
 * ֤ : С
 */
int cpuid();
asm(
"cpuid:"
	"movl	$1,%eax\n"
	"cpuid\n"
	"ret"
);


/*
 * 󥰤򳫻Ϥ
 * espĴƥɥ
 */
void start_tasking()
{
	asm volatile(
		"movl	%0,%%esp\n"
		"sti\n"
		"jmp	idle"
		::"i"(KERNEL_ESP_BEG)
	);
}


/*************************************************************************************************
 *
 * ͥν
 *
 *************************************************************************************************/

void main()
{
	/* 㳰ϥɥꤹ */
	init_except();

	/* Init tty */
	initConsole();
	init_com();
	switch(TTY)
	{
		case 1:
			write_tty=writeConsole;
			break;
		case 2:
			write_tty=write_com1;
			break;
		case 3:
			write_tty=write_com2;
			break;
	}

	/* TSSǥץɤ */
	set_tss(TSS_DES);

	/* Init cputask struct */
	init_cputask(0);

	/* cpuեߥ꡼Υå */
	cpu_family=(cpuid()>>8)&0xf;
	if(cpu_family<CPU_FAMILY_PENTIUM)
	{
		printk("This cpu is not supported.\n");
		idle();
	}

	/* ɥ쥹饤20ӥåܤͭˤ */
	if(enable_a20()==-1)
	{
		printk("A20 can't be enable. Boot stop!\n");
		idle();
	}

	/* fpuν */
	asm("fninit");

	/* ꡼ƥν */
	initMm();

	/* cpuåͤ¬ */
	printk("cpu0 clock = %d HZ\n",count_cpu_clock());

	/* ɥ(ǽ)ץ롣 */
	if(set_idle_proc(0)==-1)
	{
		printk("Fail set_idle_proc! cpu=%d.\n",0);
		idle();
	}

	/* ߤSMP */
	if(MFPS_addres)
	{
		if(init_mp()==-1)idle();
	}
	else init_sp();

	/* Init system call */
	init_syscall();
}


/* ǽΥ桼ץ¹ */
typedef struct{
	uint cs;
	uint para1;
	uint para2;
	uint para3;
	uint para4;
	uint esp;
	uint ss;
}EXEC_SYSCALL4_FRAME;

extern int syscall4(EXEC_SYSCALL4_FRAME);

void init()
{
	/* 桼ץư */
	switch(sys_fork())
    {
    	case -1:
    		printk("Faile sys_fork!\n");
    		idle();

    	case 0:
    		break;

    	default:
    		/* 󥰳 */
			start_tasking();
	}

	/* Init file system */
	init_fs();

	/* Init device system */
	if(init_device()==-1)
	{
		printk("Fail init_device!" );
		idle();
	}

	/* Init time */
	init_time();

	/* Set COM interrupt */
	set_com_intr();

	/* Init floppy drive */
	printk("Init FLOPPY drive\n");
	init_fd();

	/* Init ATA drive. */
	printk("Init ATA drive\n");
	initAta();

	/* 󥽡ΥǥХϿ */
	if(registConsole()!=0)
	{
		printk("Failed regist console!\n");
		idle();
	}

	/* NULLǥХϿ */
	if(registNullDev()!=0)
	{
		printk("Failed regist null device!\n");
		idle();
	}

	/* EXT2ե륷ƥν */
	if(initExt2tFs()==-1)
	{
		printk("Failed initExt2tFs\n");
		idle();
	}

	/* mount root filesystem. */
	if(mountRoot(ROOT_DEVICE,"ext2")==-1)
	{
		printk("Failed mount root file system\n");
		idle();
	}
	printk("Root device : %s\nRoot file system : ext2\n",ROOT_DEVICE);

	/* Init keyboard driver. */
	initKeyboard();

	/*
	 * ɸϤ򳫤
	 */
	if(sys_open("/dev/null",0)==-1)		/* ɸϡ̤ꡣ */
	{
		printk("Failed null device open!\n");
		idle();
	}
	if(sys_open("/dev/console",0)==-1)	/* ɸϡ */
	{
		printk("Failed console open!\n");
		idle();
	}
	if(sys_open("/dev/console",0)==-1)	/* ɸ२顼 */
	{
		printk("Failed console open!\n");
		idle();
	}

	/*
	 * 桼ץư롣
	 */

	/* եμ¹ԡ */
	{
		char *path="/test";
		EXEC_SYSCALL4_FRAME frame={
			KERNEL_CODE_DES,	/* cs */
			SYS_EXEC,			/* para1 */
			(uint)path,			/* para2 */
			(uint)NULL,			/* para3 */
			(uint)NULL,			/* para4 */
			0,					/* esp,sys_exec()ꤵ롣 */
			0					/* ss */
		};


		if(syscall4(frame)==-1);
			printk("Failed sys_exec\n");
	}

	idle();
}
