/*
 * proc.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ץطإåե
 */


#ifndef proc_h
#define proc_h


#include"segment.h"


#define FPUSAVE_SIZE 108		/* FPU֥ǡʥХñ̡ */


#ifndef ASM_FILE


enum{
	MAX_CHILD=8,		/* Max number of child processes */
};

/* ץ¤ */
typedef struct PROC{
	struct PROC *wait_next;		/* next link for wait,WAIT_QUEUETIMERnextƱ */
	struct PROC *wait_prev;		/* prev link for wait,WAIT_QUEUETIMERnextƱ */
	int timer_count;			/* Counter for timer */
	int timer_type;				/* Timer type */
	struct PROC *next;			/* Schedule linkμΥץ */
	struct PROC *prev;			/* Schedule linkΥץ */
	uint esp;					/* Save contextΥȥåesp */
	int count_child;			/* Number of child processes */
	struct PROC *parent;		/* Parent process */
	struct PROC *child;			/* Child process */
	struct PROC *brother;		/* Link of brother process */
	int cpu;					/* running cpu number ƯƤʤ-1ʲ*/
	void *mm_struct;			/* ꡼¤Υɥ쥹 */
	void *file_struct;			/* ե빽¤Υɥ쥹 */
}PROC;

/* ץȥ塼¤ */
typedef struct{
	PROC *wait_next;		/* ȥ󥯤μΥץ,PROCwait_nextƱ */
	PROC *wait_prev;		/* ȥ󥯤Υץ,PROCwait_prevƱ */
	int flag;				/* Wait flag */
	int gate;				/* Lock gate */
}WAIT_QUEUE;

/* ޡԤѹ¤ */
typedef struct{
	PROC *proc;		/* Ԥץ */
	int flag;		/* ॢȥե饰 */
}WAIT_INTR;

/* cpuȤΥ¤ */
typedef struct CPU{
	int cpu;				/* number of cpu */
	PROC *current_task;		/* ߤβƯprocess */
	uint proc_num;			/* ưץ */
	struct CPU *next;
	struct CPU *prev;
	int gate;				/* Lock gate */
}CPU;


extern CPU cputask[];


/*
 * Get current cpu number
 * returns : current cpu number
 */
extern inline int get_current_cpu()
{
	int result;


	asm volatile(
		"xorl	%%eax,%%eax\n"\
		"str	%%ax\n"\
		"subl	%1,%%eax\n"\
		"shrl	$3,%%eax"
		:"=a"(result):"i"(TSS_DES)
	);

	return result;
}

/*
 * Get current task
 * return : Current process
 */
extern inline PROC *get_current_task()
{
	return cputask[get_current_cpu()].current_task;
}



extern void add_to_schedule(PROC*);
extern void del_from_schedule(PROC*);
extern void wait_proc(WAIT_QUEUE*);
extern void wake_proc(WAIT_QUEUE*);
extern int wait_intr(WAIT_INTR*,int);
extern int wake_intr(WAIT_INTR*);
extern int init_cputask(int);
extern int set_idle_proc(int);
extern void set_tss(int);
extern void start_tasking();
extern int sys_fork();
extern int sys_exit();
extern int sys_exec();


#endif


#endif
