/*
 * mm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꡼ץ
 *
 * ǡΡ
 * 	ǡ̾phis_link
 * 	ؿlinkPhysTable()
 * 	unlinkPhysTable()
 * 	allocKernelPage()
 * 	allocUserPage()
 *		phis_linkξ֤ǥڡ꡼¾ץ鲣ꤵΤǡڡơ֥륨ȥ꡼ѹ
 * 		phis_linkäPHYS_MEM_TABLǤpage_tbl_addƱɬפ롣
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"lock.h"
#include"interrupt.h"
#include"proc.h"
#include"mp.h"
#include"segment.h"
#include"errno.h"
#include"fs.h"
#include"device.h"
#include"mm.h"
#include"test.h"


static int backupPage(void*);


/***********************************************************************************
 *
 * ʪ꡼饹
 *
 ***********************************************************************************/

/*
 * ʪ꡼ơ֥빽¤
 * Page
 */
typedef struct PHYS_MEM_TABL{
	short ref_count;			/* reference count */
	ushort heap_num;			/* Heap number */
	PROC *proc;					/* ƤƤץ */
	struct PHYS_MEM_TABL *next;
	struct PHYS_MEM_TABL *prev;
}PHYS_MEM_TABL;


/*
 * PRIVATE
 * ꡼ơ֥
 * freeTop (kernel mem)  (user mem) freeEnd
 * usedTop (new kernel mem)  (old kernel mem)  (new user mem)  (old user mem) usedEnd
 */
static PHYS_MEM_TABL freeTop={0,0,NULL,NULL,NULL};		/* ʪ꡼󥯥ȥå */
static PHYS_MEM_TABL freeEnd={0,0,NULL,NULL,NULL};		/* ʪ꡼󥯥 */
static PHYS_MEM_TABL usedTop={0,0,NULL,NULL,NULL};		/* ʲġʪ꡼󥯥ȥå */
static PHYS_MEM_TABL usedEnd={0,0,NULL,NULL,NULL};		/* ʲġʪ꡼󥯥 */
static PHYS_MEM_TABL *usedUsrNew=NULL;					/* Υ桼ʪ꡼ */
static int physPageGate=0;								/* PHYS_MEM_TABL lock gate */

/*
 * PRIVATE
 * ꡼setup.S
 */
uint all_memory_size;


/*
 * PUBLIC
 * ʪ꡼ɥ쥹 PHYS_MEM_TABL ɥ쥹֤
 * parameters : Physical address
 * return : PHYS_MEM_TABL address
 */
extern inline PHYS_MEM_TABL *getPhysTableFromAddr(void *addr)
{
	return (PHYS_MEM_TABL*)((uint)addr/PAGE_SIZE*sizeof(PHYS_MEM_TABL)+PHYSICAL_PAGE_TABLE_ADD);
}


/*
 * PUBLIC
 * PHYS_MEM_TABL addressʪ꡼ɥ쥹֤
 * parameters : PHYS_MEM_TABL address
 * return : Physical address
 */
extern inline void *getAddrFromPhysTable(PHYS_MEM_TABL *memtable)
{
	return (void*)(((uint)memtable-PHYSICAL_PAGE_TABLE_ADD)/sizeof(PHYS_MEM_TABL)*PAGE_SIZE);
}


/*
 * PUBLIC
 * ʪ꡼ڡλȥȤ䤹
 * ȥ2ʾϳƥץ򥯥ꥢ롣
 * parameters : ʪɥ쥹
 */
static void linkPhysTable(uint addr)
{
	PHYS_MEM_TABL *p;


	p=getPhysTableFromAddr((void*)addr);

	enter_spinlock(&physPageGate);
	{
		if(++p->ref_count==1)
		{
			/* used link˲ä롣 */
			if(addr<KERNEL_DATA_END)
			{
				p->prev=&usedTop;
				p->next=usedTop.next;
				usedTop.next=p;
				p->next->prev=p;
			}
			else
			{
				p->prev=usedUsrNew->prev;
				p->next=usedUsrNew;
				usedUsrNew->prev=p;
				p->prev->next=p;
				usedUsrNew=p;
			}

			p->proc=get_current_task();
		}
		else if(p->ref_count==2)
		{
			/* Used link */
			p->prev->next=p->next;
			p->next->prev=p->prev;
			if(usedUsrNew==p)usedUsrNew=p->next;

			p->proc=NULL;
		}
	}
	exit_spinlock(&physPageGate);
}


/*
 * PUBLIC
 * ȥȤ򸺤餷ʪ꡼ڡ롣
 * parameters : ʪɥ쥹
 */
static void unlinkPhysTable(uint addr)
{
	PHYS_MEM_TABL *p;


	p=getPhysTableFromAddr((void*)addr);

	enter_spinlock(&physPageGate);
	{
		/* ˻ȤƤʤޤϳԲĤΥڡ */
		if(--p->ref_count<0)
			p->ref_count=0;
		else if(p->ref_count==0)
		{
			/* Used link */
			p->prev->next=p->next;
			p->next->prev=p->prev;
			if(usedUsrNew==p)usedUsrNew=p->next;

			if(addr<KERNEL_DATA_END)
			{
				p->next=freeTop.next;
				p->prev=&freeTop;
				freeTop.next=p;
				p->next->prev=p;
			}
			else
			{
				p->prev=freeEnd.prev;
				p->next=&freeEnd;
				freeEnd.prev=p;
				p->prev->next=p;
			}

			p->heap_num=0;
			p->proc=NULL;
		}
	}
	exit_spinlock(&physPageGate);
}


/*
 * PUBLIC
 * ֤ͥʪڡƤ롣
 * ƤڡϲԲ
 * return : Allocate addres or NULL
 */
static void *allocKernelPage()
{
	void *address=NULL;
	bool used=0;
	PHYS_MEM_TABL *p;


	enter_spinlock(&physPageGate);
	{
		p=freeTop.next;
		if((p!=&freeEnd)&((address=getAddrFromPhysTable(p))<(void*)KERNEL_DATA_END))
		{
			p->ref_count=1;
			freeTop.next=p->next;
			p->next->prev=&freeTop;
			p->next=p->prev=p;
		}
		else if(((p=usedTop.next)!=&usedEnd)&(usedUsrNew!=p))
		{
			address=getAddrFromPhysTable(p);
			usedTop.next=p->next;
			p->next->prev=&usedTop;
			p->next=p->prev=p;
			used=1;
		}
	}
	exit_spinlock(&physPageGate);

	/* ꡼ƤХååפ롣 */
	if(used&&(backupPage(address)==-1))return NULL;

	return address;
}


/*
 * PUBLIC
 * 桼֤ʪڡƤ롣
 * Ƥڡϲ
 * return : Allocate addres or error=NULL
 */
static void *allocUserPage()
{
	void *addr=NULL;
	PHYS_MEM_TABL *p;


	for(;;)
	{
		if((p=freeEnd.prev)!=&freeTop)
		{
			enter_spinlock(&physPageGate);

			if(p==freeEnd.prev)
			{
				addr=(void*)getAddrFromPhysTable(p);
				p->ref_count=1;

				/* ե꡼󥯤 */
				freeEnd.prev=p->prev;
				p->prev->next=&freeEnd;

				/* 󥯤˲ä롣 */
				if(addr<(void*)KERNEL_DATA_END)
				{
					p->prev=&usedTop;
					p->next=usedTop.next;
					usedTop.next=p;
					p->next->prev=p;
				}
				else
				{
					p->prev=usedUsrNew->prev;
					p->next=usedUsrNew;
					usedUsrNew->prev=p;
					p->prev->next=p;
					usedUsrNew=p;
				}

				p->proc=get_current_task();

				exit_spinlock(&physPageGate);

				break;
			}

			exit_spinlock(&physPageGate);
		}
		else if((p=usedEnd.prev)!=&usedTop)
		{
			enter_spinlock(&physPageGate);

			if(p==usedEnd.prev)
			{
				/* 󥯤 */
				addr=(void*)getAddrFromPhysTable(p);
				usedEnd.prev=p->prev;
				p->prev->next=&usedEnd;
				if(usedUsrNew==p)usedUsrNew=&usedEnd;

				exit_spinlock(&physPageGate);

				/* ꡼Ƥback up */
				if(backupPage(addr)==-1)return NULL;

				break;
			}

			exit_spinlock(&physPageGate);
		}
		else break;
	}

	return addr;
}


/*
 * PUBLIC
 * ʪ꡼ơ֥롣
 */
static void initPhysMemTable()
{
	int i,last;
	PHYS_MEM_TABL *p=(PHYS_MEM_TABL*)PHYSICAL_PAGE_TABLE_ADD;


	/* ǽ1Mbyteʬ꡼Ƥ0ˡ */
	memset(p,0,0x100000/PAGE_SIZE*sizeof(PHYS_MEM_TABL));

	/* Ĥե꡼ꤹ롣 */
	for(i=0x100000/PAGE_SIZE,last=all_memory_size/PAGE_SIZE;i<last;++i)
	{
		p[i].ref_count=0;
		p[i].heap_num=0;
		p[i].proc=NULL;
		p[i].next=&p[i+1];
		p[i].prev=&p[i-1];
	}
	freeTop.next=&p[0x100000/PAGE_SIZE];
	freeEnd.prev=&p[i-1];
	p[0x100000/PAGE_SIZE].prev=&freeTop;
	p[i-1].next=&freeEnd;

	/* ꡼ơ֥ʬ꡼ƤʲԲġˡ */
	last=ROUNDUP(PHYSICAL_PAGE_TABLE_ADD+all_memory_size/PAGE_SIZE*sizeof(PHYS_MEM_TABL),PAGE_SIZE)/PAGE_SIZE;
	if(&p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE]==freeTop.next)
		freeTop.next=&p[last];
	else p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE-1].next=&p[last];

	/* Used link롣 */
	usedTop.next=&usedEnd;
	usedEnd.prev=&usedTop;
	usedUsrNew=&usedEnd;
}


/*
 * PUBLIC
 * Find size of all physical memory
 */
static uint findAllMemsize()
{
	enum{EXIST_MEM_SIZE=0x800000};		/* ꡼¬ñ */

	uint volatile *point;


	/* ꡼ñ̤Ȥ¬ꤹ*/
	for(point=(uint*)EXIST_MEM_SIZE-1;;point+=EXIST_MEM_SIZE/sizeof(uint))
	{
		*point=0x5a5a5a5a;
		if(*point!=0x5a5a5a5a)break;
		else
		{
			*point=0xf0f0f0f0;
			if(*point!=0xf0f0f0f0)break;
		}
	}

	return (all_memory_size=(uint)point-EXIST_MEM_SIZE+sizeof(uint));
}


/***********************************************************************************
 *
 * ꡼ȥ饹
 *
 ***********************************************************************************/

enum{
	HEAP_NUM=10,				/* kmallocMEM¤κ */
};


typedef struct FREE{
	char* last;
	struct FREE *prev;
	struct FREE *next;
}FREE;

typedef struct{
	uint size;
	FREE *free;
	int gate;
}HEAP;


/* kfreeʼ */
static FREE guard[HEAP_NUM];

/*
 * PRIVATE
 * kmallocѹ¤
 */
static HEAP heap[]={
	{0,NULL,0},
	{0x10,  &guard[1], 0},
	{0x20,  &guard[2], 0},
	{0x40,  &guard[3], 0},
	{0x80,  &guard[4], 0},
	{0x100, &guard[5], 0},
	{0x200, &guard[6], 0},
	{0x400, &guard[7], 0},
	{0x800, &guard[8], 0},
	{0x1000,&guard[9], 0},
};


/*
 * GLOBAL
 * 2Ѿ襵Ȥ˥ڡ꡼ʬ䤹
 * ϥڡ
 * parameters : Size by byte
 * return : address
 */
void *kmalloc(size_t size)
{
	char *addr=NULL;
	int i;


	if((size==0)||(size>PAGE_SIZE))return NULL;		/* Require size is over */

	for(i=1;size>heap[i].size;++i);					/* Require size=heap[i].size */

	enter_spinlock(&heap[i].gate);
	{
		if(heap[i].free==&guard[i])
		{
			if((heap[i].free=(FREE*)allocKernelPage())==NULL)goto OUT;

			/*
			 * Ȥaddress狼褦ˤ
			 */
			getPhysTableFromAddr((void*)heap[i].free)->heap_num=i;

			heap[i].free->prev=&guard[i];
			heap[i].free->next=&guard[i];
			guard[i].prev=heap[i].free;
			guard[i].next=heap[i].free;
			heap[i].free->last=(char*)heap[i].free+PAGE_SIZE;
		}

		addr=(char*)heap[i].free->last-heap[i].size;

		if(heap[i].free==(FREE*)addr)
		{
			heap[i].free=((FREE*)addr)->next;
			((FREE*)addr)->prev->next=((FREE*)addr)->next;
			((FREE*)addr)->next->prev=((FREE*)addr)->prev;
		}
		else heap[i].free->last=addr;
	}
OUT:
	exit_spinlock(&heap[i].gate);

	return addr;
}


/*
 * GLOBAL
 * ꡼
 * parameters : Address
 */
void kfree(void *ptr)
{
	uint i;
	FREE *p,*end;


	if(ptr==NULL)return;

	if((i=(int)getPhysTableFromAddr(ptr)->heap_num)==0)return;

	enter_spinlock(&heap[i].gate);
	{
		/* Free linkϾ */
		for(p=heap[i].free;p!=&guard[i];p=p->next)
			if(p>(FREE*)ptr)break;

		/* Link */
		p->prev->next=(FREE*)ptr;
		((FREE*)ptr)->prev=p->prev;
		((FREE*)ptr)->next=p;
		((FREE*)ptr)->last=(char*)ptr+heap[i].size;
		p->prev=(FREE*)ptr;

		/* ɥ쥹³ƤХ꡼Ĥʤ */
		end=((FREE*)ptr)->prev;
		do
		{
			p=p->prev;

			if(p->last==(char*)p->next)
			{
				p->last=p->next->last;
				p->next=p->next->next;
			}

			/* ꡼PAGE_SIZEʤڡ */
			if(!((uint)p&(PAGE_SIZE-1))&&(p->last>=(char*)p+PAGE_SIZE))
			{
				if(p->last>(char*)p+PAGE_SIZE)
				{
					p->prev->next=(FREE*)((char*)p+PAGE_SIZE);
					p->prev->next->next=p->next;
					p->prev->next->prev=p->prev;
					p->prev->next->last=p->last;
					p->next->prev=p->prev->next;
				}
				else
				{
					p->prev->next=p->next;
					p->next->prev=p->prev;
				}

				unlinkPhysTable((uint)p);

				break;
			}

		}while(p!=end);

		/* Free memory link Ƭ */
		heap[i].free=guard[i].next;
	}
	exit_spinlock(&heap[i].gate);
}


/***********************************************************************************
 *
 * ڡ̥饹
 *
 * ̵§
 *  ȤƤʤڡȥ꡼ɬꥢ롣
 *
 ***********************************************************************************/

enum{
	PAGE_DIR_SIZE=0x400000,		/* Page directory size */

	/* Page entry flag */
	PAGE_PRESEN=		0x1,	/* Is presence */
	PAGE_RW=			0x2,	/* Is read and write,not read only */
	PAGE_USER=			0x4,	/* Privilege is user,not supervisor */
	PAGE_CASH_DISABLE=	0x10,	/* Disable cash,not able cash */
	PAGE_4M=			0x80,	/* Page size is 4M,not 4K */

	/* ڡȥ꡼ΰѥե饰 */
	PT_COPY_ON_WRITE=0x200,		/* ԡ饤ȥե饰 */
};


typedef struct{
	uint *pageDir;
	int pageDirGate;		/* ڡǥ쥯ȥåȡ */
	uint lastPageAddr;		/* ƺѤߥڡ饹ȥɥ쥹+1 */
}MM_STRUCT;


/*
 * PUBLIC
 * ɥ쥹ڡǥ쥯ȥꥨȥ꡼ɥ쥹롣
 * parameters : ɥ쥹,ڡǥ쥯ȥꥢɥ쥹
 * return : ڡǥ쥯ȥꥢɥ쥹
 */
extern inline uint *getPageDirEntryAddr(uint addr,uint *page_dir)
{
	return &page_dir[addr>>22];
}


/*
 * PUBLIC
 * ɥ쥹ڡơ֥륨ȥ꡼ɥ쥹롣
 * parameters : ɥ쥹,ڡơ֥륢ɥ쥹
 * return : ڡɥ쥹
 */
extern inline uint *getPageEntryAddr(uint addr,uint *ptbl)
{
	return &ptbl[(addr>>12)&0x3ff];
}


/***********************************************************************************
 *
 * ڡХååץ饹
 *
 ***********************************************************************************/

/*
 * Хååץڡξ
 * ǥХƬ¸Хåեɤ߽Ф
 */
typedef struct{
	uchar refCount;		/* ȥ󥿡 */
	uchar pageAttr;		/* ڡ° */
}BACKUP_STATE;


enum{
	PT_TYPE_PAGING=0x9a,						/* ڡХååץǥХѡƥֹʲ */
	PB_START_SECTER=2,							/* Ѳĥϥǥå */
	PB_STAT_SIZE=PAGE_SIZE/sizeof(BACKUP_STATE),/* Хåå׾Хåե */
	EMPTY_PB_SIZE=PAGE_SIZE/sizeof(uint),
};


typedef struct{
	int next;					/* index */
	int gate;					/* ԥå */
	uint index[EMPTY_PB_SIZE];
}PAGE_BACKUP;

typedef struct{
	uint current;			/* ߤΥХåå׾Хåեγ֥å͡ */
	BACKUP_STATE state[PB_STAT_SIZE];
}STATE_BUFF;


static PAGE_BACKUP pageBackup={0,0};	/* PRIVATE,ڡХåå׶ΰ襤ǥå */
static STATE_BUFF stateBuff;			/* PRIVATE,ХååץХåե */
static int pbDin;						/* PRIVATE,ХååץǥХ inode */
static int pbSectors;					/* PRIVATE,ڡ/ */
static int pbTop;						/* PRIVATE,ǽΥХååץ */
static int pbNumPerStateBuff;			/* PRIVATE,ƥȥХåե˳ƤХååץ */
static int stateSectors;				/* PRIVATE,ƥȥХåե/ */


/*
 * PRIVATE
 * ХååץڡΥɥ쥹롣
 * parameters : backup page store block
 * return : backup state structure address or error=NULL
 */
static BACKUP_STATE *getBackupState(uint block)
{
	int state_blk;


	/* ߤΥơȥХåեˤ뤫ǧ */
	if((state_blk=(block-pbTop)/pbNumPerStateBuff)!=stateBuff.current)
	{
		if(read_direct(pbDin,stateBuff.state,stateSectors,stateBuff.current+PB_START_SECTER)!=stateSectors)
			return NULL;
		if(write_direct(pbDin,stateBuff.state,stateSectors,state_blk+PB_START_SECTER)!=stateSectors)
			return NULL;
	}

	return &stateBuff.state[((block-pbTop)%pbNumPerStateBuff)/pbSectors];
}


/*
 * PRIVATE
 * ڡХååפ롣
 * return : ֥å or error=-1
 */
static int getEmptyBackup()
{
	int blk;


	enter_spinlock(&pageBackup.gate);
	{
		if((blk=pageBackup.index[pageBackup.next])==0)return -1;		/* ֥åʤ */

		if(pageBackup.next++==EMPTY_PB_SIZE)
		{
			if(read_cache(pbDin,pageBackup.index,pbSectors,blk)!=pbSectors)return -1;
			pageBackup.next=0;
		}
	}
	exit_spinlock(&pageBackup.gate);

	return blk;
}


/*
 * PRIVATE
 * ڡХååפɲä롣
 * parameters : ڡХååץ֥å
 * return : 0 or error=-1
 */
static int addEmptyBackup(int blk)
{
	enter_spinlock(&pageBackup.gate);
	{
		if(--pageBackup.next<0)
		{
			if(write_cache(pbDin,pageBackup.index,pbSectors,blk)!=pbSectors)return -1;
			pageBackup.next=EMPTY_PB_SIZE;
		}

		pageBackup.index[pageBackup.next]=blk;
	}
	exit_spinlock(&pageBackup.gate);

	return 0;
}


/*
 * PUBLIC
 * ڡХååץǥХλȲ1䤹
 * parameters : block number
 * return : 0 or error=-1
 */
static int incrementBackupCount(uint block)
{
	BACKUP_STATE *state;


	if((state=getBackupState(block))==NULL)return -1;
	++state->refCount;

	return 0;
}


/*
 * PUBLIC
 * ڡХååץǥХλȲ1餹
 * parameters : block number
 * return : 0 or error=-1
 */
static int decrementBackupCount(uint block)
{
	BACKUP_STATE *state;

	if((state=getBackupState(block))==NULL)return -1;
	if(--state->refCount==0)
		addEmptyBackup(block);

	return 0;
}


/*
 * PUBLIC
 * Back up used page into page store device
 * parameters : physical address
 * returns : 0 or Error number
 */
static int backupPage(void *addr)
{
	PROC *proc;
	uint *pdir;
	uint *page_entry;
	int blk;


	proc=getPhysTableFromAddr(addr)->proc;
	pdir=getPageDirEntryAddr((uint)addr,((MM_STRUCT*)proc->mm_struct)->pageDir);
	page_entry=getPageEntryAddr((uint)addr,(uint*)(*pdir&~(PAGE_SIZE-1)));

	/* page tableԺߤ */
	*page_entry&=~PAGE_PRESEN;

	/* process¹ʤpage tableTBLեå夹 */
	if((proc->cpu!=get_current_cpu())&&(cputask[proc->cpu].current_task==proc))
		issue_interrupt_to_cpu(proc->cpu,FLASH_PAGEDIR_VECT);

	/* Store page */
	if((blk=getEmptyBackup())==0)goto ERR;
	if(write_cache(pbDin,addr,pbSectors,blk)!=pbSectors)goto ERR;
	incrementBackupCount(blk);
	*page_entry=blk;

	return 0;

ERR:
	*page_entry|=PAGE_PRESEN;

	return -1;
}


/*
 * PUBLIC
 * ڡХååץǥХ꡼˽᤹
 * parmeters : memory buffer,device block
 * return : 0 or error=-1
 */
static int restorePage(void *buf,uint blk)
{
	/* ǥХɤ߹ߡ */
	if(read_cache(pbDin,buf,pbSectors,blk)!=pbSectors)return -1;

	/* ȥ󥿤򸺤餹 */
	decrementBackupCount(blk);

	return 0;
}


/*
 * PUBLIC
 * ڡХååѥǥХΥޥȡ
 * parameters : device path
 * return : 0 or error=-1
 */
static int mountBackupDev(const char *dev_path)
{
	int fd;
	int state_num;
	DEV_STAT dev_stat;
	uint i,j,last,index;


	/* Device open */
	if((fd=sys_open(dev_path,0))==-1)return -1;
	if((pbDin=get_inode(fd))==-1)return -1;

	/* ѡƥ󥿥פγǧ */
	if(get_dev_stat(pbDin,&dev_stat)==-1)return -1;
	if(dev_stat.prt_type!=PT_TYPE_PAGING)return -1;

	stateSectors=pbSectors=PAGE_SIZE/dev_stat.sect_size;
	pbNumPerStateBuff=pbSectors*PB_STAT_SIZE;

	/* ڡ¸η׻ */
	{
		int tmp;

		tmp=pbSectors*(dev_stat.sect_size/sizeof(BACKUP_STATE))+1;
		state_num=(dev_stat.all_sect+tmp-1)/tmp;
	}
	memset(stateBuff.state,0,PB_STAT_SIZE*sizeof(BACKUP_STATE));
	pbTop=state_num+PB_START_SECTER;
	stateBuff.current=0;

	/* ڡХååפꡣ */
	last=dev_stat.all_sect;
	index=pbTop+pbSectors*(EMPTY_PB_SIZE-1);
	j=0;
	for(i=index+pbSectors;i<last;i+=pbSectors)
	{
		pageBackup.index[j++]=i;

		if(j>=EMPTY_PB_SIZE)
		{
			j=0;
			if(write_direct(pbDin,pageBackup.index,pbSectors,index)!=pbSectors)return -1;
			index=i;

			/* ʹԾɽ */
			printk("Mount page backup device %d%%\r",i/(last/100));
		}
	}
	pageBackup.index[j]=0;
	if(write_direct(pbDin,pageBackup.index,pbSectors,index)!=pbSectors)return -1;

	/* ʹԾɽ */
	printk("Mount page backup device 100%%\n");

	/* ǽΥڡХååץǥåꡣ */
	i=PB_START_SECTER;
	for(j=0;j<EMPTY_PB_SIZE;++j)
	{
		if(i>=last)
		{
			pageBackup.index[j]=0;
			break;
		}
		pageBackup.index[j]=i;
		i+=pbSectors;
	}

	return 0;
}


/***********************************************************************************
 *
 * ڡ饹
 *
 * ڡȤξ
 * ȥȤǤ뤳
 *
 ***********************************************************************************/

/*
 * PRIVATE
 * ڡȥ꡼򥳥ԡ饤Ȥꤹ롣
 * ȥ꡼ɬ¸ߤƤΤȤ롣
 * parameters : page entry address
 */
extern inline void setCow(uint *page_entry)
{
	if(*page_entry&(PAGE_RW|PT_COPY_ON_WRITE))
	{
		if((*page_entry&PAGE_PRESEN)==0)				/* Хåå */
			incrementBackupCount(*page_entry);
		else
		{
			*page_entry&=~PAGE_RW;						/* ߶ػߤˤ롣 */
			*page_entry|=PT_COPY_ON_WRITE;				/* ԡ饤ȥե饰ꤹ롣 */
			linkPhysTable(*page_entry&~(PAGE_SIZE-1));
		}
	}
}


/*
 * PRIVATE
 * ڡȥڡơ֥롣
 * ڡǥ쥯ȥñ̤ǳ롣
 * Ƥ줿ڡϥɥ쥹Ϣ³ƤȤơ롣
 * parameters : ڡǥ쥯ȥꥢɥ쥹,Ϥɥ쥹,ɥ쥹
 */
extern inline void releasePage(uint *pdir,uint begin,uint end)
{
	uint *dir_ent,*ptbl;
	uint addr;
	int i;


	for(addr=begin;addr<end;addr+=PAGE_DIR_SIZE)
	{
		if(*(dir_ent=getPageDirEntryAddr(addr,pdir))==0)continue;

		ptbl=(uint*)(*dir_ent&~(PAGE_SIZE-1));

		i=0;
		while(ptbl[i]==0)++i;
		for(;i<PAGE_SIZE/sizeof(uint);++i)
		{
			if(ptbl[i]&PAGE_PRESEN)unlinkPhysTable(ptbl[i]&~(PAGE_SIZE-1));		/* ڡ¸ߤ롣 */
			else if(ptbl[i]!=0)decrementBackupCount(ptbl[i]);					/* ڡХååפƤ롣 */
			else break;															/* ڡƤƤʤ */
		}

		/* ڡơ֥γ */
		unlinkPhysTable((uint)ptbl);
		*dir_ent=0;
	}
}


/*
 * GLOBAL
 * flash page directory
 * parameters : page directory address
 */
extern inline void flashPageDir(uint *pdir)
{
	asm volatile(
		"movl	%%eax,%%cr3"
		::"a"(pdir)
	);
}


/*
 * GLOBAL
 * forkˤ꡼ƥȤ򥳥ԡ
 * parameters : Destination MM_STRUCT,Return stack offset
 * return : New MM_STRUCT address or error=NULL
 */
void *forkPage(void *org_mm,void **stack)
{
	void *user_stack;
	uint *pdir,*ptbl,*org_ptbl;
	MM_STRUCT *mmstruct;
	int i,j;


	/* ꡼¤ΤƤ롣 */
	if((mmstruct=(MM_STRUCT*)kmalloc(sizeof(MM_STRUCT)))==NULL)return NULL;
	mmstruct->pageDirGate=0;

	/* ƤΥڡǥ쥯ȥҤ˥ԡ롣 */
	if((pdir=(uint*)allocKernelPage())==NULL)return NULL;
	memcpy(pdir,((MM_STRUCT*)org_mm)->pageDir,PAGE_SIZE);
	mmstruct->pageDir=pdir;

	/* ͥ륹åƤ롣 */
	if((ptbl=(uint*)allocKernelPage())==NULL)goto ERR;
	pdir[KERNEL_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW;
	org_ptbl=(uint*)(*getPageDirEntryAddr(KERNEL_STACK_BEG,((MM_STRUCT*)org_mm)->pageDir)&~(PAGE_SIZE-1));
	if((*stack=allocKernelPage())==NULL)goto ERR;
	memcpy(*stack,(void*)(org_ptbl[PAGE_SIZE/sizeof(PAGE_SIZE)-1]&~(PAGE_SIZE-1)),PAGE_SIZE);
	ptbl[PAGE_SIZE/sizeof(PAGE_SIZE)-1]=(uint)*stack|PAGE_PRESEN|PAGE_RW;
	memset(ptbl,0,PAGE_SIZE-sizeof(uint));

	/*
	 * Userΰ򥳥ԡ饤Ȥꤹ롣
	 * ƤΥڡơ֥륨ȥ꡼񤭹߲Ĥʤ顢񤭹ԲĤˤƥԡ饤ȥե饰ꤹ롣
	 * ҤΥڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤹ롣
	 * 桼åΤڡơ֥ȥ桼åڡϿ˳Ƥ롣
	 */
	enter_spinlock(&((MM_STRUCT*)org_mm)->pageDirGate);
	{
		for(i=USER_BEG/PAGE_DIR_SIZE,j=0;i<USER_STACK_BEG/PAGE_DIR_SIZE;++i)
		{
			if(pdir[i]==0)break;

			org_ptbl=(uint*)(pdir[i]&~(PAGE_SIZE-1));
			for(j=0;j<PAGE_SIZE/sizeof(uint);++j)
			{
				if(org_ptbl[j]==0)break;
				setCow(&org_ptbl[j]);
			}

			pdir[i]|=PT_COPY_ON_WRITE;
		}
		mmstruct->lastPageAddr=(i-1)*PAGE_DIR_SIZE+j*PAGE_SIZE;
	}
	exit_spinlock(&((MM_STRUCT*)org_mm)->pageDirGate);

	/* 桼åγơ */
	if((ptbl=(uint*)allocKernelPage())==NULL)goto ERR;
	if((user_stack=allocUserPage())==NULL)goto ERR2;
	if(pdir[USER_STACK_BEG/PAGE_DIR_SIZE]!=0)
	{
		org_ptbl=(uint*)(pdir[USER_STACK_BEG/PAGE_DIR_SIZE]&~(PAGE_SIZE-1));

		/* ԡ饤ȤΥե饰ΩƤ롣 */
		i=PAGE_SIZE/sizeof(uint)-2;
		if(org_ptbl[i]!=0)
		{
			while(i>=0)
			{
				setCow(&org_ptbl[i]);
				if(org_ptbl[--i]==0)break;
			}
		}

		memcpy(ptbl,org_ptbl,PAGE_SIZE);
		memcpy(user_stack,(void*)(org_ptbl[PAGE_SIZE/sizeof(uint)-1]&~(PAGE_SIZE-1)),PAGE_SIZE);
	}
	else
	{
		memset(ptbl,0,PAGE_SIZE);
		ptbl[PAGE_SIZE/sizeof(uint)-1]=(uint)user_stack|PAGE_PRESEN|PAGE_RW|PAGE_USER;
	}
	pdir[USER_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW|PAGE_USER;

	return (void*)mmstruct;

ERR2:
	unlinkPhysTable((uint)ptbl);
ERR:
	unlinkPhysTable((uint)pdir);
	kfree(mmstruct);

	return NULL;
}


/*
 * GLOBAL
 * Хʥե꡼˥ɤ롣
 * OPEN_Fݥ󥿤NULLʤ꡼0ꥢ롣
 * ɲͽ굡ǽ
 *  Ǥ˥ɺѤƱ¹ԥեɤ߼ꥻơߥ򥳥ԡ饤Ȥˤ롣
 *  ꡼ɤ߹ॻ¤ĤϥХååץǥХ˽񤭹ࡣ
 * parametersOPEN_Fݥ󥿡ɥХȿɳϥ˥ɥ쥹ڡ°ɹߤΤ=LB_R,ɤ߽=LB_WR
 * return : 0 or error=-1
 */
int loadBinary(OPEN_F *open_f,size_t size,uint address,int attribute)
{
	void *page;
	uint *pdir;
	uint *ptbl;
	uint addr,last;
	MM_STRUCT *mm_struct=(MM_STRUCT*)get_current_task()->mm_struct;


	pdir=mm_struct->pageDir;
	last=address+size;

	/* ɥʬ꡼Ƥ롣 */
	for(addr=address;addr<last;addr+=PAGE_SIZE)
	{
		if((ptbl=(uint*)(*getPageDirEntryAddr(addr,pdir)&~(PAGE_SIZE-1)))==NULL)
		{
			/* ڡơ֥γơ */
			if((ptbl=(uint*)allocKernelPage())==NULL)return -1;
			memset(ptbl,0,PAGE_SIZE);
			*getPageDirEntryAddr(addr,pdir)=(uint)ptbl|PAGE_PRESEN|PAGE_USER|PAGE_RW;
		}

		/* ꡼°ꤹ롣 */
		if((page=allocUserPage())==NULL)return -1;
		*getPageEntryAddr(addr,ptbl)=(uint)page|PAGE_PRESEN|PAGE_USER|PAGE_RW;
	}

	/* ڡǥ쥯ȥ򹹿롣 */
	flashPageDir(pdir);

	/*
	 * ե뤫꡼ɤ߹ࡣ
	 * OPEN_Fݥ󥿤NULLʤ꡼0ꥢ롣
	 */
	if(open_f!=NULL)
	{
		if(exec_read(open_f,(void*)address,size)!=size)return -1;
	}
	else memset((void*)address,0,size);

	/* ڡ°ɹߤʤꤷľ */
	if(attribute==LB_R)
	{
		for(addr=address;addr<last;addr+=PAGE_SIZE)
		{
			ptbl=(uint*)(*getPageDirEntryAddr(addr,pdir)&~(PAGE_SIZE-1));
			*getPageEntryAddr(addr,ptbl)&=~PAGE_RW;
		}

		/* ڡǥ쥯ȥ򹹿롣 */
		flashPageDir(pdir);
	}

	/* 饹ȥڡɥ쥹򹹿롣 */
	if(mm_struct->lastPageAddr<last)mm_struct->lastPageAddr=ROUNDUP(last,PAGE_SIZE);

	return 0;
}


/*
 * GLOBAL
 * 桼ƥȥڡȥǡڡ롣
 * parameters : ꡼¤
 */
void releaseUserTextDataPage(void *mm_struct)
{
	releasePage(((MM_STRUCT*)mm_struct)->pageDir,USER_BEG,USER_STACK_BEG);
}


/*
 * GLOBAL
 * ͥڡȥڡǥ쥯ȥ롣
 * parameters : ꡼¤
 */
void releasePageDir(void *mm_struct)
{
	uint *pdir=((MM_STRUCT*)mm_struct)->pageDir;


	kfree(mm_struct);

	/* 桼ڡ롣 */
	releasePage(pdir,USER_BEG,USER_END);

	/* ͥ륹åڡ롣 */
	releasePage(pdir,KERNEL_STACK_BEG,KERNEL_END);

	/* ڡǥ쥯ȥ롣 */
	unlinkPhysTable((uint)pdir);
}


/*
 * GLOBAL
 * ڡե㳰
 * parameters : page fault address,Exception frame
 */
void pageFault(uint fault_addr,EXCEPT_FRAME frame)
{
	/* 顼ɥӥåȥޥ */
	enum{
		PRESEN=1,
		RW_MODE=2,
		USER_MODE=4,
		RSVBIT=8,
	};

	void *alloc_page;
	uint *pdir;
	uint *ptbl;
	uint *current_page;
	int array;
	MM_STRUCT *mm_struct;


	mm_struct=(MM_STRUCT*)get_current_task()->mm_struct;
	pdir=mm_struct->pageDir;
	ptbl=(uint*)(*getPageDirEntryAddr(fault_addr,pdir)&~(PAGE_SIZE-1));
	current_page=getPageEntryAddr(fault_addr,ptbl);

	if((frame.error&PRESEN)==0)	/* ڡԺߡ */
	{
		/* øڡȿ */
		if((fault_addr<USER_BEG)||(fault_addr>=IOMAP_BEG)||
			((fault_addr>mm_struct->lastPageAddr)&&(fault_addr<USER_STACK_BEG)))
		{
			printk("Page privilege violation!\n");
			goto ERR;
		}

		/* ʪڡγơ */
		if((alloc_page=allocUserPage())==NULL)
		{
			printk("Fail alloc physical page!\n ");
			goto ERR;
		}

		/* Хååפꡣ */
		if(*current_page!=0)
			if(restorePage(alloc_page,*current_page)==-1)
			{
				printk("Fail restore page!\n ");
				goto ERR;
			}

		*current_page|=(uint)alloc_page|PAGE_PRESEN|PAGE_RW|PAGE_USER;
	}
	else	/* ڡȿ */
	{
		if(*current_page&PT_COPY_ON_WRITE)	/* ԡ饤Ƚ */
		{
			/* ꡼Ȳξϥԡ饤ȥե饰ᤷused link롣 */

			/*
			 * ڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤵƤϡ
			 * ڡơ֥Ƥ롣
			 */
			if(pdir[fault_addr/PAGE_DIR_SIZE]&PT_COPY_ON_WRITE)
			{
				array=fault_addr/PAGE_DIR_SIZE;

				if((alloc_page=allocKernelPage())==NULL)
				{
					printk("Fail alloc physical page!\n ");
					goto ERR;
				}
				memcpy(alloc_page,(void*)(pdir[array]&~(PAGE_SIZE-1)),PAGE_SIZE);
				pdir[array]=((pdir[array]&(PAGE_SIZE-1))|(uint)alloc_page)&~PT_COPY_ON_WRITE;
			}

			/* ʪڡγơ */
			if((alloc_page=allocUserPage())==NULL)
			{
				printk("Fail alloc physical page!\n ");
				goto ERR;
			}

			/* ڡƤƤڡ˥ԡ롣 */
			memcpy(alloc_page,(void*)(*current_page&~(PAGE_SIZE-1)),PAGE_SIZE);

			*current_page=(uint)alloc_page|PAGE_PRESEN|PAGE_RW|PAGE_USER;
		}
		else	/* ȿ */
		{
			printk("Page privilege violation!\n");
			goto ERR;
		}
	}

	return;
ERR:

	sys_exit(1);
}


/*
 * GLOBAL
 * get physical address from linear address
 * parameters : linear address,state queue
 * return : physical address or srror=NULL state bit:1=ڡԺ,2=ڡ߶ػ,4=ڡ¸ߤʤ
 */
void *getPhysAddrFromLinearAddr(void *liner_addr,int *state)
{
	*state=0;
	return (void*)(*getPageEntryAddr((uint)liner_addr,((MM_STRUCT*)get_current_task()->mm_struct)->pageDir)&~(PAGE_SIZE-1));
}


/*
 * GLOBAL
 * get page directory address
 * parameters : memory manage structure
 * return : page directory address
 */
uint *getPageDir(void *mmstruct)
{
	return ((MM_STRUCT*)mmstruct)->pageDir;
}


/*
 * GLOBAL
 * update virtual memory system
 * parameters : memory manage structure
 */
void updateVm(void *mm_struct)
{
	flashPageDir(((MM_STRUCT*)mm_struct)->pageDir);
}


/*
 * GLOBAL
 * ͥڡơ֥ꤹ
 * return : MM_STRUCTɥ쥹 or error=NULL
 */
void *initPaging()
{
	void *stack;
	uint *pdir,*ptbl;
	MM_STRUCT *mstruct;
	int i;


	/* ͥڡǥ쥯ȥ */
	if((pdir=(uint*)allocKernelPage())==NULL)return NULL;
	memset(pdir,0,PAGE_SIZE);
	for(i=0;i<KERNEL_STACK_BEG/PAGE_DIR_SIZE;++i)
		pdir[i]=i*PAGE_DIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M;

	/* ͥ륹åڡƤ */
	if((ptbl=(uint*)allocKernelPage())==NULL)return NULL;
	memset(ptbl,0,PAGE_SIZE);
	pdir[KERNEL_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW;
	if((stack=allocKernelPage())==NULL)return NULL;
	ptbl[1023]=(uint)stack|PAGE_PRESEN|PAGE_RW;

	/* ꡼ޥåץIOڡѥǥ쥯ȥ */
	for(i=IOMAP_BEG/PAGE_DIR_SIZE;i<1024;++i)
	   	pdir[i]=i*PAGE_DIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M|PAGE_CASH_DISABLE;

	/* ڡ󥰳 */
	asm volatile(
			"movl	%%eax,%%cr3\n"			/* Set page directory address */
			"movl	$0x10,%%eax\n"
			"movl	%%eax,%%cr4\n"			/* 4Mڡĥ */
			"movl	%%cr0,%%eax\n"
			"orl	$0x80010000,%%eax\n"	/* Enable paging,Enable wp(ѡХν񤭹ݸ) */
			"movl	%%eax,%%cr0\n"
			"jmp	1f\n"
		"1:"
		::"a"(pdir)
	);

	/* ꡼¤Τν */
	if((mstruct=(MM_STRUCT*)kmalloc(sizeof(MM_STRUCT)))==NULL)return NULL;
	mstruct->pageDir=pdir;
	mstruct->pageDirGate=0;

	return (void*)mstruct;
}


/***********************************************************************************
 *
 * ƥॳ
 *
 ***********************************************************************************/

/*
 * 桼ڡΥɥ쥹ޤǳƤ롣
 */
int sys_brk(void *end_addr)
{
	MM_STRUCT *mm_struct;


	mm_struct=(MM_STRUCT*)get_current_task()->mm_struct;
	if(mm_struct->lastPageAddr>=(uint)end_addr)return 0;
	if((uint)end_addr>USER_STACK_BEG)return -ENOMEM;
	mm_struct->lastPageAddr=ROUNDUP((uint)end_addr,PAGE_SIZE);

	return 0;
}


/***********************************************************************************
 *
 * ؿ
 *
 ***********************************************************************************/

/*
 * GLOBAL
 * ꡼ƥν
 */
void initMm()
{
	/* Find size of physical memory  */
	printk("Memory size = %d MB\n",findAllMemsize()/0x100000);

	/* ʪ꡼ơ֥ */
	initPhysMemTable();

	/* ڡѵΰν */
/*	int mountBackupDev();*/
}
/************************************************************************/
void test_mm()
{
	MM_STRUCT *mst=(MM_STRUCT*)get_current_task()->mm_struct;
	printk("mm_struct=%x\n",mst);
}
/*************************************************************************/
