/*
 * fs.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ۥե륷ƥࡣ
 * ե륷ƥඦ̽
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"mm.h"
#include"proc.h"
#include"lock.h"
#include"fs.h"
#include"test.h"


enum{
	MOUNT_DEV=0,		/* ǥХե륷ƥdevice inodeɬ0 */
};


/* ޥȥե륷ƥ।ǥå */
typedef struct{
	ushort fs_num;			/* ե륷ƥʥС */
	ushort ref_count;		/* ȥ */
}MOUNT_FS;


static FS *fs_info[MAX_REGIST_FS];
static MOUNT_FS mount_fs[MAX_DEVICE_OPEN];


/************************************************************************************
 *
 * < ե륷ƥඦ̥饹 >
 *
 ************************************************************************************/

/*
 * cmpare path strings
 * parameters : Destination string(end='\0'),Sorce string(end='/' or '\0')
 * return : =Υѥݥ or ԰=NULL;
 */
extern inline const char *cmpPathNull(const char *path1,const char *path2)
{
	while(*path1==*path2++)
		if(*path1++=='\0')return path2-1;

	if((*(path2-1)=='/')&&(*path1=='\0'))return path2;
	else return NULL;
}


/************************************************************************************
 *
 * < ۥե륷ƥ९饹 >
 *
 * ޥȻȥȥǥ쥯ȥѹȥե¹Իɲä롣
 * ȥ꡼ϡ"."+".."+̾ͽ¤٤롣
 * ȥ꡼󥯤κǸϺǽΥȥ꡼Ϣ뤹롣
 *
 ************************************************************************************/

enum{
	VFS_MAX_NAME_SIZE=255,	/* ۥե륷ƥκ̾ */
};


/* ۥȥ꡼ */
typedef struct VENTRY{
	struct VENTRY *next;		/* ȥ꡼󥯥ͥ */
	struct VENTRY *prev;		/* ȥ꡼󥯥ץӥ塼 */
	uint block;					/* ǥХ֥å */
	struct VENTRY *parent;		/* ƥȥ꡼ */
	struct VENTRY *entry;		/* ΥΡɤΥȥåץȥ꡼ */
	union{
		struct VENTRY *mount;	/* ޥȥȥ꡼ */
		void *exe_page;			/* ¹ԥե륤᡼ɤ߼ڡ */
	}opt;
	uchar refCount;				/* ȥ󥿡ޥȤ䥫ȥǥ쥯ȥ¹ԥե¹ԥ */
	uchar din;					/* ǥХinode */
	uchar type;					/* ե륿 */
	char name[1];				/* ѥ͡ */
}VENTRY;


/*
 * PUBLIC
 * 롼ȥȥ꡼
 */
static VENTRY rootEnt;

/*
 * PUBLIC
 * devǥ쥯ȥꥨȥ꡼
 */
static char dev[sizeof(VENTRY)+3];
static VENTRY *devEnt=(VENTRY*)dev;

/*
 * PUBLIC
 * ͭåȡ
 */
static SHARE_LOCK shareLock={0,0};


/*
 * ̾ʸȥѥʸӤ롣
 * פ˼Υѥɥ쥹롣
 * parameters : destination name string,sorce path string pointer
 * return : =0 or 礭=1 or =-1
 */
extern inline int cmpPath(const char *name,const char **path)
{
	const char *p=*path;


	while(*name==*p++)
		if(*name++=='\0')
		{
			*path=p-1;
			return 0;
		}

	if((*--p=='/')&&(*name=='\0'))
	{
		*path=p+1;
		return 0;
	}
	if(*name>*p)return 1;
	return -1;
}


/*
 * PRIVATE
 * ѥʸ󥵥Ϥ롣
 * parmeters :
 */
extern inline size_t pathLen(const char *path)
{
	const char *p=path;


	while(*p++!='/')
		if(*p=='\0')break;

	return (size_t)(p-path-1);
}


/*
 * PRIVATE
 * ȥ꡼󥯤饨ȥ꡼򸡺롣
 * Υȥ꡼ɥ쥹ݥ󥿡ˤϸĤäȥ꡼ޤϡ
 * ǸΥȥ꡼ɥ쥹롣
 * parameters : ѥɥ쥹,ǥ쥯ȥꥨȥ꡼ɥ쥹ݥ󥿡
 * return : next path or failed=NULL
 */
static const char *searchEntry(const char *path,VENTRY **entry)
{
	int rest;
	VENTRY *ent;


	if(cmpPath(".",&path)==0)return path;
	if(cmpPath("..",&path)==0)
	{
		*entry=(*entry)->parent;
		return path;
	}
	if((ent=(*entry)->entry)==NULL)
	{
		*entry=NULL;
		return NULL;
	}
	do
	{
		rest=cmpPath(ent->name,&path);
		if(rest!=-1)break;
	}while((ent=ent->next)!=(*entry)->entry);

	*entry=ent;

	if(rest==0)return path;
	return NULL;
}


/*
 * PUBLIC
 * ѥ'/'ޤ'\0'ޤǥԡơ'\0'ղä롣
 * parameters : Destination string,Sorce string
 * return : next path
 */
extern inline const char *cpyPath(char *str,const char *path)
{
	while((*str=*path++)!='\0')
		if(*str++=='/')
		{
			*(str-1)='\0';
			return path;
		}

	return path-1;
}


/*
 * PUBLIC
 * ѥ̾Υȥ꡼򸡺롣
 * Υѥݥ󥿡ˤϼΥѥƬɥ쥹롣
 * parameters : path address pointer,parent entry address
 * return : ȥ꡼ɥ쥹
 */
static VENTRY *searchPath(const char **path,VENTRY *entry)
{
	const char *pt=*path;
	VENTRY *ent=entry;


	while(*pt!='\0')
	{
		if(entry->type!=DIRECTORY)break;
		if(entry->opt.mount!=NULL)entry=entry->opt.mount;
		if((pt=searchEntry(pt,&ent))==NULL)break;
		*path=pt;
		entry=ent;
	}

	return entry;
}


/*
 * PUBLIC
 * ѥƬΡ̾Υȥ꡼󥯤ɲä롣
 * parameters : path pointer,directory entry,file type
 * return : new entry address
 */
static VENTRY *addEntry(const char **path,VENTRY *entry,int type)
{
	VENTRY *next_ent,*new_ent;


	/* ȥ꡼򸡺 */
	next_ent=entry;
	if(searchEntry(*path,&next_ent)!=NULL)return NULL;

	/* ȥ꡼κ */
	if((new_ent=(VENTRY*)kmalloc(sizeof(VENTRY)+pathLen(*path)))==NULL)return NULL;
	memset(new_ent,0,sizeof(VENTRY));
	new_ent->din=entry->din;
	new_ent->type=type;
	new_ent->parent=entry;
	*path=cpyPath(new_ent->name,*path);

	/* 󥯤ɲä롣 */
	enterWriteLock(&shareLock,1);
	{
		if(next_ent!=NULL)
		{
			new_ent->prev=next_ent->prev;
			new_ent->next=next_ent;
			next_ent->prev->next=new_ent;
			next_ent->prev=new_ent;
			if((next_ent==entry->entry)&&(strcmp(next_ent->name,new_ent->name)==1))
				entry->entry=new_ent;
		}
		else
		{
			entry->entry=new_ent;
			new_ent->prev=new_ent;
			new_ent->next=new_ent;
		}
	}
	exitWriteLock(&shareLock);

	return new_ent;
}


/*
 * PUBLIC
 * ȥ꡼롣
 * parameters : entry addres
 * return : 0 or failed=-1
 */
static int delEntry(VENTRY *entry)
{
	VENTRY *parent;


	if(entry->refCount>0)return -1;
	if(entry->entry!=NULL)return -1;

	parent=entry->parent;

	enterWriteLock(&shareLock,1);
	{
		if(entry->next==entry)parent->entry=NULL;
		else
		{
			if(parent->entry==entry)parent->entry=entry->next;
			entry->prev->next=entry->next;
			entry->next->prev=entry->prev;
		}
	}
	exitWriteLock(&shareLock);

	kfree(entry);

	return 0;
}


/*
 * PUBLIC
 * ȥ꡼˿ȥ꡼ޥȤ롣
 * parameters : ޥȥȥ꡼,ǥХinode,롼ȥǥ쥯ȥ֥å
 * return : 0 or error=-1
 */
static int mountEntry(VENTRY *entry,int din,uint block)
{
	VENTRY *mount_ent;


	/* Ǥ˥ޥȤƤ뤫 */
	if(entry->opt.mount!=NULL)return -1;

	/* ޥȥȥ꡼κ */
	if((mount_ent=(VENTRY*)kmalloc(sizeof(VENTRY)))==NULL)return -1;
	memset(mount_ent,0,sizeof(VENTRY)+1);
	mount_ent->din=din;
	mount_ent->block=block;
	mount_ent->refCount=1;
	mount_ent->parent=entry->parent;

	/* ޥȥȥ꡼˥ޥȤ롣 */
	++entry->refCount;
	entry->opt.mount=mount_ent;

	return 0;
}


/*
 * PUBLIC
 * ޥȡ
 * parameters : ޥȥȥ꡼
 * return : 0 or error=-1
 */
static int umountEntry(VENTRY *entry)
{
	VENTRY *mount_ent,*parent;


	if((mount_ent=entry->opt.mount)==NULL)return -1;
	if(mount_ent->refCount>1)return -1;
	if(mount_ent->entry!=mount_ent->entry->next->next)return -1;

	/* ޥȥȥ꡼κ */
	mount_ent->refCount=0;
	if(delEntry(mount_ent)==-1)return -1;
	--entry->refCount;

	/* ޥȥȥ꡼ʤ */
	for(;;)
	{
		parent=entry->parent;
		if(delEntry(entry)!=0)break;
		entry=parent;
	}

	return 0;
}


/************************************************************************************
 *
 * < ե륷ƥ饹 >
 *
 ************************************************************************************/

/* եǥץ */
typedef struct{
	ushort ref_count;	/* ȥ */
	ushort din;			/* device inode number */
	uint inode;			/* inode֥å */
	size_t offset;		/* ɤ߽񤭳ϥեå */
}F_DSC;

/* ץѥե빽¤ */
typedef struct{
	VENTRY *current_dir;		/* ȥǥ쥯ȥ */
	F_DSC *fd[MAX_FILE_OPEN];
	uchar num[MAX_FILE_OPEN];
	uchar fd_count;				/* եǥץץ */
	uchar next_fd;				/* ζեǥץ */
}FILE_STRUCT;


/*
 * PUBLIC
 * ȥǥ쥯ȥ롣
 * parameters : ѥɥ쥹ݥ
 * return : Ȳۥǥ쥯ȥꥨȥ꡼
 */
extern inline VENTRY *getCurrentDir(const char **path)
{
	if(**path=='/')
	{
		*path+=1;
		return &rootEnt;
	}
	else
		return ((FILE_STRUCT*)get_current_task()->file_struct)->current_dir;
}


/*
 * GLOBAL
 * Register filesystem
 * parameters : Filesystem struct pinter
 * return : 0 or Error=-1
 */
int regist_fs(FS *fs)
{
	int i;


	for(i=0;i<MAX_REGIST_FS;++i)
		if(fs_info[i]==NULL)
		{
			fs_info[i]=fs;
			return 0;
		}

	return -1;
}


/*
 * GLOBAL
 * Search file system
 * parameters : file system name
 * return : file system number or noshing=-1
 */
int search_fs(const char *name)
{
	int i;


	for(i=0;fs_info[i]!=NULL;++i)
		if(strcmp(fs_info[i]->name,name)==0)return i;

	return -1;
}


/*
 * GLOBAL
 * ץѥե빽¤Τν
 * parameters : process
 * return : 0 or error=-1
 */
int init_file_struct(PROC *proc)
{
	int i;
	FILE_STRUCT *p;


	if((p=(FILE_STRUCT*)kmalloc(sizeof(FILE_STRUCT)))==NULL)return -1;
	p->fd_count=0;
	p->next_fd=0;
	memset(p->fd,0,sizeof(F_DSC*)*MAX_FILE_OPEN);
	for(i=0;i<MAX_FILE_OPEN;++i)p->num[i]=i+1;
	p->current_dir=NULL;
	proc->file_struct=(void*)p;

	return 0;
}


/*
 * GLOBAL
 * fork˥եطι¤Τƥץ饳ԡ롣
 * parameters : parent process,chils process
 * return : 0 or error=-1
 */
int cpy_file_struct(PROC *parent,PROC *child)
{
	int i,j,fd_count;
	F_DSC **fd;


	if((child->file_struct=kmalloc(sizeof(FILE_STRUCT)))==NULL)return -1;
	memcpy(child->file_struct,parent->file_struct,sizeof(FILE_STRUCT));

	/* եǥץλȥ󥿤1䤹 */
	fd=((FILE_STRUCT*)child->file_struct)->fd;
	fd_count=((FILE_STRUCT*)child->file_struct)->fd_count;
	for(i=0,j=0;;++i)
		if(fd[i]!=NULL)
		{
			++fd[i]->ref_count;
			if(++j>=fd_count)break;
		}

	return 0;
}


/*
 * GLOBAL
 * եطι¤Τ롣
 * parameters : FILE_STRUCT address
 * return : 0 or error=-1
 */
int releaseFileStruct(void *fstruct)
{
	int i;


	for(i=0;i<MAX_FILE_OPEN;++i)
	{
		if(((FILE_STRUCT*)fstruct)->fd[i]!=NULL)
		{
			if(sys_close(i)==-1)return -1;
			if(((FILE_STRUCT*)fstruct)->fd_count<=0)return 0;
		}
	}

	return -1;
}


/*
 * GLOBAL
 * inode֤
 * parameters : file descriptor
 * return : inode block or error=-1
 */
int get_inode(int fd)
{
	F_DSC *fdsc;


	if(fd>MAX_FILE_OPEN)return -1;

	if((fdsc=((FILE_STRUCT*)(get_current_task()->file_struct))->fd[fd])==NULL)return -1;

	return fdsc->inode;
}


/************************************************************************************
 *
 * ե¹
 *
 ************************************************************************************/

/*
 * PUBLIC
 * ե륪ץ
 * parameters : path,open struct
 */
extern inline int open(const char *path,OPEN_F *open_f)
{
	VENTRY *vent;


	/* ǥ쥯ȥꥨȥ꡼ */
	vent=getCurrentDir(&path);

	enterReadLock(&shareLock);
	{
		vent=searchPath(&path,vent);

		if((*path=='\0')&&(vent->type==NORMAL_FILE))
		{
			open_f->inode=vent->block;
			++vent->refCount;
		}
		else if((*path!='\0')&&(vent->type==DIRECTORY))
		{
			if((open_f->inode=fs_info[mount_fs[vent->din].fs_num]->open(path,vent->din,vent->block))==-1)
					goto ERR;
		}
		else goto ERR;
	}
	exitReadLock(&shareLock);

	open_f->din=vent->din;

	return 0;

ERR:
	exitReadLock(&shareLock);

	return -1;
}


/*
 * GLOBAL
 * ¹ԥե륪ץ̾Υץδάؿ
 * parameters : path,open file struct
 * return : 0 or error=-1
 */
int exec_open(const char *path,OPEN_F *open_f)
{
	return open(path,open_f);
}


/*
 * GLOBAL
 * ¹ԥեɤ߹ߡ̾Υ꡼ɤδάؿ
 * parameters : open file struct,buffer,read size
 * return : read byte or error=-1
 */
int exec_read(OPEN_F *open_f,void *buf,size_t size)
{
	return fs_info[mount_fs[open_f->din].fs_num]->read(open_f->din,open_f->inode,buf,size,open_f->offset);
}


/************************************************************************************
 *
 * System call interface
 *
 ************************************************************************************/

int sys_mount(const char *dev_path,const char *fs_name,const char *path)
{
	enum{DEV_NAME_SIZE=5};		/* "/dev/"Υ */

	int fs;
	int mount_din;
	int block;
	uint root_blk;
	VENTRY *vent;
	int (*opendir)(const char*,int,uint);
	const char *pt;



	/* Search file system number */
	if((fs=search_fs(fs_name))==-1)return -1;

	/* ǥХץ */
	if(cmpPathNull("/dev",dev_path)==NULL)return -1;
	if((mount_din=fs_info[mount_fs[MOUNT_DEV].fs_num]->open(dev_path+DEV_NAME_SIZE,0,0))==-1)return -1;

	/* ǥХ˥ޥȤƤ뤫 */
	if((++mount_fs[mount_din].ref_count>1)&&(mount_fs[mount_din].fs_num!=fs))goto ERR;
	else mount_fs[mount_din].fs_num=fs;

	/* ޥȴؿƤӽФ */
	if((root_blk=fs_info[fs]->mount(mount_din))==-1)goto ERR;

	/* ۥե륷ƥΥǥ쥯ȥ򸡺롣 */
	vent=getCurrentDir(&path);

	enterReadLock(&shareLock);
	{
		vent=searchPath(&path,vent);
		if(vent->type!=DIRECTORY)goto ERR;

		if(*path!='\0')
		{
			opendir=fs_info[mount_fs[vent->din].fs_num]->opendir;
			pt=path;

			do
			{
				block=vent->block;
				if((vent=addEntry(&pt,vent,DIRECTORY))==NULL)goto ERR2;
				if((vent->block=opendir(vent->name,vent->din,block))==-1)goto ERR2;
			}while(*pt!='\0');
		}

		/* ޥȤ벾ۥǥ쥯ȥ롣 */
		if(mountEntry(vent,mount_din,root_blk)==-1)goto ERR2;
	}
	exitReadLock(&shareLock);

	return 0;

ERR2:
	for(;;)
	{
		VENTRY *parent;

		parent=vent->parent;
		if(delEntry(vent)!=0)break;
		vent=parent;
	}
ERR:
	exitReadLock(&shareLock);
	--mount_fs[mount_din].ref_count;
	fs_info[mount_fs[MOUNT_DEV].fs_num]->close(MOUNT_DEV,mount_din);

	return -1;
}


int sys_umount(const char *path)
{
	int fs;
	VENTRY *vent,*mount_ent;


	/* ǥ쥯ȥõ */
	vent=getCurrentDir(&path);

	enterReadLock(&shareLock);
	{
		vent=searchPath(&path,vent);
		if(vent->type!=DIRECTORY)goto ERR;
		if(*path!='\0')goto ERR;

		/* ޥȡ */
		mount_ent=vent->opt.mount;
		if(umountEntry(vent)==-1)goto ERR;
	}
	exitReadLock(&shareLock);

	fs=mount_fs[mount_ent->din].fs_num;
	if(fs_info[fs]->umount(mount_ent->din)==-1)return -1;
	--mount_fs[mount_ent->din].ref_count;

	return 0;

ERR:
	exitReadLock(&shareLock);

	return -1;
}

/*
 * parameters : path,flag
 * return : file descriptor number or error=-1
 */
int sys_open(const char *path,int flag)
{
	int fd_num;
	FILE_STRUCT *fstruct;
	F_DSC *fd;
	OPEN_F open_f;


	/* ץΥå */
	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if(fstruct->fd_count>=MAX_FILE_OPEN)return -1;

	/* եõ */
	if(open(path,&open_f)==-1)return -1;

	/* եǥץϿ롣 */
	if((fd=(F_DSC*)kmalloc(sizeof(F_DSC)))==NULL)
	{
		fs_info[mount_fs[open_f.din].fs_num]->close(open_f.din,open_f.inode);
		return -1;
	}
	fd->din=open_f.din;
	fd->inode=open_f.inode;
	fd->offset=0;
	fd->ref_count=1;
	fstruct->fd[fstruct->next_fd]=fd;
	fd_num=fstruct->next_fd;
	fstruct->next_fd=fstruct->num[fstruct->next_fd];
	++fstruct->fd_count;

	return fd_num;
}

/*
 * parameters : file descriptor number
 * return : 0 or error=-1
 */
int sys_close(int fd_num)
{
	FILE_STRUCT *fstruct;
	F_DSC *fd;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if((fd=fstruct->fd[fd_num])==NULL)return -1;

	if(--fd->ref_count>0)return 0;										/* ȥ󥿤1餹 */
	if(fs_info[mount_fs[fd->din].fs_num]->close(fd->din,fd->inode)==-1)	/* ե򥯥롣 */
		return -1;

	kfree(fd);

	fstruct->fd[fd_num]=NULL;
	fstruct->num[fd_num]=fstruct->next_fd;
	fstruct->next_fd=fd_num;
	--fstruct->fd_count;

	return 0;
}

/*
 * parameters : file descriptor number,baffer,read bytes
 * return : read bytes or error=-1
 */
int sys_read(int fd_num,void *buf,size_t size)
{
	FILE_STRUCT *fstruct;
	F_DSC *fd;
	int rest;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;
	if((fd=fstruct->fd[fd_num])==NULL)return -1;

	/* readؿƤӽФ */
	rest=fs_info[mount_fs[fd->din].fs_num]->read(fd->din,fd->inode,buf,size,fd->offset);
	if(rest==-1)return -1;
	fd->offset+=rest;

	return rest;
}

int sys_write(int fd_num,void *buf,size_t size)
{
	FILE_STRUCT *fstruct;
	F_DSC *fd;
	int rest;


	fstruct=(FILE_STRUCT*)get_current_task()->file_struct;

	if((fd=fstruct->fd[fd_num])==NULL)return -1;

	/* writeؿƤӽФ */
	rest=fs_info[mount_fs[fd->din].fs_num]->write(fd->din,fd->inode,buf,size,fd->offset);
	if(rest==-1)return -1;
	fd->offset+=rest;

	return rest;
}

int sys_mkdir(const char *path)
{
	VENTRY *vent;


	vent=getCurrentDir(&path);

	vent=searchPath(&path,vent);
	if(*path=='\0')return -1;
	if(vent->type!=DIRECTORY)return -1;

	return fs_info[mount_fs[vent->din].fs_num]->mkdir(path,vent->din,vent->block);
}

/************************************* ̤ ******************************************/
int sys_lseek(int fd_num,int offset,int flag)
{
	enum{
		SEEK_SET=0,
		SEEK_CUR,
		SEEK_END
	};

	return 0;
}

int sys_creat()
{
	return 0;
}

int sys_rename()
{
	return 0;
}

int sys_unlink()
{
	return 0;
}

int sys_lock()
{
	return 0;
}

int chdir()
{
	return 0;
}


/************************************************************************************
 *
 * 
 *
 ************************************************************************************/

/*
 * GLOBAL
 * Init filesystem
 */
void init_fs()
{
	/* ե륷ƥν */
	memset(fs_info,0,sizeof(FS*)*MAX_REGIST_FS);
	memset(mount_fs,0,sizeof(MOUNT_FS)*MAX_DEVICE_OPEN);

	/* ۥե륷ƥν */
	memset(&rootEnt,0,sizeof(rootEnt));
	rootEnt.parent=&rootEnt;
	rootEnt.refCount=1;
	rootEnt.type=DIRECTORY;

	memset(devEnt,0,sizeof(*devEnt));
	devEnt->prev=devEnt;
	devEnt->next=devEnt;
	devEnt->parent=&rootEnt;
	devEnt->refCount=1;
	devEnt->type=DIRECTORY;
	cpyPath(devEnt->name,"dev");

	rootEnt.entry=devEnt;
}


/*
 * GLOBAL
 * mount filesystem
 * parameters : 벾ۥǥ쥯ȥ
 * return : 0 or error=-1
 */
int mountRoot(const char *dev_path,const char *fs_name)
{
	enum{DEV_NAME_SIZE=5};		/* "/dev/"Υ */

	int fs,mount_din;
	uint root_blk;

	/* Search file system number */
	if((fs=search_fs(fs_name))==-1)return -1;

	/* ǥХץ */
	if(cmpPathNull("/dev",dev_path)==NULL)return -1;
	if((mount_din=fs_info[mount_fs[MOUNT_DEV].fs_num]->open(dev_path+DEV_NAME_SIZE,0,0))==-1)return -1;
	else mount_fs[mount_din].fs_num=fs;

	/* ǥХ˥ޥȤƤ뤫 */
	if((++mount_fs[mount_din].ref_count>1)&&(mount_fs[mount_din].fs_num!=fs))goto ERR;

	/* ޥȴؿƤӽФ */
	if((root_blk=fs_info[fs]->mount(mount_din))==-1)goto ERR;

	/* 롼Ȳۥǥ쥯ȥꡣ */
	rootEnt.din=mount_din;
	rootEnt.block=root_blk;

	return 0;

ERR:
	fs_info[mount_fs[MOUNT_DEV].fs_num]->close(MOUNT_DEV,mount_din);

	return -1;
}


/*
 * GLOBAL
 * Mount device file
 * parameters : file system register number
 * return : 0 or error=-1
 */
int mount_dev_fs(int fs)
{
	if(mount_fs[MOUNT_DEV].ref_count!=0)return -1;
	mount_fs[MOUNT_DEV].ref_count=1;
	mount_fs[MOUNT_DEV].fs_num=fs;
	devEnt->din=MOUNT_DEV;

	return 0;
}

/*************************************************************************************************/
void test_fs()
{
	FILE_STRUCT *fstruct=(FILE_STRUCT*)get_current_task()->file_struct;;


	printk("fd=%x\n",fstruct->fd[1]);
}
/**************************************************************************************************/

