/*
 * test_cp.c
 *
 * ե륳ԡΥƥ
 */


#include<unistd.h>
#include<sys/stat.h>
#include<stdio.h>
#include<stdlib.h>
#include<fcntl.h>
#include<string.h>
#include<errno.h>


int main(int argc,char *argv[])
{
	char *buf,*bufnew;
	int fd,fdnew;
	int size;
	struct stat st;
	int i;


	/* եɤ߹ */
	fd = open("test_cp",O_RDONLY);
	if (fd == -1)
	{
		printf("Open source file error! %s\n",strerror(errno));
		return 0;
	}
	if(fstat(fd,&st) == -1)
	{
		printf("Stat source file error! %s\n",strerror(errno));
		return 0;
	}
	size = st.st_size;
	buf = malloc(size);
	if (buf == NULL)
	{
		printf("malloc error! %s\n",strerror(errno));
		return 0;
	}
	if(read(fd,buf,size) != size)
	{
		printf("Read source file error! %s\n",strerror(errno));
		return 0;
	}

	/* ԡե˽񤭽Ф */
	fdnew = open("test",O_RDWR | O_CREAT | O_TRUNC,DEFFILEMODE);
	if (fdnew == -1)
	{
		printf("Open copy file error! %s\n",strerror(errno));
		return 0;
	}
	if (write(fdnew,buf,size) != size)
	{
		printf("Write copy file error! %s\n",strerror(errno));
		return 0;
	}

	/* ԡեΥå */
	if(fstat(fdnew,&st) == -1)
	{
		printf("Stat copy file error! %s\n",strerror(errno));
		return 0;
	}
	if (st.st_size != size)
	{
		printf("Size of copy file error! size=%d\n",st.st_size);
		return 0;
	}

	/* ե */
	bufnew = malloc(size);
	if (bufnew == NULL)
	{
		printf("malloc error! %s\n",strerror(errno));
		return 0;
	}
	if (lseek(fdnew,0,SEEK_SET) == -1)
	{
		printf("Seek copy file error! %s\n",strerror(errno));
		return 0;
	}
	if(read(fdnew,bufnew,size) != size)
	{
		printf("Read copy file error! %s\n",strerror(errno));
		return 0;
	}
	for (i = 0; i >= size; ++i)
		if (buf[i] != bufnew[i])
		{
			printf("File compare error!\n");
			return 0;
		}

	if (close(fdnew) == -1)
	{
		printf("Close copy file error! %s\n",strerror(errno));
		return 0;
	}

	printf("OK test_cp\n");

	return 0;
}
