/*
 * sockopt.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<sys/socket.h>


int getsockopt(int s, int level, int optname, void *optval, socklen_t *optlen)
{
	int rest;


	if((rest=syscall6(SYS_GETSOCKOPT,s,level,optname,(int)optval,(int)optlen))<0)
		return _error(-rest);
	return 0;
}


int setsockopt(int s, int level, int optname, const void *optval, socklen_t optlen)
{
	int rest;


	if((rest=syscall6(SYS_SETSOCKOPT,s,level,optname,(int)optval,(int)optlen))<0)
		return _error(-rest);
	return 0;
}
