/*
 * getpeername.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<string.h>
#include<arpa/inet.h>
#include<sys/socket.h>


/* ipv4Τб */
int getpeername(int s, struct sockaddr *name, socklen_t *namelen)
{
	char adname[INET_ADDRSTRLEN];
	int rest;
	in_addr_t addr;


	if((rest=syscall4(SYS_GET_SOCKADDR,s,GET_SOCKADDR_REMOT,(int)&addr))<0)
		return _error(-rest);
	
	addr=htonl(addr);
	if(inet_ntop(AF_INET,&addr,adname,INET_ADDRSTRLEN)==NULL)return -1;

	if(*namelen<INET_ADDRSTRLEN)
		memcpy(name,adname,*namelen);
	else
	{
		memcpy(name,adname,INET_ADDRSTRLEN);
		*namelen=INET_ADDRSTRLEN;
	}

	return 0;
}
