/*
 * stropts.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<callgate.h>

#include<errno.h>
#include<stropts.h>


extern int _ioctl(int,int,int,...);


int ioctl(int fildes,int request,...)
{
	int *arg;


	arg=(int*)&request+1;
	switch(request)
	{
		case IOCTL_COM_TCDRAIN:
		case TIOCSCTTY:
		case TIOGPGRP:
		case I_TRUNC:
			return _ioctl(fildes,0,request);
		case IOCTL_COM_TCGETTCATTR:
		case IOCTL_COM_TCSENDBREAK:
		case IOCTL_COM_TCFLASH:
		case IOCTL_COM_TCFLOW:
		case TIOSPGRP:
		case TIOCGWINSZ:
			return _ioctl(fildes,1,request,*arg);
		case IOCTL_COM_TCSETTCATTR:
			return _ioctl(fildes,2,request,*arg,*(arg+1));
		default:
			errno = EINVAL;
			return -1;
	}
}
