/*
 * select.c
 */


#include<sys/types.h>

#include<callgate.h>
#include<errno.h>
#include<sys/select.h>


extern int _select(int,fd_set*,fd_set*,fd_set*,int);


int select(int nfds,fd_set *readfds,fd_set *writefds,fd_set *errorfds,struct timeval *timeout)
{
	uint seconds;


	if (nfds < 0)
		return _error(EINVAL);
	
	if (timeout == NULL)
		seconds=-1;
	else if ((seconds = timeout->tv_sec) == 0)
	{
		if (timeout->tv_usec > 0)
			seconds = timeout->tv_usec / 1000;
	}

	return _select(nfds,readfds,writefds,errorfds,seconds);
}
