/*
 * realloc.c
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<ctype.h>
#include<limits.h>
#include<stdlib.h>
#include"malloc.h"


void *realloc(void *ptr,size_t size)
{
	void *mem;
	int shift;
	MALLOC_HEAD *head;


	if(ptr==NULL)return malloc(size);
	if(size==0)
	{
		free(ptr);
		return NULL;
	}

	head=(MALLOC_HEAD*)ptr-1;
	if(head->head.magic!=MAGIC_NUMBER)return NULL;	/* ҡפ˲Ƥ롣 */

	shift=head->head.index+FIRST_INDEX;
	if(size>(1<<shift))								/* (1<<shift)=ߤͿ줿 */
	{
		if((mem=malloc(size))==NULL)return NULL;
		memcpy(mem,ptr,1<<shift);
		free(ptr);
		return mem;
	}
	else return ptr;
}
