/*
 * uio.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<unistd.h>
#include<errno.h>
#include<sys/uio.h>


ssize_t readv(int fd, const struct iovec *vector, int count)
{
	ssize_t size=0;
	int i,len=0;
	
	
	if(count<=0)return _error(EINVAL);

	for(i=0;i<count;++i)
	{
		if((len=read(fd,(void*)((uint*)vector->iov_base)[i],vector->iov_len))!=vector->iov_len)
			break;
		size+=len;
	}
	
	if(len==-1)return -1;
	return size+len;
}


ssize_t writev(int fd, const struct iovec *vector, int count)
{
	ssize_t size=0;
	int i,len;
	
	
	if(count<=0)return _error(EINVAL);

	for(i=0;i<count;++i)
	{
		if((len=write(fd,(void*)((uint*)vector->iov_base)[i],vector->iov_len))==-1)return -1;
		size+=len;
	}
	
	return size;
}
