/*
 * malloc.c
 */


#include<sys/types.h>
#include<errno.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<ctype.h>
#include<limits.h>
#include"malloc.h"


MALLOC_HEAD *nextHead[HEADER_NUM];


static const char indexNumber[]={
	0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
};


void *malloc(size_t size)
{
	int index;
	MALLOC_HEAD *head;


	if(size==0)return  NULL;
	if(size<MIN_SIZE)size=MIN_SIZE;

	/* ǥå */
	if(size<0x100)
	{
		index=indexNumber[size];
		if(size&((1<<index)-1))++index;
	}
	else if(size<0x10000)
	{
		index=indexNumber[size>>8]+8;
		if(size&((1<<index)-1))++index;
	}
	else if(size<0x1000000)
	{
		index=indexNumber[size>>16]+16;
		if(size&((1<<index)-1))++index;
	}
	else
	{
		index=indexNumber[size>>24]+24;
		if(size&((1<<index)-1))++index;
		if(index==32)return NULL;
	}

	/* ꡼ */
	if(nextHead[index-FIRST_INDEX]!=NULL)
	{
		head=nextHead[index-FIRST_INDEX];
		nextHead[index-FIRST_INDEX]=head->next;
	}
	else
	{
		if((head=(MALLOC_HEAD*)sbrk((1<<index)+sizeof(MALLOC_HEAD)))==NULL)return NULL;
	}
	head->head.magic=MAGIC_NUMBER;
	head->head.index=index-FIRST_INDEX;

	return (void*)(head+1);
}
