/*
 * time.h
 */


#ifndef time_h
#define time_h


#include<sys/types.h>


enum{
	CLOCKS_PER_SEC=100,		/* The number of clock_t units per second. */
	TM_YEAR_BASE=1900,
};


struct tm{
	int tm_sec;		/* seconds after the minute. */
	int tm_min;		/* minutes after the hour. */
	int tm_hour;	/* hours since midnight. */
	int tm_mday;	/* day of the month. */
	int tm_mon;		/* months since January. */
	int tm_year;	/* years since 1900. */
	int tm_wday;	/* days since Sunday. */
	int tm_yday;	/* days since January 1. */
	int tm_isdst;	/* Daylight Saving Time flag. */
};


extern char *tzname[2];
extern time_t timezone;

extern char*      asctime(const struct tm* tp);
extern clock_t    clock(void);
extern char*      ctime(const time_t* tp);
extern double     difftime(time_t time2, time_t time1);
extern struct tm* gmtime(const time_t* tp);
extern struct tm* localtime(const time_t* tp);
extern time_t     mktime(struct tm* tp);
extern size_t     strftime(char* s, size_t smax, const char* fmt, const struct tm* tp);
extern time_t     time(time_t* tp);
extern void       tzset (void);


#endif
