/*
 * types.h
 *
 * data types.
 */


#ifndef sys_types_h
#define sys_types_h


#include<share/stdint.h>


#ifndef ASM_FILE


typedef int            blkcnt_t;	/* Used for file block counts. */
typedef int            blksize_t;	/* Used	for block sizes.*/
typedef unsigned int   dev_t;		/* Used for device IDs. */
typedef unsigned int   gid_t;		/* Used for group IDs. */
typedef unsigned int   ino_t;		/* Used for file serial numbers. */
typedef unsigned int   mode_t;		/* Used for some file attributes. */
typedef unsigned short nlink_t;		/* Used for link counts. */
typedef int            off_t;		/* Used for file sizes. */
typedef int            pid_t;		/* Used for process IDs and process group IDs. */
typedef unsigned int   size_t;		/* Used for sizes of objects. */
typedef int            ssize_t;		/* Used for a count of bytes or an error indication. */
typedef int            time_t;		/* Used for time in seconds. */
typedef unsigned int   uid_t;		/* Used for user IDs. */
typedef unsigned int   clock_t;		/* Used for system times in clock ticks or CLOCKS_PER_SEC. */
typedef unsigned int   suseconds_t;	/* Used for time in microseconds. */
typedef unsigned int   id_t;
typedef unsigned int   fixpt_t;		/* fixed point number */
typedef char *         caddr_t;		/* core address */
typedef	int32_t		   segsz_t;		/* segment size */
typedef unsigned int   fsblkcnt_t;
typedef unsigned int   fsfilcnt_t;

/* ץ */
typedef unsigned char 		u_char;
typedef unsigned short		u_short;
typedef unsigned int		u_int;
typedef unsigned long		u_long;
typedef unsigned char		uchar;
typedef unsigned short		ushort;
typedef unsigned int		uint;
typedef	long long			quad_t;
typedef	unsigned long long	u_quad_t;


#ifndef KERNEL
#include<stddef.h>
#endif


typedef	long	fd_mask;
#define	NBBY	8							/* number of bits in a byte */
#define	NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */


#endif


#endif
