/*
 * sys/statvfs.h
 */


#ifndef sys_statvfs_h
#define sys_statvfs_h


#include<sys/types.h>


#define statfs statvfs


#ifndef ASM_FILE


enum{
	/* waitfor flags to vfs_sync() and getfsstat() */
	MNT_WAIT=	1,
	MNT_NOWAIT=	2,

	/* file system statistics */
	MFSNAMELEN=	16,	/* length of fs type name, including null */
	MNAMELEN=	90,	/* length of buffer for returned name */

	/* The flags that may be returned include. */
	MNT_RDONLY=1,		/* The filesystem is mounted read-only; Even the super-user may not write on it. */
	MNT_NOEXEC,			/* Files may not be executed from the filesystem. */
	MNT_NOSUID,			/* Setuid and setgid bits on files are not honored when they are executed. */
	MNT_NODEV,			/* Special files in the filesystem may not be opened. */
	MNT_SYNCHRONOUS,	/* All I/O to the filesystem is done synchronously. */
	MNT_ASYNCHRONOUS,	/* No filesystem I/O is done synchronously. */
	MNT_LOCAL,			/* The filesystem resides locally. */
	MNT_QUOTA,			/* The filesystem has quotas enabled on it. */
	MNT_ROOTFS,			/* Identifies the root filesystem. */
	MNT_EXRDONLY,		/* The filesystem is exported read-only. */
	MNT_EXPORTED,		/* The filesystem is exported for both reading and writing. */
	MNT_DEFEXPORTED,	/* The filesystem is exported for both reading and writing to any Internet host. */
	MNT_EXPORTANON,		/* The filesystem maps all remote accesses to the anonymous user. */
	MNT_EXKERB,			/* The filesystem is exported with Kerberos uid mapping. */

	ST_RDONLY=MNT_RDONLY,	/* Read-only file system. */
	ST_NOSUID=MNT_NOSUID,	/* Does not support setuid()/ setgid() semantics. */
};


struct statfs {
	int				f_type;			/* filesystem type number */
	unsigned long	f_bsize;		/*  File system block size. */
	unsigned long	f_frsize;		/* fundamental file system block size */
	fsblkcnt_t		f_iosize;		/* optimal transfer block size */
	fsblkcnt_t		f_blocks;		/* total data blocks in file system */
	fsblkcnt_t		f_bfree;		/* free blocks in fs */
	fsblkcnt_t		f_bavail;		/* free blocks avail to non-superuser */
	fsfilcnt_t		f_files;		/* total file nodes in file system */
	fsfilcnt_t		f_ffree;		/* free file nodes in fs */
	fsfilcnt_t		f_favail;		/* Number of file serial numbers available to non-privileged process. */
	unsigned long 	f_fsid;			/* file system id */
	unsigned long	f_flag;			/* Bit mask of f_flag values */
#define f_flags f_flag
	uid_t			f_owner;		/* user that mounted the filesystem */
	unsigned long	f_namemax; 		/* Maximum filename length. */
	char			f_fstypename[MFSNAMELEN];	/* fs type name */
	char			f_mntonname[MNAMELEN];		/* directory on which mounted */
	char			f_mntfromname[MNAMELEN];	/* mounted filesystem */
};

#ifndef KERNEL
int	getfsstat (struct statfs *, long, int);
int statvfs(const char *, struct statvfs *);
int fstatvfs(int, struct statvfs *);
#endif


#endif


#endif
