/*
 * sys/resource.h
 */


#ifndef sys_resource_h
#define sys_resource_h


#include<sys/types.h>
#include<sys/select.h>


enum{
	PRIO_PROCESS=1,		/* Identifies the who argument as a process ID. */
	PRIO_PGRP,			/* Identifies the who argument as a process group ID. */
	PRIO_USER,			/* Identifies the who argument as a user ID. */

	RLIMIT_CPU=0,		/* cpu time in milliseconds */
	RLIMIT_FSIZE,		/* maximum file size */
	RLIMIT_DATA,		/* data size */
	RLIMIT_STACK,		/* stack size */
	RLIMIT_CORE,		/* core file size */
	RLIMIT_RSS,			/* resident set size */
	RLIMIT_MEMLOCK,		/* locked-in-memory address space */
	RLIMIT_NPROC,		/* number of processes */
	RLIMIT_NOFILE,		/* number of open files */
	RLIM_NLIMITS,		/* number of resource limits */

	RLIM_INFINITY=(((u_int)1 << 31) - 1),	/* A value of rlim_t indicating no limit. */
};


typedef unsigned int rlim_t;

struct  rusage {
    struct timeval ru_utime;    /* user time used */
    struct timeval ru_stime;    /* system time used */
    long    ru_maxrss;          /* max resident set size */
    long    ru_ixrss;           /* integral shared memory size */
    long    ru_idrss;           /* integral unshared data " */
    long    ru_isrss;           /* integral unshared stack " */
    long    ru_minflt;          /* page reclaims */
    long    ru_majflt;          /* page faults */
    long    ru_nswap;           /* swaps */
    long    ru_inblock;         /* block input operations */
    long    ru_oublock;         /* block output operations */
    long    ru_msgsnd;          /* messages sent */
    long    ru_msgrcv;          /* messages received */
    long    ru_nsignals;        /* signals received */
    long    ru_nvcsw;           /* voluntary context switches */
    long    ru_nivcsw;          /* involuntary " */
};
#define ru_first    ru_ixrss
#define ru_last     ru_nivcsw


extern int  setpriority(int, id_t, int);


#endif
