/*
 * sys/poll.h
 */


#ifndef sys_poll_h
#define sys_poll_h


#ifndef ASM_FILE


enum{
	POLLIN=    1<<0,	/* There is data to read. */
	POLLPRI=   1<<0,	/* There is urgent data to read. */
	POLLOUT=   1<<2,	/* Writing now will not block. */
	POLLERR=   1<<3,	/* Error condition. */
	POLLNVAL=  1<<4,	/* Invalid fd member ( revents only). */
	POLLHUP=   1<<5,	/* Device has been disconnected ( revents only). */
	POLLRDNORM=1<<0,	/* Normal data may be read. */
	POLLRDBAND=1<<1,	/* Priority data may be read. */
	POLLWRNORM=1<<2,	/* Writing now will not block. */
	POLLWRBAND=1<<2,	/* Priority data may be written. */
};


struct pollfd{
	int    fd;		/* The following descriptor being polled. */
	short  events;	/* The input event flags. */
	short  revents;	/* The output event flags. */
};


#endif


#endif
