/*
 * socket.c
 *
 * Copyright 2005, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<config.h>
#include<types.h>
#include<errno.h>
#include<mm.h>
#include<lock.h>
#include<net/net.h>


/*
 * GLOBAL
 * IPХåեդ
 * parameters : IPѥå,IPХåեݥ
 * return : 0 ot error number
 */
int allocIpBuf(IP_HEADER *ip,IP_BUFFER **pip_buf)
{
	int ip_size = swapWord(ip->len);
	IP_BUFFER *ip_buf;
	
	
	/* Хåեγդ */
	ip_buf = kmalloc(sizeof(IP_BUFFER) + ip_size - sizeof(IP_HEADER));
	if (ip_buf == NULL)
		return -ENOMEM;
	memcpy(&ip_buf->ip,ip,ip_size);
	ip_buf->next = NULL;
	
	*pip_buf = ip_buf;
	
	return 0;
}


/*
 * GLOBAL
 * ԤХåե³
 * parameters : å,Хåե
 */
void addRecvBuf(SOCKET *sc,IP_BUFFER *ip_buf)
{
	IP_BUFFER **p;
	
	
	enter_spinlock(&sc->lockGate);
	{
		ip_buf->next = NULL;
		for (p = &sc->recvBuf;; p = &(*p)->next)
			if (*p == NULL)
			{
				*p = ip_buf;
				break;
			}
	}
	exit_spinlock(&sc->lockGate);
}


/*
 * GLOBAL
 * ԤХåե
 * parameters : å,Хåե
 * return : ip_buf or NULL
 */
IP_BUFFER *removeRecvBuf(SOCKET *sc)
{
	IP_BUFFER *ip_buf;
	
	
	enter_spinlock(&sc->lockGate);
	{
		ip_buf = sc->recvBuf;
		sc->recvBuf = ip_buf->next;
	}
	exit_spinlock(&sc->lockGate);
	
	return ip_buf;
}


/*
 * GLOBAL
 * ԤХåե򻲾Ȥ
 * parameters : å,Хåե
 */
IP_BUFFER *referRecvBuf(SOCKET *sc)
{
	return sc->recvBuf;
}
