/*
 * mm.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * mm.c ѥإåե
 */


#ifndef mm_h
#define mm_h


#include<types.h>
#include<proc.h>
#include<fs.h>
#include<sys/system.h>


#define PAGE_SIZE 0x1000	/* Page size */


#ifndef ASM_FILE


enum{
	/* loadBinary() flag. */
	LB_R=1,
	LB_WR=2,
};


typedef struct{
	uint *pageDir;
	int pageDirGate;		/* ڡǥ쥯ȥåȡ */
	uint lastReadPage;		/* Last read only page address. */
	uint lastPageAddr;		/* ƺѤߥڡ饹ȥɥ쥹+1 */
}MM_STRUCT;


extern void *kmalloc(size_t);
extern void kfree(void*);
extern int initBackupDev(const char*);
extern void updateVm(void*);
extern uint getLastLinearAddr();
extern int checkMem(void*);
extern void initMm();
extern void *initPaging();
extern void *forkPage(MM_STRUCT*,void**);
extern int loadBinary(OPEN_F*,size_t,size_t,uint,int);
extern uint setArgAndEnv(char**, char**);
extern void releaseUserTextDataPage(void*);
extern void *getPhysAddrFromLinearAddr(void*,int*);
extern uint *getPageDir();
/**********************************************************/
extern uint *getKernelStackEntry();
extern uint addUserStack(int);
extern void delAddedUserStack();
/**********************************************************/
extern int sys_brk(void*);


#endif


#endif
