/*
 * keymap.h
 *
 * ܡѴɡ
 */


#include"types.h"


enum{
	/* ե󥯥󥭡 */
	KEY_FUNC=0xe0,

	/* ޥåץɡ */
	MAP_DEL= 0x7f,			/* Delete. */
	MAP_SHT= 0x80,			/* Shift. */
	MAP_CTR= 0x81,			/* Ctrl. */
	MAP_CPSL=0x82,			/* Caps Lock. */
	MAP_BS=  0x83,			/* Back Space. */
	MAP_LFT= 0x84,			/*  */
	MAP_RHT= 0x85,			/*  */
	MAP_ALT= 0,				/* Alt. */
	MIN_MAPKEY=MAP_DEL,		/* ղåǾ͡ */

	VMAP_START_COAD=0x47,	/* ۥޥåפλϤΥ󥳡ɡ */
	VMAP_END_COAD=0x54,		/* ۥޥåפκǸΥ󥳡ɡ */
	VMAP_ADD=19,			/* ۥޥåѴץ饹͡ */
};


/*
 * 106jpܡɥ
 */
static uchar keymap[][3]={
	{0,			0,			0},			/* 00 */
	{0,			0,			0},			/* 01 Esc */
	{'1',		'!',		0},			/* 02 '1' */
	{'2',		'"',		0},			/* 03 '2' */
	{'3',		'#',		0},			/* 04 '3' */
	{'4',		'$',		0},			/* 05 '4' */
	{'5',		'%',		0},			/* 06 '5' */
	{'6',		'&',		0},			/* 07 '6' */
	{'7',		'\'',		0},			/* 08 '7' */
	{'8',		'(',		0},			/* 09 '8' */
	{'9',		')',		0},			/* 0a '9' */
	{'0',		'~',		0},			/* 0b '0' */
	{'-',		'=',		0},			/* 0c '-' */
	{'^',		'~',		0},			/* 0d '^' */
	{MAP_BS,	MAP_BS,		MAP_BS},	/* 0e BackSpace */
	{'\t',		0,			0},			/* 0f Tab */
	{'q',		'Q',		'q'&0x1f},	/* 10 'q' */
	{'w',		'W',		'w'&0x1f},	/* 11 'w' */
	{'e',		'E',		'e'&0x1f},	/* 12 'e' */
	{'r',		'R',		'r'&0x1f},	/* 13 'r' */
	{'t',		'T',		't'&0x1f},	/* 14 't' */
	{'y',		'Y',		'y'&0x1f},	/* 15 'y' */
	{'u',		'U',		'u'&0x1f},	/* 16 'u' */
	{'i',		'I',		'i'&0x1f},	/* 17 'i' */
	{'o',		'O',		'o'&0x1f},	/* 18 'o' */
	{'p',		'P',		'p'&0x1f},	/* 19 'p' */
	{'@',		'`',		0},			/* 1a '@' */
	{'[',		'{',		0},			/* 1b '[' */
	{'\n',		'\n',		'\n'},		/* 1c Enter */
	{MAP_CTR,	MAP_CTR,	MAP_CTR},	/* 1d Ctrl */
	{'a',		'A',		'a'&0x1f},	/* 1e 'a' */
	{'s',		'S',		's'&0x1f},	/* 1f 's' */
	{'d',		'D',		'd'&0x1f},	/* 20 'd' */
	{'f',		'F',		'f'&0x1f},	/* 21 'f' */
	{'g',		'G',		'g'&0x1f},	/* 22 'g' */
	{'h',		'H',		'h'&0x1f},	/* 23 'h' */
	{'j',		'J',		'j'&0x1f},	/* 24 'j' */
	{'k',		'K',		'k'&0x1f},	/* 25 'k' */
	{'l',		'L',		'l'&0x1f},	/* 26 'l' */
	{';',		'+',		0},		    /* 27 ';' */
	{':',		'*',		0},			/* 28 ':' */
	{0,			0,			0},			/* 29  */
	{MAP_SHT,	MAP_SHT,	MAP_SHT},	/* 2a Shift */
	{']',		'}',		0},			/* 2b ']' */
	{'z',		'Z',		'z'&0x1f},	/* 2c 'z' */
	{'x',		'X',		'x'&0x1f},	/* 2d 'x' */
	{'c',		'C',		'c'&0x1f},	/* 2e 'c' */
	{'v',		'V',		'v'&0x1f},	/* 2f 'v' */
	{'b',		'B',		'b'&0x1f},	/* 30 'b' */
	{'n',		'N',		'n'&0x1f},	/* 31 'n' */
	{'m',		'M',		'm'&0x1f},	/* 32 'm' */
	{',',		'<',		0},			/* 33 ',' */
	{'.',		'>',		0},			/* 34 '.' */
	{'/',		'?',		'0'},		/* 35 '/' */
	{MAP_SHT,	MAP_SHT,	MAP_SHT},	/* 36 Shift */
	{'*',		'*',		'*'},		/* 37 '*' */
	{MAP_ALT,	MAP_ALT,	MAP_ALT},	/* 38 Alt */
	{' ',		' ',		0},			/* 39 ' ' */
	{MAP_CPSL,	MAP_CPSL,	MAP_CPSL},	/* 3a CapsLock */
	{0,			0,			0},			/* 3b F1 */
	{0,			0,			0},			/* 3c F2 */
	{0,			0,			0},			/* 3d F3 */
	{0,			0,			0},			/* 3e F4 */
	{0,			0,			0},			/* 3f F5 */
	{0,			0,			0},			/* 40 F6 */
	{0,			0,			0},			/* 41 F7 */
	{0,			0,			0},			/* 42 F8 */
	{0,			0,			0},			/* 43 F9 */
	{0,			0,			0},			/* 44 F10 */
	{0,			0,			0},			/* 45 NumLock */
	{0,			0,			0},			/* 46 ScrLock */
	{'7',		'7',		'7'},		/* 47 '7' */
	{'8',		'8',		'8'}, 		/* 48 '8' */
	{'9',		'9',		'9'}, 		/* 49 '9' */
	{'-',		'-',		'-'}, 		/* 4a '-' */
	{'4',		'4',		'4'}, 		/* 4b '4' */
	{'5',		'5',		'5'}, 		/* 4c '5' */
	{'6',		'6',		'6'}, 		/* 4d '6' */
	{'+',		'+',		'+'}, 		/* 4e '+' */
	{'1',		'1',		'1'}, 		/* 4f '1' */
	{'2',		'2',		'2'}, 		/* 50 '2' */
	{'3',		'3',		'3'}, 		/* 51 '3' */
	{'0',		'0',		'0'}, 		/* 52 '0' */
	{'.',		'.',		'.'},		/* 53 '.' */
	{0,			0,			0},			/* 54 PrtSc */
	{0,			0,			0},			/* 55 */
	{0,			0,			0},			/* 56 */
	{0,			0,			0},			/* 57 F11 */
	{0,			0,			0},			/* 58 F12 */
	{0,			0,			0},			/* 59 */
	{0,			0,			0},			/* 5a ۥޥå 47 Home */
	{0,			0,			0},			/* 5b ۥޥå 48  */
	{0,			0,			0},			/* 5c ۥޥå 49 PageUp */
	{0,			0,			0},			/* 5d ۥޥå 4a */
	{MAP_LFT,	MAP_LFT,	MAP_LFT},	/* 5e ۥޥå 4b  */
	{0,			0,			0},			/* 5f ۥޥå 4c */
	{MAP_RHT,	MAP_RHT,	MAP_RHT},	/* 60 ۥޥå 4d  */
	{0,			0,			0},			/* 61 ۥޥå 4e End */
	{0,			0,			0},			/* 62 ۥޥå 4f */
	{0,			0,			0},			/* 63 ۥޥå 50  */
	{0,			0,			0},			/* 64 ۥޥå 51 PageDown */
	{0,			0,			0},			/* 65 ۥޥå 52 Insert */
	{MAP_DEL,	MAP_DEL,	MAP_DEL},	/* 66 ۥޥå 53 Delete */
	{0,			0,			0},			/* 67 ۥޥå 54 PrintScreen */
	{0,			0,			0},			/* 68 */
	{0,			0,			0},			/* 69 */
	{0,			0,			0},			/* 6a */
	{0,			0,			0},			/* 6b */
	{0,			0,			0},			/* 6c */
	{0,			0,			0},			/* 6d */
	{0,			0,			0},			/* 6e */
	{0,			0,			0},			/* 6f */
	{0,			0,			0},			/* 70  */
	{0,			0,			0},			/* 71 */
	{0,			0,			0},			/* 72 */
	{'\\',		'_',		0},			/* 73 '\' */
	{0,			0,			0},			/* 74 */
	{0,			0,			0},			/* 75 */
	{0,			0,			0},			/* 76 */
	{0,			0,			0},			/* 77 */
	{0,			0,			0},			/* 78 */
	{0,			0,			0},			/* 79 Ѵ */
	{0,			0,			0},			/* 7a */
	{0,			0,			0},			/* 7b ̵Ѵ */
	{0,			0,			0},			/* 7c */
	{'\\',		'|',		0},			/* 7d '\' */
	{0,			0,			0},			/* 7e */
	{0,			0,			0},			/* 7f */
};
