/*
 * device.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef device_h
#define device_h


#include"types.h"


#ifndef ASM_FILE


enum{
	/* ǥХ̡ */
	DEV_CLASS_BLOCK=0,		/* ֥åǥХ */
	DEV_CLASS_CHARA,		/* 饯ǥХ */
	DEV_CLASS_NETWORK,		/* ͥåȥǥХ */
};


/* ʪǥХȤ */
typedef struct DEV_INFO{
	const char *name;					/* Device name */
/*	int dev_class;*/					/* Device class. */
	int sector_size;					/* Secter size */
	uint begin_blk;						/* Begin block number */
	uint last_blk;						/* Last block number */
	int (*open)();						/* parameters : device name */
	int (*read)(void*,size_t,size_t);	/* parameters : Buffer,transfer blocks,Begin block number */
	int (*write)(void*,size_t,size_t);	/* parameters : Buffer,transfer blocks,Begin block number */
	int (*ioctl)(int,...);				/* parameters : Comand */
	int (*select)(int,int);				/* parameters : ioμflag,polling flag */
	void *linf;							/* Device local infomation address. */
	struct DEV_INFO *next;
}DEV_INFO;

/* ǥХơȹ¤Ρ */
typedef struct{
	uchar       prt_type;		/* ѡƥ󥿥 */
	uchar       prt_num;		/* ѡƥʥС */
	ushort      sect_size;		/*  */
	uint        all_sect;		/*  */
	const char *name;
}DEV_STAT;


extern int init_device();
extern int regist_device(DEV_INFO*);
extern int delete_device(const char*);
extern int get_devstat(int,DEV_STAT*);
extern int sys_sync();
extern int read_direct(int,void*,size_t,size_t);
extern int write_direct(int,void*,size_t,size_t);
extern int read_cache(int,void*,size_t,size_t);
extern int write_cache(int,void*,size_t,size_t);
extern int sys_ttyname(int,char*);


#endif


#endif
