/*
 * wait.h
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef wait_h
#define wait_h


#include<types.h>
#include<proc.h>


#ifndef ASM_FILE


/* ץ󥯹¤ */
typedef struct PROC_LINK{
	struct PROC_LINK *next;
	struct PROC_LINK *prev;
}PROC_LINK;

/* ץȥå塼¤ */
typedef struct WAIT_QUEUE{
	void  *wait_next;		/* ȥ󥯤μΥץ */
	void  *wait_prev;		/* ȥ󥯤Υץ */
	ushort update;			/* 񤭹ߥե饰 */
	ushort cnt;				/* Wait count. */
	int    gate;			/* Lock gate. */
}WAIT_QUEUE;

/* ޡԤѹ¤ */
typedef struct WAIT_INTR{
	PROC *proc;					/* Ԥץ */
	int flag;					/* ॢȥե饰 */
}WAIT_INTR;


extern void waitSemaphore(WAIT_QUEUE*);
extern void wakeSemaphore(WAIT_QUEUE*);
extern int wait_intr(WAIT_INTR*,uint,int);
extern void wake_intr(WAIT_INTR*,int);


#endif


#endif
