/*
 * wait.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<types.h>
#include<proc.h>
#include<lib.h>
#include<lock.h>
#include<interrupt.h>
#include<time.h>
#include<wait.h>


/*
 * PRIVATE
 * PROC_LINK¤Υɥ쥹PROCɥ쥹롣
 */
static inline PROC *waitLinkToProc(PROC_LINK *p)
{
	return (PROC*)((uint)p-(uint)&((PROC*)0)->wait_next);
}


/******************************************************************************************************
 *
 * ߥ
 *
 *******************************************************************************************************/


/*
 * GLOBAL
 * ա
 *  ƤӽФ˰wait->flag0Ƥɬפ롣
 * parameters : ߹¤,ॢ(ms),ȥե饰
 * return : 0,ॢ-1
 */
int wait_intr(WAIT_INTR *wait,uint time,int flag)
{
	wait->proc = get_current_task();

	cli();
	{
		/* ˳ߤ? */
		if(wait->flag == 1)
		{
			wait->flag = 0;
			sti();
			return 0;
		}
		set_timer(time);

		del_from_schedule(flag);
		wait->flag=1;
	}
	sti();

	wait_task();

	return wait->flag-1;
}


void wake_intr(WAIT_INTR *wait,int flag)
{
	/* ץwait˳ߤ? */
	if(wait->flag == 0)
	{
		wait->flag = 1;
		return;
	}

	del_timer(&wait->proc->timer);
	wait->flag = 0;
	/*
	 * 塼ؤɲäϽκǸ˹Ԥʤߤ顢
	 * ٤Τ̤Τޤwakeץ¹ԤƤޤ
	 */
	add_to_schedule(wait->proc,flag);
/******************************************************
{
	PROC *p,*q;

	for(p=q=get_current_task();;p=p->next)
	{
		printk("%x ",p);
		if(p==p->next)
		{
			printk("%x\n",p);
			break;
		}
		if(p->next==q)
		{
			printk("\n");
			break;
		}
	}

}
******************************************************/
}


/******************************************************************************************************
 *
 * ޥե
 *
 *******************************************************************************************************/


/*
 * GLOBAL
 * parameters : Wait queue
 */
void waitSemaphore(WAIT_QUEUE *queue)
{
	PROC *proc;
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	enter_spinlock(&queue->gate);
	if(queue->update==0)
	{
		queue->update=1;
		wait->next=wait->prev=wait;
		exit_spinlock(&queue->gate);

		return;
	}
	else
	{
		proc=get_current_task();
		p=(PROC_LINK*)&proc->wait_next;

		/* Add process to wait queue */
		p->next=wait;
		p->prev=wait->prev;
		wait->prev->next=p;
		wait->prev=p;

		exit_spinlock(&queue->gate);

		del_from_schedule(TASK_WAIT);
	}

	wait_task();
}


/*
 * GLOBAL
 */
void wakeSemaphore(WAIT_QUEUE *queue)
{
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	/* Delete process from wait queue */
	enter_spinlock(&queue->gate);
	{
		if(wait->next!=wait)
		{
			p=wait->next;
			wait->next=p->next;
			wait->next->prev=wait;

			/* Add process to schedule */
			add_to_schedule(waitLinkToProc(p),TASK_WAIT);
		}
		else queue->update=0;
	}
	exit_spinlock(&queue->gate);
}


/******************************************************************************************************
 *
 * ͭޥե
 *
 *******************************************************************************************************/


/*
 * GLOBAL
 * ߥȡ
 * parameters : Wait queue
 */
void waitUpdate(WAIT_QUEUE *queue)
{
	PROC *proc;
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	enter_spinlock(&queue->gate);
	{
		queue->update=1;		/* ȥե饰 */

		/* ޥեȴ롣 */
		if(queue->cnt==0)
		{
			queue->cnt+=1;
			wait->next=wait->prev=wait;

			exit_spinlock(&queue->gate);
			return;
		}

		proc=get_current_task();
		p=(PROC_LINK*)&proc->wait_next;

		/* Add process to wait queue */
		p->next=wait;
		p->prev=wait->prev;
		wait->prev->next=p;
		wait->prev=p;

		proc->wait_update=1;	/* Ԥץե饰 */
	}
	exit_spinlock(&queue->gate);

	/* Ԥ */
	del_from_schedule(TASK_WAIT);
	wait_task();

	/* 衣 */
	proc->wait_update=0;
	queue->cnt+=1;
}


/*
 * GLOBAL
 * ɹߥ
 * parameters : Wait queue
 */
void waitRead(WAIT_QUEUE *queue)
{
	PROC *proc;
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	enter_spinlock(&queue->gate);
	{
		/* ޥեȴ롣 */
		if(queue->update==0)
		{
			queue->cnt+=1;
			wait->next=wait->prev=wait;

			exit_spinlock(&queue->gate);
			return;
		}

		proc=get_current_task();
		p=(PROC_LINK*)&proc->wait_next;

		/* Add process to wait queue */
		p->next=wait;
		p->prev=wait->prev;
		wait->prev->next=p;
		wait->prev=p;
	}
	exit_spinlock(&queue->gate);

	/* Ԥ */
	del_from_schedule(TASK_WAIT);
	wait_task();

	/* 衣 */
	queue->cnt+=1;
}


/*
 * GLOBAL
 */
void wakeShare(WAIT_QUEUE *queue)
{
	PROC_LINK *p,*wait;


	wait=(PROC_LINK*)&queue->wait_next;

	/* Delete process from wait queue */
	enter_spinlock(&queue->gate);
	{
		if((queue->cnt-=1)==0)
		{
			if(wait->next!=wait)
			{
				/* ǽԤץ򵯤 */
				p=wait->next;
				wait->next=p->next;
				wait->next->prev=wait;
				add_to_schedule(waitLinkToProc(p),TASK_WAIT);

				/* 񤭹Ԥץޤǵ */
				for(;;)
				{
					if((p=wait->next)==wait)
					{
						queue->update=0;
						break;
					}
					if(waitLinkToProc(p)->wait_update==1)break;

					/* Ԥץ򵯤 */
					wait->next=p->next;
					wait->next->prev=wait;
					add_to_schedule(waitLinkToProc(p),TASK_WAIT);
				}
			}
			else queue->update=0;
		}
	}
	exit_spinlock(&queue->gate);
}
