/*
 * socket.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<unistd.h>
#include<sys/types.h>
#include<callgate.h>
#include<share/syscall.h>
#include<errno.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<share/ip.h>


int socket(int domain, int type, int protocol)
{
	int rest;


	if(type==SOCK_RAW)
		if(getuid()!=0)return _error(EACCES);

	if((rest=syscall4(SYS_SOCKET,domain,type,protocol))<0)
		return _error(-rest);

	return rest;
}


ssize_t sendto(int s, const void *msg, size_t len, int flags, const struct sockaddr *to, socklen_t tolen)
{
	int rest;


	if(tolen<sizeof(struct sockaddr_in))return _error(EINVAL);
	if((rest=syscall6(SYS_SEND,s,(int)msg,len,flags,(int)to))<0)
		return _error(-rest);

	return rest;
}

ssize_t send(int s, const void *msg, size_t len, int flags)
{
	int rest;


	if((rest=syscall6(SYS_SEND,s,(int)msg,len,flags,(int)NULL))<0)
		return _error(-rest);

	return rest;
}


ssize_t recvfrom(int s, void *buf, size_t len, int flags, struct sockaddr *from, socklen_t *fromlen)
{
	int rest;


	if((rest=syscall7(SYS_RECV,s,(int)buf,len,flags,(int)from,(int)fromlen))<0)
		return _error(-rest);

	return rest;
}


int connect(int sockfd, const struct sockaddr *serv_addr, socklen_t addrlen)
{
	int rest;


	if((rest=syscall4(SYS_CONNECT,sockfd,(int)serv_addr,addrlen))<0)
		return _error(-rest);

	return rest;
}


int shutdown(int s, int how)
{
	int rest;


	if((how&(SHUT_RD|SHUT_WR|SHUT_RDWR))==0)return _error(-EINVAL);
	if((rest=syscall3(SYS_SHUTDOWN,s,how))<0)return _error(-rest);

	return rest;
}


int bind(int sockfd, const struct sockaddr *my_addr, socklen_t addrlen)
{
	int rest;


	if(addrlen<sizeof(struct sockaddr_in))return _error(EINVAL);
	if((rest=syscall3(SYS_BIND,sockfd,(int)my_addr))<0)return _error(-rest);

	return rest;
}


int listen(int s, int backlog)
{
	int rest;


	if((rest=syscall3(SYS_LISTEN,s,backlog))<0)return _error(-rest);

	return 0;
}


int accept(int s, struct sockaddr *addr, socklen_t *addrlen)
{
	int rest;


	if((rest=syscall4(SYS_ACCEPT,s,(int )addr,(int)addrlen))<0)
		return _error(-rest);

	return rest;
}


/*
 * åη׻
 * parameters : data1 address,data2 address,byte size1,byte size2
 * return : פ
 */
ushort calcSum(uint *data,int size)
{
	union{
		unsigned long long u64;
		uint               u32[2];
		ushort             u16[4];
	}sum;
	uint tmp;


	sum.u64=0;
	for(;size>=sizeof(uint);size-=sizeof(uint))
		sum.u64+=*data++;
	if(size>0)sum.u64+=*data&((1<<(size*8))-1);

	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u64+=tmp;
	tmp=sum.u32[1];
	sum.u32[1]=0;
	sum.u32[0]+=tmp;

	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u32[0]+=tmp;
	tmp=sum.u16[1];
	sum.u16[1]=0;
	sum.u16[0]+=tmp;

	return ~sum.u16[0];
}
