/*
 * truncate.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#include<sys/types.h>
#include<unistd.h>
#include<fcntl.h>
#include<stdlib.h>
#include<string.h>
#include<stropts.h>


int ftruncate(int fd, off_t length)
{
	char *buf;
	size_t size;


	/* Хåեɤࡣ */
	if(lseek(fd,0,SEEK_SET)==-1)return -1;
	if((buf=malloc(length))==NULL)return -1;
	if((size=read(fd,buf,length))==-1)goto ERR;

	/* 0ѥǥ󥰡 */
	if(size<length)
		memset(buf+size,0,length-size);

	/* Truncate. */
	if(ioctl(fd,I_TRUNC)==-1)goto ERR;

	/* 񤭹ߡ */
	if(lseek(fd,0,SEEK_SET)==-1)return -1;
	if(write(fd,buf,length)==-1)goto ERR;

	free(buf);

	return 0;
ERR:
	free(buf);
	return -1;
}


int truncate(const char *path, off_t length)
{
	int fd;


	if((fd=open(path,O_RDWR))==-1)return -1;
	if(ftruncate(fd,length)==-1)return -1;
	return close(fd);
}

