/*
 * sys/time.h
 */


#ifndef sys_time_h
#define sys_time_h


#include<sys/select.h>
#include<share/time.h>


struct timezone {
    int tz_minuteswest; /* minutes west of Greenwich */
    int tz_dsttime; 	/* type of dst correction */
};

struct itimerval {
    struct  timeval it_interval;    /* timer interval */
    struct  timeval it_value;   	/* current value */
};


/* ץ */
#define	TIMEVAL_TO_TIMESPEC(tv, ts) {				\
	(ts)->ts_sec = (tv)->tv_sec;					\
	(ts)->ts_nsec = (tv)->tv_usec * 1000;			\
}
#define	TIMESPEC_TO_TIMEVAL(tv, ts) {				\
	(tv)->tv_sec = (ts)->ts_sec;					\
	(tv)->tv_usec = (ts)->ts_nsec / 1000;			\
}


extern int utimes(const char *path, const struct timeval *times);
extern int lutimes(const char *path, const struct timeval *times);
extern int gettimeofday(struct timeval *tv, struct timezone *tz);
extern int settimeofday(struct timeval *tp, const struct timezone *tzp);


#endif
