/*
 * stat.h
 */


#ifndef sys_stat_h
#define sys_stat_h


#include<sys/types.h>
#include<share/stat.h>


enum{
	/* File type. */
	S_IFMT=0xF000,		/* format mask */

	/* File mode bits. */
	S_ISUID=0x0800,		/* Set-user-ID on execution. */
	S_ISGID=0x0400,		/* Set-group-ID on execution. */
	S_IRWXU=0x01C0,		/* Read, write, execute/search by owner. */
	S_IRUSR=0x0100,		/* Read permission, owner. */
	S_IWUSR=0x0080,		/* Write permission, owner. */
	S_IXUSR=0x0040,		/* Execute/search permission, owner. */
	S_IRWXG=0x0038,		/* Read, write, execute/search by group. */
	S_IRGRP=0x0020,		/* Read permission, group. */
	S_IWGRP=0x0010,		/* Write permission, group. */
	S_IXGRP=0x0008,		/* Execute/search permission, group. */
	S_IRWXO=0x0007,		/* Read, write, execute/search by others. */
	S_IROTH=0x0004,		/* Read permission, others. */
	S_IWOTH=0x0002,		/* Write permission, others. */
	S_IXOTH=0x0001,		/* Execute/search permission, others. */

	S_ISVTX=0x200,		/* save swapped text even after use */
	S_ISTXT=0x200,		/* sticky bit */

	/* File types. */
	S_IFIFO= 0x1000,	/* fifo */
	S_IFCHR= 0x2000,	/* character device */
	S_IFDIR= 0x4000,	/* directory */
	S_IFBLK= 0x6000,	/* block device */
	S_IFREG= 0x8000,	/* regular file */
	S_IFLNK= 0xA000,	/* symbolic link */
	S_IFSOCK=0xC000,	/* socket */
	S_IFWHT= 0xE000,	/* whiteout */

	ALLPERMS=   S_ISUID|S_ISGID|S_ISTXT|S_IRWXU|S_IRWXG|S_IRWXO,
	DEFFILEMODE=S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH,
};


/* The macro shall evaluate to a non-zero value if the test is true; 0 if the test is false. */
#define S_ISFIFO(m) ((m&S_IFIFO)==S_IFIFO)		/* Test for a pipe or FIFO special file. */
#define S_ISCHR(m)  ((m&S_IFCHR)==S_IFCHR)		/* Test for a character special file. */
#define S_ISDIR(m)  ((m&S_IFDIR)==S_IFDIR)		/* Test for a directory. */
#define S_ISBLK(m)  ((m&S_IFBLK)==S_IFBLK)		/* Test for a block special file. */
#define S_ISREG(m)  ((m&S_IFREG)==S_IFREG)		/* Test for a regular file. */
#define S_ISLNK(m)  ((m&S_IFLNK)==S_IFLNK)		/* Test for a symbolic link. */
#define S_ISSOCK(m) ((m&S_IFSOCK)==S_IFSOCK)	/* Test for a socket. */
#define	S_ISWHT(m)	((m&S_IFWHT)==S_IFWHT)		/* whiteout. */

/*
 * The implementation may implement message queues, semaphores, or shared memory objects as distinct
 * file types. The following macros shall be provided to test whether a file is of the specified type.
 * The value of the buf argument supplied to the macros is a pointer to a stat structure. The macro
 * shall evaluate to a non-zero value if the specified object is implemented as a distinct file type
 * and the specified file type is contained in the stat structure referenced by buf. Otherwise,
 * the macro shall evaluate to zero.
 */
#define S_TYPEISMQ(buf)			/* Test for a message queue. */
#define S_TYPEISSEM(buf)		/* Test for a semaphore. */
#define S_TYPEISSHM(buf)		/* Test for a shared memory object. */

/*
 * Definitions of flags stored in file flags word.
 *
 * Super-user and owner changeable flags.
 */
#define	UF_SETTABLE	0x0000ffff	/* mask of owner changeable flags */
#define	UF_NODUMP	0x00000001	/* do not dump file */
#define	UF_IMMUTABLE	0x00000002	/* file may not be changed */
#define	UF_APPEND	0x00000004	/* writes to file may only append */
#define UF_OPAQUE	0x00000008	/* directory is opaque wrt. union */
/*
 * Super-user changeable flags.
 */
#define	SF_SETTABLE	0xffff0000	/* mask of superuser changeable flags */
#define	SF_ARCHIVED	0x00010000	/* file is archived */
#define	SF_IMMUTABLE	0x00020000	/* file may not be changed */
#define	SF_APPEND	0x00040000	/* writes to file may only append */


/* functions and may also be defined as macros. */
extern int	  chflags (const char *, u_long);
extern int    chmod(const char*, mode_t);
extern int	  fchflags (int, u_long);
extern int    fchmod(int, mode_t);
extern int    fstat(int, struct stat*);
extern int    lchmod(const char*, mode_t);
extern int    lstat(const char *, struct stat *);
extern int    mkdir(const char*, mode_t);
extern int    mkfifo(const char*, mode_t);
extern int    mknod(const char *, mode_t, dev_t);
extern int    stat(const char*, struct stat*);
extern mode_t umask(mode_t);

extern int openMask;	/* եεĥӥåȥޥ */


#endif
