/*
 * socket.h
 */


#ifndef sys_socket_h
#define sys_socket_h


#include<sys/uio.h>


#ifndef ASM_FILE


enum{
	/* socket domain. */
	AF_UNSPEC=0,	/* Unspecified. */
	AF_INET,		/* Internet domain sockets for use with IPv4 addresses. */
	AF_INET6,		/* Internet domain sockets for use with IPv6 addresses. */
	AF_UNIX,		/* UNIX domain sockets. */

	/* socket type. */
	SOCK_DGRAM=1,	/* Datagram socket. */
	SOCK_RAW,		/* Raw Protocol Interface. */
	SOCK_SEQPACKET,	/* Sequenced-packet socket. */
	SOCK_STREAM,	/* Byte-stream socket. */

	/* recv  flags */
	MSG_CTRUNC= 1<<0,	/* Control data truncated. */
	MSG_EOR=    1<<1,	/* Terminates a record (if supported by the protocol). */
	MSG_OOB=    1<<2,	/* Out-of-band data. */
	MSG_PEEK=   1<<3,	/* Leave received data in queue. */
	MSG_TRUNC=  1<<4,	/* Normal data truncated. */
	MSG_WAITALL=1<<5,	/* Attempt to fill the read buffer. */

	/* shutdownΥե饰 */
	SHUT_RD=  1<<0,				/* Disables further receive operations. */
	SHUT_WR=  1<<1,				/* Disables further send operations. */
	SHUT_RDWR=SHUT_RD|SHUT_WR,	/* Disables further send and receive operations. */

	/* ƥॳsys_get_sockaddr()ѥե饰 */
	GET_SOCKADDR_REMOT=1,		/* ⡼ȥɥ쥹롣 */
	GET_SOCKADDR_LOCAL=2,		/* 륢ɥ쥹롣 */

	SOL_SOCKET=20,		/* Options to be accessed at socket level, not protocol level. */

	/* socket options. */
	SO_ACCEPTCONN=1,	/* Socket is accepting connections. */
	SO_BROADCAST,		/* Transmission of broadcast messages is supported. */
	SO_DEBUG,			/* Debugging information is being recorded. */
	SO_DONTROUTE,		/* Bypass normal routing. */
	SO_ERROR,			/* Socket error status. */
	SO_KEEPALIVE,		/* Connections are kept alive with periodic messages. */
	SO_LINGER,			/* Socket lingers on close. */
	SO_OOBINLINE,		/* Out-of-band data is transmitted in line. */
	SO_RCVBUF,			/* Receive buffer size. */
	SO_RCVLOWAT,		/* Receive "low water mark". */
	SO_RCVTIMEO,		/* Receive timeout. */
	SO_REUSEADDR ,		/* Reuse of local addresses is supported. */
	SO_SNDBUF,			/* Send buffer size. */
	SO_SNDLOWAT,		/* Send "low water mark". */
	SO_SNDTIMEO,		/* Send timeout. */
	SO_TYPE,			/* Socket type. */

	/* Protocol families, same as address families for now. */
	PF_UNSPEC=	AF_UNSPEC,
	PF_UNIX=	AF_UNIX,
	PF_INET=	AF_INET,
};


typedef int          socklen_t;
typedef unsigned int sa_family_t;


struct sockaddr{
	sa_family_t  sa_family;		/* Address family. */
	char         sa_data[0];	/* Socket address (variable-length data). */
};


struct sockaddr_storage{
	sa_family_t   ss_family;
};

struct cmsghdr{
	socklen_t  cmsg_len;	/* Data byte count, including the cmsghdr. */
	int        cmsg_level;	/* Originating protocol. */
	int        cmsg_type;	/* Protocol-specific type. */
};

struct linger{
	int  l_onoff;	/* Indicates whether linger option is enabled. */
	int  l_linger;	/* Linger time, in seconds. */
};

struct msghdr{
	void          *msg_name;		/* Optional address. */
	socklen_t      msg_namelen;		/* Size of address. */
	struct iovec  *msg_iov;			/* Scatter/gather array. */
	int            msg_iovlen;		/* Members in msg_iov. */
	void          *msg_control;		/* Ancillary data; see below. */
	socklen_t      msg_controllen;	/* Ancillary data buffer len. */
	int            msg_flags;		/* Flags on received message. */
};


#ifndef KERNEL
extern int     accept(int, struct sockaddr *, socklen_t *);
extern int     bind(int, const struct sockaddr *, socklen_t);
extern int     connect(int, const struct sockaddr *, socklen_t);
extern int     getpeername(int, struct sockaddr *, socklen_t *);
extern int     getsockname(int, struct sockaddr *, socklen_t *);
extern int     getsockopt(int, int, int, void *, socklen_t *);
extern int     listen(int, int);
extern ssize_t recvfrom(int, void *, size_t, int,struct sockaddr *, socklen_t *);
extern ssize_t recv(int, void *, size_t, int);
extern ssize_t sendto(int, const void *, size_t, int, const struct sockaddr *,socklen_t);
extern ssize_t send(int, const void *, size_t, int);
extern int     socketpair(int, int, int, int[2]);
extern int     shutdown(int, int);
extern int     socket(int, int, int);
extern ushort calcSum(uint*,int);

extern inline ssize_t recv(int s, void *buf, size_t len, int flags)
{
	return recvfrom(s,buf,len,flags,NULL,NULL);
}

/* ̤ */
extern ssize_t recvmsg(int, struct msghdr *, int);
extern ssize_t sendmsg(int, const struct msghdr *, int);
extern int     setsockopt(int, int, int, const void *, socklen_t);
#endif


#endif


#endif
