/*
 * sys/select.h
 */


#ifndef sys_select_h
#define sys_select_h


#include<sys/types.h>


#ifndef ASM_FILE


struct timeval{
	time_t         tv_sec;		/* Seconds. */
	suseconds_t    tv_usec;		/* Microseconds. */
};


#ifndef KERNEL


#include<share/select.h>
#include<limits.h>


enum{
	FD_SETSIZE=OPEN_MAX,	/* Maximum number of file descriptors in an fd_set structure. */
};


#define FD_CLR(fd,fdset)   (((char*)fdset)[fd/CHAR_BIT]&=~(char)(1<<(fd%CHAR_BIT)))
#define FD_ISSET(fd,fdset) (((char*)fdset)[fd/CHAR_BIT]&(char)(1<<(fd%CHAR_BIT)))
#define FD_SET(fd,fdset)   (((char*)fdset)[fd/CHAR_BIT]|=(char)(1<<(fd%CHAR_BIT)))
#define FD_ZERO(fdset)     ((fdset)->bitmap=0)


extern int select(int nfds, fd_set *readfds, fd_set *writefds, fd_set *errorfds, struct timeval *timeout);


#endif


#endif


#endif
