/*
 * string.h
 *
 * Copyright 2003, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef string_h
#define string_h


#include<sys/types.h>
#include<stddef.h>


extern void    *memcpy(void *, const void *, size_t);
extern int      memcmp(const void *s1,const void *s2,size_t n);
extern void    *memchr(const void *s, int c, size_t n);
extern int      strcmp(const char *s1,const char *s2);
extern int      strncmp(const char *s1, const char *s2, size_t n);
extern char    *strcpy(char *s1,const char *s2);
extern size_t   strlen(const char *s);
extern char    *strncpy(char *s1,const char *s2,size_t n);
extern char    *strcat(char *s1,const char *s2);
extern char    *strncat(char *dest, const char *src, size_t n);
extern void    *memset(void *, int, size_t);
extern char    *strpbrk(const char *s1, const char *s2);
extern size_t   strcspn(const char *s1, const char *s2);
extern size_t   strspn(const char *s1, const char *s2);
extern char    *strstr(const char *s, const char *find);
extern size_t   strxfrm(char *dst, const char *src, size_t n);
extern int      strcasecmp(const char *, const char *);
extern char    *strdup(const char *s);
extern int      strncasecmp(const char *, const char *, size_t);
extern char    *strerror(int);
extern void     strmode(mode_t, char *);
extern char    *strsep(char **,const char *);
extern char    *strtok(char *, const char *);
extern size_t   strlcpy(char*,const char*,size_t);
extern void     swab(const void *src, void *est,ssize_t nbytes);

extern inline void bzero(void *s, size_t n)
{
	memset(s,0,n);
}

extern inline void *memmove(void *dest, const void *src, size_t n)
{
	int i;


	if((src<dest)&&((char*)src+n>(char*)dest))
	{
		for(i=n-1;i>=0;--i)((char*)dest)[i]=((char*)src)[i];

		return dest;
	}
	else return memcpy(dest,src,n);
}

extern inline char *strchr(const char *s,int c)
{
	for(;*s!='\0';++s)
		if(*s==(char)c)return (char*)s;

	return NULL;
}

extern inline char *strrchr(const char *s, int c)
{
	char *r=NULL;


	for(;*s!='\0';++s)
		if(*s==(char)c)r=(char*)s;

	return r;
}

extern inline int strcoll(const char *s1, const char *s2)
{
	return strcmp(s1,s2);
}

extern inline void bcopy(const void *src, void *dest, size_t n)
{
	memcpy(dest,src,n);
}

#endif
