/*
 * pwd.h
 */


#ifndef pwd_h
#define pwd_h


#include<sys/types.h>


enum{
	_PASSWORD_LEN=64,
	_PASSWORD_EFMT1='_' /* extended encryption format */

};


struct passwd{
	char    *pw_name;	/* User's login name. */
	char	*pw_passwd;	/* encrypted password */
	uid_t    pw_uid;	/* Numerical user ID. */
	gid_t    pw_gid;	/* Numerical group ID. */
	char    *pw_dir;	/* Initial working directory. */
	char    *pw_shell;	/*  Program to use as shell. */
	time_t	pw_change;		/* password change time */
	time_t	pw_expire;		/* account expiration */
};


extern void           endpwent(void);
extern struct passwd *getpwnam(const char *);
extern struct passwd *getpwuid(uid_t);


#endif
