/*
 * limits.h
 */


#ifndef limits_h
#define limits_h


#include<share/config.h>
#include<sys/types.h>


enum{
	CHAR_BIT= sizeof(char)*8,			/* number of bits in a char. */
	CHAR_MAX= 0x7f,						/* maximum value of type char. */
	CHAR_MIN= (char)0xff,				/* minimum value of type char. */
	SCHAR_MAX=CHAR_MAX,					/* maximum value of type signed char. */
	SCHAR_MIN=CHAR_MIN,					/* minimum value of type signed char. */
	UCHAR_MAX=0xff,						/* maximum value of type unsigned char. */
	SHRT_MAX= 0x7fff,					/* maximum value of type short. */
	SHRT_MIN= (short)0xffff,			/* minimum value of type short. */
	USHRT_MAX=0xffff,					/* maximum value of type unsigned short. */
	INT_MAX=  (int)0x7fffffff,			/* maximum value of type int. */
	INT_MIN=  (int)0xffffffff,			/* minimum value of type int. */
	UINT_MAX= (unsigned int)0xffffffff,	/* maximum value of type unsigned int. */
	LONG_MAX= INT_MAX,					/* maximum value of type long. */
	LONG_MIN= INT_MIN,					/* minimum value of type long. */
	ULONG_MAX=UINT_MAX,					/* maximum value of type unsigned long. */

	/* Minimam value. */
	_POSIX_ARG_MAX=     4096,	/* Maximum length of argument to the exec functions including environment data. */
	_POSIX_CHILD_MAX=   6,		/* Maximum number of simultaneous processes per real user ID. */
	_POSIX_STREAM_MAX=  8,		/* The number of streams that one process can have open at one time. */
	_POSIX_TZNAME_MAX=  6,		/* Maximum number of bytes supported for the name of a timezone. */
	_POSIX_OPEN_MAX=    20,		/* Maximum number of files that one process can have open at any one time. */
	_POSIX_LINK_MAX=    8,		/* Maximum number of links to a single file. */
	_POSIX_MAX_CANON=   255,	/* Maximum number of bytes in a terminal canonical input queue. */
	_POSIX_MAX_INPUT=   255,	/* Maximum number of bytes allowed in a terminal input queue. */
	_POSIX_NAME_MAX=    14,		/* Maximum number of bytes in a filename (not including terminating null). */
	_POSIX_PATH_MAX=    256,	/* Maximum number of bytes in a pathname. */
	_POSIX_PIPE_BUF=    512,	/* Maximum number of bytes that is guaranteed to be atomic when writing to a pipe. */
	_POSIX_TTY_NAME_MAX=9,		/* The size of the storage required for a terminal device name, including the terminating null. */
	_POSIX_HOST_NAME_MAX=255,	/* Maximum length of a host name (not including the terminating null) as returned from the gethostname() function. */
	_POSIX_LOGIN_NAME_MAX=9,	/* The size of the storage required for a login name, in bytes, including the terminating null. */
	_POSIX_NGROUPS_MAX=  8,		/* Maximum number of simultaneous supplementary group IDs per process. */

	ARG_MAX=       _POSIX_ARG_MAX,
	ATEXIT_MAX=    32,
	CHILD_MAX=     _POSIX_CHILD_MAX,
	STREAM_MAX=    _POSIX_STREAM_MAX,
	TZNAME_MAX=    _POSIX_TZNAME_MAX,
	OPEN_MAX=      MAX_FILE_OPEN,
	PATH_MAX=      _POSIX_PATH_MAX,
	NAME_MAX=      255,
	PIPE_BUF=      _POSIX_PIPE_BUF,
	TTY_NAME_MAX=  _POSIX_TTY_NAME_MAX,
	HOST_NAME_MAX= _POSIX_HOST_NAME_MAX,
	LOGIN_NAME_MAX=_POSIX_LOGIN_NAME_MAX,
	MAXCOMLEN=     16,						/* max command name remembered */
	NGROUPS_MAX=   _POSIX_NGROUPS_MAX,
};

#define	UQUAD_MAX	((u_quad_t)0-1)				/* max value for a uquad_t */
#define	QUAD_MAX	((quad_t)(UQUAD_MAX >> 1))	/* max value for a quad_t */
#define	QUAD_MIN	(-QUAD_MAX-1)				/* min value for a quad_t */

#endif
