/*
 * Copyright (c) 1983, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * 2004: modified by minoru murashma.
 */


#include <sys/cdefs.h>
#include <signal.h>


const char *const sys_signame[NSIG] = {
	"Signal 0",
	"abrt",				/* SIGABRT */
	"alrm",				/* SIGALRM */
	"bus",				/* SIGBUS */
	"chld",				/* SIGCHLD */
	"cont",				/* SIGCONT */
	"fpe",				/* SIGFPE */
	"hup",				/* SIGHUP */
	"ill",				/* SIGILL */
	"int",				/* SIGINT */
	"kill",				/* SIGKILL */
	"pipe",				/* SIGPIPE */
	"poll",				/* SIGPOLL */
	"prof",				/* SIGPROF */
	"quit",				/* SIGQUIT */
	"segv",				/* SIGSEGV */
	"stop",				/* SIGSTOP */
	"sys",				/* SIGSYS */
	"term",				/* SIGTERM */
	"trap",				/* SIGTRAP */
	"tstp",				/* SIGTSTP */
	"ttin",				/* SIGTTIN */
	"ttou",				/* SIGTTOU */
	"urg",				/* SIGURG */
	"usr1",				/* SIGUSR1 */
	"usr2",				/* SIGUSR2 */
	"vtalrm",			/* SIGVTALRM */
	"xcpu",				/* SIGXCPU */
	"xfsz",				/* SIGXFSZ */
};

const char *const sys_siglist[NSIG] = {
	"Signal 0",
	"Abort trap",				/* SIGABRT */
	"Alarm clock",				/* SIGALRM */
	"Bus error",				/* SIGBUS */
	"Child exited",				/* SIGCHLD */
	"Continued",				/* SIGCONT */
	"Floating point exception",	/* SIGFPE */
	"Hangup",					/* SIGHUP */
	"Illegal instruction",		/* SIGILL */
	"Interrupt",				/* SIGINT */
	"Killed",					/* SIGKILL */
	"Broken pipe",				/* SIGPIPE */
	"Polling",					/* SIGPOLL */
	"Profiling timer expired",	/* SIGPROF */
	"Quit",						/* SIGQUIT */
	"Segmentation fault",		/* SIGSEGV */
	"Suspended (signal)",		/* SIGSTOP */
	"Bad system call",			/* SIGSYS */
	"Terminated",				/* SIGTERM */
	"Trace/BPT trap",			/* SIGTRAP */
	"Suspended",				/* SIGTSTP */
	"Stopped (tty input)",		/* SIGTTIN */
	"Stopped (tty output)",		/* SIGTTOU */
	"Urgent I/O condition",		/* SIGURG */
	"User defined signal 1",	/* SIGUSR1 */
	"User defined signal 2",	/* SIGUSR2 */
	"Virtual timer expired",	/* SIGVTALRM */
	"Cputime limit exceeded",	/* SIGXCPU */
	"Filesize limit exceeded",	/* SIGXFSZ */
};
