/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * 2004: modified by minoru murashma.
 *
 */


#include <sys/stat.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "../utmp.h"
#include "../command.h"
#include "../tzfile.h"
#include "../err.h"


/* Derived from the print routines in the ls(1) source code. */


static void printtime(time_t ftime)
{
	int i;
	char *longstring, *ctime();
	time_t time();


	longstring = ctime(&ftime);
	for (i = 4; i < 11; ++i)
		putchar(longstring[i]);

#define	SIXMONTHS	((DAYSPERNYEAR / 2) * SECSPERDAY)
	if (ftime + SIXMONTHS > time((time_t *)NULL))
		for (i = 11; i < 16; ++i)
			putchar(longstring[i]);
	else
	{
		putchar(' ');
		for (i = 20; i < 24; ++i)
			putchar(longstring[i]);
	}
	putchar(' ');
}


static void printlink(char *name)
{
	int lnklen;
	char path[PATH_MAX + 1];


	if ((lnklen = readlink(name, path, PATH_MAX)) == -1)
	{
		warn("%s", name);
		return;
	}
	path[lnklen] = '\0';
	printf(" -> %s", path);
}


void printlong(char *name,char *accpath,struct stat *sb)
{
	char modep[15], *user_from_uid(), *group_from_gid();


	printf("%6lu %4qd ", sb->st_ino, sb->st_blocks);
	strmode(sb->st_mode, modep);
	printf("%s %3u %-*s %-*s ", modep, sb->st_nlink, UT_NAMESIZE,
	    user_from_uid(sb->st_uid, 0), UT_NAMESIZE,
	    group_from_gid(sb->st_gid, 0));

	if (S_ISCHR(sb->st_mode) || S_ISBLK(sb->st_mode))
		printf("%3d, %3d ", major(sb->st_rdev), minor(sb->st_rdev));
	else
		printf("%8qd ", sb->st_size);

	printtime(sb->st_mtime);
	printf("%s", name);
	if (S_ISLNK(sb->st_mode))
		printlink(accpath);
	putchar('\n');
}
