/*
 * time.h
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * time.cѥإåե
 */


#ifndef time_h
#define time_h


#define KERNEL 


#include<lib.h>
#include<sys/select.h>


#ifndef ASM_FILE


enum{
	PIT_HZ=1193181,		/* 8254󥿡Х륿ޡΥإĿ */

	/* 8254 interval timer IO register */
	PIT_CNR0=0x40,		/* counter0 register */
	PIT_CTR= 0x43,		/* control register */

	/* MC146818 CMOS RAM and real-time clock IO register */
	CMOS_ADR= 0x70,		/* address register */
	CMOS_DTR= 0x71,		/* data register */
	CMOS_SCD= 0x0,		/* second */
	CMOS_MNT= 0x2,		/* minute */
	CMOS_HOR= 0x4,		/* hour */
	CMOS_DAY= 0x7,		/* day */
	CMOS_MTH= 0x8,		/* month */
	CMOS_YER= 0x9,		/* year */
	CMOS_STRA=0xa,		/* status register A */
	CMOS_STRB=0xb,		/* status register B */
	CMOS_STRC=0xc,		/* status register C */

	NMI_ENABLE=0x80,	/* NMI interrupt enable,CMOS address register˽񤭹Ȥꤹ롣 */
};


typedef struct TIMER{
	struct TIMER *next;
	struct TIMER *prev;
	uint count;
	int flag;
}TIMER;


extern int clock_1micro;
extern int clock_1m;
extern int timer_num;


/*
 * CMOS read and write
 */
extern inline uchar read_cmos(int addr)
{
	outb(CMOS_ADR,addr|NMI_ENABLE);
	return inb(CMOS_DTR);
}

extern inline void write_cmos(int addr,uchar value)
{
	outb(CMOS_ADR,addr|NMI_ENABLE);
	outb(CMOS_DTR,value);
}

extern int count_cpu_clock();
extern int set_timer(uint);
extern void del_timer(TIMER*);
extern void setTimerStruct(void*);
extern void releaseTimer(TIMER*,TIMER*);
extern void init_time();
extern void calcUserTime();
extern void calcSysTime();
extern int sys_time();
extern int sys_sleep();
extern void sys_wake(void*);
extern int sys_alarm();
extern int sys_settime(uint);
extern int sys_gettimeofday();


#endif


#endif
