/*
 * udp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * User datagram Protocl.
 */


#include<types.h>
#include<lib.h>
#include<errno.h>
#include<mm.h>
#include<proc.h>
#include<time.h>
#include<lock.h>
#include<interrupt.h>
#include<signal.h>
#include<net/net.h>
#include<net/ip.h>
#include<net/ether.h>
#include<net/udp.h>


/*#define DEBUG_UDP 1
*/
#ifdef DEBUG_UDP
	#define STATIC
#else
	#define STATIC static
#endif

/**************************************************************************
 *
 * 
 *
 **************************************************************************/


STATIC int sendNotReach()
{
	return 0;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/* PUBLIC */
static SOCKET waitSocket;	/* ȥåȥ󥯡 */
static int waitLock;		/* ͥѥåȡ */


/*
 * PUBLIC
 * Add to wait link.
 * parameters : socket
 */
STATIC void addWaitLink(SOCKET *sc)
{
	enter_spinlock(&waitLock);
	{
		sc->next = waitSocket.next;
		sc->prev = &waitSocket;
		waitSocket.next->prev = sc;
		waitSocket.next = sc;
	}
	exit_spinlock(&waitLock);
}


/*
 * PUBLIC
 * Delete from wait link.
 * parameters : socket
 */
STATIC void delWaitLink(SOCKET *sc)
{
	enter_spinlock(&waitLock);
	{
		sc->next->prev = sc->prev;
		sc->prev->next = sc->next;
		sc->next = sc->prev = sc;
	}
	exit_spinlock(&waitLock);
}


/*
 * PUBLIC
 * Search from wait link.
 * parameters : socket
 * return : 1 =  0 = ʤ
 */
STATIC int searchWaitLink(SOCKET *sc)
{
	SOCKET *p;
	
	
	for (p = waitSocket.next; p != &waitSocket; p = p->next)
		if (p == sc)
			return 1;
	return 0;
}


/*
 * PRIVATE
 * Save receive data.
 * parameters : IP datagram
 * return : 0 or task switch=1
 */
STATIC int saveRecv(IP_HEADER *ip)
{
	SOCKET *sc;
	UDP_HEADER *udp;
	IP_BUFFER *ip_buf;


	/* READԤץθ */
	udp = (UDP_HEADER*)ip->data;
	enter_spinlock(&waitLock);
	{
		for (sc = waitSocket.next; ;sc = sc->next)
		{
			if (sc == &waitSocket)
			{
				exit_spinlock(&waitLock);
				return sendNotReach();
			}

			if (sc->srcport == udp->dstport)
			{
				if (sc->dstip != 0)
				{
					if ((sc->dstip == ip->srcip) && (sc->dstport == udp->srcport))
						break;
				}
				else
					break;
			}
		}
	}
	exit_spinlock(&waitLock);

	if (allocIpBuf(ip,&ip_buf) < 0)
		return 0;
	addRecvBuf(sc,ip_buf);
	if (sc->waitProc != NULL)
		sys_wake(sc->waitProc);

	return 1;
}


/*
 * PUBLIC
 * Get data from receive buffer.
 * parameters : buffer,buffer size,flags,SOCKET,source IP pointer
 * return : copy data size of error number
 */
STATIC int getRecvBuf(void *buf,size_t len,int flags,SOCKET *sc)
{
	enum{REPLY_TIMEOUT = 2000};	/* ॢȥߥá */

	int size;
	int rest;
	IP_HEADER *ip;
	IP_BUFFER *ip_buf;
	UDP_HEADER *udp;


	if (searchWaitLink(sc) == 0)
		addWaitLink(sc);
		
	for (;;)
	{
		/* SIGINTߤ */
		if(isSigint())
			return -EINTR;

		if (sc->recvBuf == NULL)
		{
			sc->waitProc = get_current_task();
			rest = sys_sleep(REPLY_TIMEOUT);
			delWaitLink(sc);
			if ((rest == 0) && (sc->recvBuf == NULL))		/* Time out. */
					return -ETIMEDOUT;
		}
		else
			break;
	}
	ip_buf = removeRecvBuf(sc);

	/* ǡХåե˥ԡ */
	ip = &ip_buf->ip;
	udp=(UDP_HEADER*)ip->data;
	size=swapWord(udp->len)-sizeof(UDP_HEADER);
	if(size>len)size=len;
	memcpy(buf,udp->data,size);
	sc->dstip=ip->srcip;
	sc->dstport=udp->srcport;
	kfree(ip_buf);

	return size;
}


/*
 * GROBAL
 * Receive UDP frame.
 * parameters : IP data
 * return : 0 or task switch=1
 */
int receiveUdp(IP_HEADER *ip)
{
	PSEUDO_HEADER pshead;
	UDP_HEADER *udp;


	udp=(UDP_HEADER*)ip->data;
/*********************************************************************************************
{
	union{
		uint ui;
		uchar uc[4];
	}src_ip;

	src_ip.ui = ip->srcip;
	printk("RECV UDP srcport=%x,dstport=%x,length=%d,ip=%u.%u.%u.%u\n",
		swapWord(udp->srcport),swapWord(udp->dstport),swapWord(udp->len),
		src_ip.uc[0],src_ip.uc[1],src_ip.uc[2],src_ip.uc[3]);
}
**********************************************************************************************/
	/* åγǧ */
	pshead.srcip=ip->srcip;
	pshead.dstip=ip->dstip;
	pshead.tmp=0;
	pshead.prot=ip->prot;
	pshead.len=udp->len;
	if (calcSumM((uint*)&pshead,(uint*)udp,sizeof(PSEUDO_HEADER),swapWord(udp->len)))
		return 0;

	return saveRecv(ip);
}


/**************************************************************************
 *
 * Socket interface.
 *
 **************************************************************************/


STATIC int send(SOCKET *sc,const void *msg,size_t len,int flags,struct sockaddr *to)
{
	char head[sizeof(PSEUDO_HEADER)+sizeof(UDP_HEADER)];
	PSEUDO_HEADER *pshead;
	UDP_HEADER *udp;
	TRANS_BUF_INFO tbi;


	/* Set pseudo header. */
	pshead=(PSEUDO_HEADER*)head;
	if (to == NULL)
		pshead->dstip = sc->dstip;
	else
		pshead->dstip = ((struct sockaddr_in*)to)->sin_addr.s_addr;
	pshead->srcip=getSrcip(pshead->dstip);
	pshead->tmp=0;
	pshead->prot=IPPROTO_UDP;
	pshead->len=swapWord(len+sizeof(UDP_HEADER));

	/* Set UDP head. */
	udp=(UDP_HEADER*)(head+sizeof(PSEUDO_HEADER));
	udp->srcport=sc->srcport;
	if (to == NULL)
		udp->dstport = sc->dstport;
	else
		udp->dstport = ((struct sockaddr_in*)to)->sin_port;
	udp->len=swapWord(len+sizeof(UDP_HEADER));
	udp->chksum=0;
	udp->chksum=calcSumM((uint*)head,(uint*)msg,sizeof(PSEUDO_HEADER)+sizeof(UDP_HEADER),len);

	/* Хåեơ֥ */
	tbi.data[2]=(char*)msg;
	tbi.size[2]=len;
	tbi.data[1]=(char*)udp;
	tbi.size[1]=sizeof(UDP_HEADER);
	tbi.ipType=IPPROTO_UDP;
/********************************************************************************************
{
	union{
		uint ui;
		uchar uc[4];
	}dst_ip;

	dst_ip.ui = sc->dstip;
	printk("TRANS UDP srcport=%x,dstport=%x,length=%d,ip=%u.%u.%u.%u\n",
		swapWord(udp->srcport),swapWord(udp->dstport),swapWord(udp->len),
		dst_ip.uc[0],dst_ip.uc[1],dst_ip.uc[2],dst_ip.uc[3]);
}
*********************************************************************************************/
	transIp(&tbi,pshead->dstip,flags,0);

	return len;
}


/*
 * return : copy data size or error number
 */
STATIC int recv(SOCKET *sc,void *buf,size_t len,int flags)
{
	return getRecvBuf(buf,len,flags,sc);
}


STATIC int connect(SOCKET *sc)
{
	addWaitLink(sc);
	
	return 0;
}


STATIC int shutdown(SOCKET *sc,int flag)
{
	return -EOPNOTSUPP;
}


STATIC int listen(SOCKET *sc,int fd)
{
	return -EOPNOTSUPP;
}


STATIC int accept(SOCKET *sc,SOCKET **newsc,uint32_t *srcip)
{
	return -EOPNOTSUPP;
}


STATIC int select(SOCKET *sc,int flag,int polling)
{
	if(flag!=FD_READ)
		return 1;
	if (sc->recvBuf != NULL)
		return 1;
	if (polling)
		return 0;

	sc->waitProc = get_current_task();

	return 0;
}


void releaseSockUdp(SOCKET *sc)
{
	delWaitLink(sc);
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


STATIC SOCKET_INFO sockInfo={send,recv,connect,shutdown,listen,accept,select};


/*
 * GLOBAL
 * Init UDP.
 */
int initUdp()
{
	registSocket(&sockInfo,IPPROTO_UDP);
	waitSocket.next = waitSocket.prev = &waitSocket;

	return 0;
}
