/*
 * icmp.c
 *
 * Copyright 2004, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * Internet controlMessage Protocl.
 */


#include<types.h>
#include<lib.h>
#include<errno.h>
#include<mm.h>
#include<proc.h>
#include<time.h>
#include<lock.h>
#include<signal.h>
#include<net/net.h>
#include<net/ip.h>
#include<net/icmp.h>
#include<test.h>


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/*
 * PUBLIC
 * Transmit ICMP frame.
 * parameters : destination IP,type,code,ICMP head address,ICMP data size
 */
static void transIcmp(uint dstip,uchar type,uchar code,ICMP_HEADER *head,int size)
{
	TRANS_BUF_INFO tbi;


	/* إåꡣ */
	head->type=type;
	head->code=code;
	head->chksum=0;
	head->chksum=calcSum((uint*)head,size);

	/* Хåեơ֥ */
	tbi.data[2]=NULL;
	tbi.size[2]=0;
	tbi.data[1]=(char*)head;
	tbi.size[1]=size;
	tbi.ipType=IPPROTO_ICMP;
/****************************************************************************
printk("TRANS ICMP type=%d,code=%d\n",head->type,head->code);
****************************************************************************/
	transIp(&tbi,dstip,0,0);
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


/* PUBLIC */
static SOCKET waitSocket;	/* ȥåȥ󥯡 */
static int waitLock;		/* ͥѥåȡ */


/*
 * PRIVATE
 * Add to wait link.
 * parameters : socket
 */
static inline void addWaitLink(SOCKET *sc)
{
	enter_spinlock(&waitLock);
	{
		sc->next=waitSocket.next;
		sc->prev=&waitSocket;
		waitSocket.next->prev=sc;
		waitSocket.next=sc;
	}
	exit_spinlock(&waitLock);
}


/*
 * PRIVATE
 * Delete from wait link.
 * parameters : socket
 */
static inline void delWaitLink(SOCKET *sc)
{
	enter_spinlock(&waitLock);
	{
		sc->next->prev=sc->prev;
		sc->prev->next=sc->next;
		sc->next=sc->prev=sc;
	}
	exit_spinlock(&waitLock);
}


/*
 * PRIVATE
 * Save receive data.
 * parameters : IP data,data size
 * return : 0 or task switch=1
 */
static int saveRecv(IP_HEADER *ip)
{
	SOCKET *sc;
	IP_BUFFER *ip_buf;


	/* READԤץθ */
	enter_spinlock(&waitLock);
	{
		if((sc=waitSocket.next)==&waitSocket)
		{
			exit_spinlock(&waitLock);
			return 0;
		}
	}
	exit_spinlock(&waitLock);

	if (allocIpBuf(ip,&ip_buf) < 0)
		return 0;
	addRecvBuf(sc,ip_buf);

	del_timer(&((PROC*)sc->waitProc)->timer);
	forceSendSignal((PROC*)sc->waitProc,SIGCONT);

	return 1;
}


/*
 * PUBLIC
 * Get reply from receive buffer.
 * parameters : buffer,buffer size,flags,SOCKET,source IP pointer
 * return : copy data size of error number
 */
static int getRecvBuf(void *buf,size_t len,int flags,SOCKET *sc)
{
	enum{REPLY_TIMEOUT=2000};	/* ॢȥߥá */

	int size;
	int rest;
	IP_BUFFER *ip_buf;
	IP_HEADER *ip;


	/* 쥷֥Хåե򸡺 */
	if(sc->recvBuf == NULL)
	{
		/* ǡ쥷Ԥ */
		sc->waitProc=get_current_task();
		addWaitLink(sc);
		rest=sys_sleep(REPLY_TIMEOUT);

		/*  */
		delWaitLink(sc);
		if(sc->recvBuf == NULL)
		{
			if(rest==0)		/* Time out. */
				return -ETIMEDOUT;
			else
				return -EINTR;
		}
	}
	ip_buf = removeRecvBuf(sc);

	/* ǡХåե˥ԡ */
	ip = &ip_buf->ip;
	size = swapWord(ip->len);
	if (size > len)
		size = len;
	memcpy(buf,ip,size);
	sc->dstip = ip->srcip;
	kfree(ip_buf);

	return size;
}


/*
 * GROBAL
 * Receive ICMP frame.
 * parameters : IP data
 * return : 0 or task switch=1
 */
int receiveIcmp(IP_HEADER *head)
{
	int icmp_size;
	ICMP_HEADER *icmp;


	icmp=(ICMP_HEADER*)head->data;
/**************************************************************************
printk("RECV ICMP type=%x,code=%x\n",icmp->type,icmp->code);
**************************************************************************/
	icmp_size=swapWord(head->len)-sizeof(IP_HEADER);

	/* åγǧ */
	if(calcSum((uint*)icmp,icmp_size))return 0;

	switch(icmp->type)
	{
		case ICMP_TYPE_ECHOREQ:
			transIcmp(head->srcip,ICMP_TYPE_ECHOREP,0,icmp,icmp_size);
			break;
		case ICMP_TYPE_ECHOREP:
			return saveRecv(head);
	}

	return 0;
}


/**************************************************************************
 *
 * Socket interface.
 *
 **************************************************************************/


static int send(SOCKET *sc,const void *msg,size_t len,int flags,struct sockaddr *to)
{
	TRANS_BUF_INFO tbi;


	/* Хåեơ֥ */
	tbi.data[2]=NULL;
	tbi.size[2]=0;
	tbi.data[1]=(char*)msg;
	tbi.size[1]=len;
	tbi.ipType=IPPROTO_ICMP;
/****************************************************************************
{
	ICMP_HEADER *head=(ICMP_HEADER*)msg;
	printk("TRANS ICMP type=%d,code=%d\n",head->type,head->code);
}
****************************************************************************/
	transIp(&tbi,((struct sockaddr_in*)to)->sin_addr.s_addr,flags,0);

	return len;
}


/*
 * return : copy data size or error number
 */
static int recv(SOCKET *sc,void *buf,size_t len,int flags)
{
	return getRecvBuf(buf,len,flags,sc);
}


static int connect(SOCKET *a)
{
	return -EOPNOTSUPP;
}

static int shutdown(SOCKET *sc,int flag)
{
	return -EOPNOTSUPP;
}

static int listen(SOCKET *a,int fd)
{
	return -EOPNOTSUPP;
}

static int accept(SOCKET *sc,SOCKET **newsc,uint32_t *srcip)
{
	return -EOPNOTSUPP;
}

static int select(SOCKET *sc,int flag,int polling)
{
	if(flag!=FD_READ)return 1;

	return -ENOTCONN;
}


/**************************************************************************
 *
 * 
 *
 **************************************************************************/


static SOCKET_INFO sockInfo={send,recv,connect,shutdown,listen,accept,select};


/*
 * GLOBAL
 * Init ICMP.
 */
int initIcmp()
{
	registSocket(&sockInfo,IPPROTO_ICMP);

	return 0;
}
