/*
 * mm.c
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ꡼ץ
 *
 * ǡΡ
 * 	ǡ̾phis_link
 * 	ؿlinkPhysTable()
 * 	unlinkPhysTable()
 * 	allocKernelPage()
 * 	allocUserPage()
 *		phis_linkξ֤ǥڡ꡼¾ץ鲣ꤵΤǡڡơ֥륨ȥ꡼ѹ
 * 		phis_linkäPHYS_MEM_TABLǤpage_tbl_addƱɬפ롣
 *
 * 
 *  ڡβǶ礬ʤ褦ˤ롣
 */


#include"types.h"
#include"config.h"
#include"lib.h"
#include"lock.h"
#include"interrupt.h"
#include"proc.h"
#include"mp.h"
#include"segment.h"
#include"errno.h"
#include"fs.h"
#include"device.h"
#include"signal.h"
#include"mm.h"
#include"debug.h"
#include"test.h"


static int backupPage(uint,PROC*,uint*);


/***********************************************************************************
 *
 * ʪ꡼饹
 *
 ***********************************************************************************/

/*
 * ʪ꡼ơ֥빽¤
 * Page
 */
typedef struct PHYS_MEM_TABL{
	short ref_count;			/* reference count */
	ushort heap_num;			/* Heap number */
	PROC *proc;					/* ƤƤץ */
	uint *pentry;				/* ƤƤڡȥ꡼ɥ쥹 */
	struct PHYS_MEM_TABL *next;
	struct PHYS_MEM_TABL *prev;
}PHYS_MEM_TABL;


/*
 * PRIVATE
 * ꡼ơ֥
 */
static PHYS_MEM_TABL *freeKrnTop;		/* ͥʪ꡼󥯥ȥå */
static PHYS_MEM_TABL *freeUsrTop;		/* 桼ʪ꡼󥯥 */
static PHYS_MEM_TABL usedKrnTop;		/* ʲġ˥ͥʪ꡼󥯥ȥå */
static PHYS_MEM_TABL usedKrnEnd;		/* ʲġ˥ͥʪ꡼󥯥 */
static PHYS_MEM_TABL usedUsrTop;		/* ʲġ˥桼ʪ꡼󥯥ȥå */
static PHYS_MEM_TABL usedUsrEnd;		/* ʲġ˥桼ʪ꡼󥯥 */
static int physMemGate=0;				/* PHYS_MEM_TABL lock gate */


/*
 * PRIVATE
 * ꡼setup.S
 */
static uint all_memory_size;


/*
 * PRIVATE
 * ꡼ơ֥ե꡼󥯤Ф
 * parameters : ե꡼ȥåץɥ쥹ݥ
 * return : ꡼ơ֥륢ɥ쥹
 */
static inline PHYS_MEM_TABL *getFreeMem(PHYS_MEM_TABL **ftop)
{
	PHYS_MEM_TABL *mtbl=*ftop;


	*ftop=mtbl->next;
	mtbl->ref_count=1;
	mtbl->next=mtbl;

	return mtbl;
}


/*
 * PRIVATE
 * ꡼ơ֥ե꡼󥯤˲ä롣
 * parameters : ɲå꡼ơ֥,ե꡼󥯥ȥå
 */
static inline void addFreeMem(PHYS_MEM_TABL *mtbl,PHYS_MEM_TABL **ftop)
{
	mtbl->ref_count=0;
	mtbl->proc=NULL;
	mtbl->pentry=NULL;
	mtbl->next=*ftop;
	mtbl->prev=mtbl;
	*ftop=mtbl;
}


/*
 * PRIVATE
 * 󥯤Ф
 * parameters : 󥯥
 * return : ꡼ơ֥륢ɥ쥹
 */
static inline PHYS_MEM_TABL *getUsedMem(PHYS_MEM_TABL *uend)
{
	PHYS_MEM_TABL *mtbl=uend->prev;


	mtbl->prev->next=uend;
	uend->prev=mtbl->prev;
	mtbl->next=mtbl->prev=mtbl;

	return mtbl;
}


/*
 * PRIVATE
 * 󥯤˲ä롣
 * parameters : ɲå꡼ơ֥,󥯥ȥå,ץơ֥,ƥڡȥ꡼
 */
static inline void addUsedMem(PHYS_MEM_TABL *mtbl,PHYS_MEM_TABL *utop,PROC *proc,uint *pentry)
{
	mtbl->proc=proc;
	mtbl->pentry=pentry;

	mtbl->next=utop->next;
	mtbl->prev=utop;
	utop->next=mtbl;
	mtbl->next->prev=mtbl;
}


/*
 * PRIVATE
 * allocMultiKernelPage()ѡ
 * ե꡼ͥ꡼󥯤ƳƤ롣
 * parameters : ʪ꡼ơ֥륢ɥ쥹
 */
static inline void delFreeKrnLink(PHYS_MEM_TABL *mtbl)
{
	PHYS_MEM_TABL *p;


	if(mtbl==freeKrnTop)freeKrnTop=mtbl->next;
	else
	{
		for(p=freeKrnTop;p->next!=mtbl;p=p->next);
		p->next=mtbl->next;
	}

	mtbl->ref_count=1;
	mtbl->next=mtbl;
}


/*
 * PUBLIC
 * ʪ꡼ɥ쥹 PHYS_MEM_TABL ɥ쥹֤
 * parameters : Physical address
 * return : PHYS_MEM_TABL address
 */
static inline PHYS_MEM_TABL *getPhysTableFromAddr(void *addr)
{
	return (PHYS_MEM_TABL*)((uint)addr/PAGE_SIZE*sizeof(PHYS_MEM_TABL)+PHYSICAL_PAGE_TABLE_ADD);
}


/*
 * PUBLIC
 * PHYS_MEM_TABL addressʪ꡼ɥ쥹֤
 * parameters : PHYS_MEM_TABL address
 * return : Physical address
 */
static inline void *getAddrFromPhysTable(PHYS_MEM_TABL *memtable)
{
	return (void*)(((uint)memtable-PHYSICAL_PAGE_TABLE_ADD)/sizeof(PHYS_MEM_TABL)*PAGE_SIZE);
}


/*
 * PUBLIC
 * ʪ꡼ڡλȥȤ䤹
 * parameters : ʪɥ쥹
 */
static void linkPhysTable(uint addr)
{
	PHYS_MEM_TABL *mtbl;


	mtbl=getPhysTableFromAddr((void*)addr);

	enter_spinlock(&physMemGate);
	{
		++mtbl->ref_count;

		/* Used link */
		mtbl->prev->next=mtbl->next;
		mtbl->next->prev=mtbl->prev;
		mtbl->next=mtbl->prev=mtbl;

		mtbl->pentry=NULL;
		mtbl->proc=NULL;
	}
	exit_spinlock(&physMemGate);
}


/*
 * PUBLIC
 * ȥȤ򸺤餷ʪ꡼ڡ롣
 * parameters : ʪɥ쥹
 */
static void unlinkPhysTable(uint addr)
{
	PHYS_MEM_TABL *mtbl;


	mtbl=getPhysTableFromAddr((void*)addr);

#ifdef DEBUG
	if(mtbl->ref_count<=0)
		printk("address=0x%x : Warning! A No reference PhysTable is unlinked.\n",addr);
#endif

	enter_spinlock(&physMemGate);
	{
		if((--mtbl->ref_count<=0)&&(mtbl->next!=mtbl))
		{
			/* Used link */
			mtbl->prev->next=mtbl->next;
			mtbl->next->prev=mtbl->prev;

			if(addr<KERNEL_DATA_END)addFreeMem(mtbl,&freeKrnTop);
			else addFreeMem(mtbl,&freeUsrTop);
		}
	}
	exit_spinlock(&physMemGate);
}


/*
 * PUBLIC
 * ȥ󥿤1餹1ξ-1֤
 * parameters : ʪɥ쥹
 * return : 0 or -1
 */
static int delPhysRefCount(uint addr)
{
	int rest;
	PHYS_MEM_TABL *mtbl;


	mtbl=getPhysTableFromAddr((void*)addr);
	enter_spinlock(&physMemGate);
	{
		if(mtbl->ref_count>1)
		{
			--mtbl->ref_count;
			rest=0;
		}
		else rest=-1;
	}
	exit_spinlock(&physMemGate);

	return rest;
}


/*
 * PUBLIC
 * ֤ͥʪڡƤ롣
 * ƤڡϲԲ
 * return : Allocate addres or NULL
 */
static void *allocKernelPage()
{
	PHYS_MEM_TABL *mtbl;


	enter_spinlock(&physMemGate);

	if(freeKrnTop!=NULL)
	{
		mtbl=getFreeMem(&freeKrnTop);

		exit_spinlock(&physMemGate);
	}
	else if(usedKrnTop.next!=&usedKrnEnd)
	{
		mtbl=getUsedMem(&usedKrnEnd);

		exit_spinlock(&physMemGate);

		/* ꡼ƤХååפ롣 */
		if(backupPage((uint)getAddrFromPhysTable(mtbl),mtbl->proc,mtbl->pentry)==-1)return NULL;
	}
	else
	{
		exit_spinlock(&physMemGate);
		return NULL;
	}

	return getAddrFromPhysTable(mtbl);
}


/*
 * PUBLIC
 * 桼֤ʪڡƤ롣
 * Ƥڡϲ
 * parameters : Ƥڡȥ꡼ɥ쥹
 * return : Allocate addres or error=NULL
 */
static void *allocUserPage(uint *pentry)
{
	uint *old_pentry;
	PROC *old_proc;
	PHYS_MEM_TABL *mtbl;


	enter_spinlock(&physMemGate);

	if(freeUsrTop!=NULL)
	{
		mtbl=getFreeMem(&freeUsrTop);
		addUsedMem(mtbl,&usedUsrTop,get_current_task(),pentry);

		exit_spinlock(&physMemGate);
	}
	else if(freeKrnTop!=NULL)
	{
		mtbl=getFreeMem(&freeKrnTop);
		addUsedMem(mtbl,&usedKrnTop,get_current_task(),pentry);

		exit_spinlock(&physMemGate);
	}
	else if(usedUsrTop.next!=&usedUsrEnd)
	{
		mtbl=getUsedMem(&usedUsrEnd);
		old_proc=mtbl->proc;
		old_pentry=mtbl->pentry;
		addUsedMem(mtbl,&usedUsrTop,get_current_task(),pentry);

		exit_spinlock(&physMemGate);

		if(backupPage((uint)getAddrFromPhysTable(mtbl),old_proc,old_pentry)==-1)return NULL;
	}
	else if(usedKrnTop.next!=&usedKrnEnd)
	{
		mtbl=getUsedMem(&usedKrnEnd);
		old_proc=mtbl->proc;
		old_pentry=mtbl->pentry;
		addUsedMem(mtbl,&usedKrnTop,get_current_task(),pentry);

		exit_spinlock(&physMemGate);

		if(backupPage((uint)getAddrFromPhysTable(mtbl),old_proc,old_pentry)==-1)return NULL;
	}
	else
	{
		exit_spinlock(&physMemGate);
		return NULL;
	}

	return getAddrFromPhysTable(mtbl);
}


/*
 * PUBLIC
 * Ϣ³ʣͥڡƤ롣
 * parameters : ڡ
 * return : ƥɥ쥹 or failed=NULL
 */
static void *allocMultiKernelPage(int num)
{
	void *rest;
	int cnt;
	uint maxmem;
	PHYS_MEM_TABL *p;


	maxmem=(all_memory_size<KERNEL_DATA_END)?all_memory_size:KERNEL_DATA_END;
	p=(PHYS_MEM_TABL*)(PHYSICAL_PAGE_TABLE_ADD+maxmem/PAGE_SIZE*sizeof(PHYS_MEM_TABL))-1;
	rest=NULL;
	cnt=0;
	enter_spinlock(&physMemGate);
	{
		for(;p>=(PHYS_MEM_TABL*)PHYSICAL_PAGE_TABLE_ADD;--p)
		{
			if(p->ref_count==0)
			{
				if(++cnt==num)
				{
					while(--cnt>=0)delFreeKrnLink(p+cnt);
					rest=getAddrFromPhysTable(p);
					break;
				}
			}
			else cnt=0;
		}
	}
	exit_spinlock(&physMemGate);

	return rest;
}


/*
 * PUBLIC
 * ʪ꡼ơ֥롣
 */
static void initPhysMemTable()
{
	int i,last;
	PHYS_MEM_TABL *p=(PHYS_MEM_TABL*)PHYSICAL_PAGE_TABLE_ADD;


	/* ǽ1Mbyteʬ꡼Ƥ롣 */
	for(i=0;i<0x100000/PAGE_SIZE;++i)p[i].ref_count=1;

	/* Ĥե꡼ꤹ롣 */
	i=0x100000/PAGE_SIZE;
	freeKrnTop=&p[i];
	for(last=all_memory_size/PAGE_SIZE;i<last;++i)
	{
		p[i].ref_count=0;
		p[i].heap_num=0;
		p[i].proc=NULL;
		p[i].pentry=NULL;
		p[i].next=&p[i+1];
		p[i].prev=&p[i];
	}
	p[--i].next=NULL;


	/* 桼ΰե꡼ꡣ */
	if(getAddrFromPhysTable(&p[i])>=(void*)USER_BEG)
	{
		freeUsrTop=getPhysTableFromAddr((void*)USER_BEG);
		(freeUsrTop-1)->next=NULL;
	}
	else freeUsrTop=NULL;

	/* ꡼ơ֥ʬ꡼ƤʲԲġˡ */
	last=ROUNDUP(PHYSICAL_PAGE_TABLE_ADD+all_memory_size/PAGE_SIZE*sizeof(PHYS_MEM_TABL),PAGE_SIZE)/PAGE_SIZE;
	for(i=PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE;i<last;++i)
		p[i].ref_count=1;
	if(&p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE]==freeKrnTop)
		freeKrnTop=&p[last];
	else p[PHYSICAL_PAGE_TABLE_ADD/PAGE_SIZE-1].next=&p[last];

	/* Used link롣 */
	usedKrnTop.next=&usedKrnEnd;
	usedKrnEnd.prev=&usedKrnTop;
	usedUsrTop.next=&usedUsrEnd;
	usedUsrEnd.prev=&usedUsrTop;
}


/*
 * PUBLIC
 * Find size of all physical memory
 */
static uint findAllMemsize()
{
	enum{EXIST_MEM_SIZE=0x800000};		/* ꡼¬ñ */

	uint volatile *point;


	/* ꡼ñ̤Ȥ¬ꤹ*/
	for(point=(uint*)EXIST_MEM_SIZE-1;;point+=EXIST_MEM_SIZE/sizeof(uint))
	{
		*point=0x5a5a5a5a;
		if(*point!=0x5a5a5a5a)break;
		else
		{
			*point=0xf0f0f0f0;
			if(*point!=0xf0f0f0f0)break;
		}
	}

	return (all_memory_size=(uint)point-EXIST_MEM_SIZE+sizeof(uint));
}


/***********************************************************************************
 *
 * ꡼ȥ饹
 *
 ***********************************************************************************/

#define HEAP_NUM() (sizeof(heapHead)/sizeof(HEAP_HEAD))

/* ʬ꡼إå */
typedef struct MEM_HEAD{
	struct MEM_HEAD *next;	/* ζ꡼Ƭ */
	int size;				/* ƥ */
}MEM_HEAD;

/*
 * ҡץإå
 * Note! : "memTop"ΰ֤ɬ"MEM_HEAD""next"Ʊˤ뤳
 */
typedef struct{
	MEM_HEAD *memTop;		/* ꡼Ƭ */
	uint size;				/* ƥ */
	int gate;				/* ԥåѥ */
}HEAP_HEAD;


/*
 * PRIVATE
 * ҡץإå
 */
static HEAP_HEAD heapHead[]={
	{NULL,0,     0},
	{NULL,0x10,  0},
	{NULL,0x20,  0},
	{NULL,0x40,  0},
	{NULL,0x80,  0},
	{NULL,0x100, 0},
	{NULL,0x200, 0},
	{NULL,0x400, 0},
	{NULL,0x800, 0},
	{NULL,0x1000,0},
};

/*
 * PRIVATE
 * Хͤҡ׹¤ΥʥС
 */
static uchar heapNum1[]={
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
	2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
};
static uchar heapNum2[]={
	0,5,6,7,7,8,8,8,8,9,9,9,9,9,9,9,
	9,
};


/*
 * PRIVATE
 * ҡץ롣
 * parameters : ׵᥵
 * return : ҡ׹¤ΥʥС
 */
static inline int getHeapSize(size_t size)
{
	if(size>=0x100)
		return heapNum2[ROUNDUP(size,0x100)>>8];
	return heapNum1[size];
}


/*
 * GLOBAL
 * 2Ѿ襵Ȥ˥ڡ꡼ʬ䤹
 * parameters : Size by byte
 * return : allocate address or NULL
 */
void *kmalloc(size_t size)
{
	union{
		MEM_HEAD *head;
		uint ui;
	}mem,alloc;
	int i;


	if (size == 0)
		return NULL;

	if (size <= PAGE_SIZE)
	{
		i = getHeapSize(size);

		enter_spinlock(&heapHead[i].gate);
		{
			if (heapHead[i].memTop == NULL)
			{
				/* 1ڡ꡼ݡ */
				mem.head = allocKernelPage();
				if (mem.head == NULL)
				{
					exit_spinlock(&heapHead[i].gate);
					return NULL;
				}

				/*
				 * Ȥaddress狼褦ˤ롣
				 */
				getPhysTableFromAddr(mem.head)->heap_num = i;

				mem.head->next = NULL;
				mem.head->size = PAGE_SIZE;
				heapHead[i].memTop = mem.head;
			}

			mem.head = heapHead[i].memTop;
			mem.head->size -= heapHead[i].size;
			if (mem.head->size == 0)
				heapHead[i].memTop = mem.head->next;
		}
		exit_spinlock(&heapHead[i].gate);

		alloc.ui = mem.ui + mem.head->size;
	}
	else
	{
		size = ROUNDUP(size,PAGE_SIZE);
		if ((alloc.head = allocMultiKernelPage(size / PAGE_SIZE)) == NULL)
			return NULL;
		getPhysTableFromAddr(alloc.head)->heap_num = HEAP_NUM() + size / PAGE_SIZE;
	}

	return alloc.head;
}


/*
 * GLOBAL
 * ꡼
 * parameters : Address
 */
void kfree(void *ptr)
{
	union{
		MEM_HEAD *head;
		uint ui;
	}mem,free,prev,next;
	uint i,m;


	if (ptr == NULL)
		return;

	if ((i = getPhysTableFromAddr(ptr)->heap_num) == 0)
	{
#ifdef DEBUG
		printk("kfree() : 0x%x did not allocated\n",ptr);
#endif
		return;
	}

	if (i < HEAP_NUM())
	{
		free.head = ptr;
#ifdef DEBUG
		/* Υå */
		mem.head = free.head;
		mem.ui &= heapHead[i].size - 1;
		if (mem.ui != 0)
		{
			printk("kfree() : 0x%x is no complete\n",free.head);
			return;
		}	
#endif
		enter_spinlock(&heapHead[i].gate);
		{
			/* ꡼³󥯰֤򸡺 */
			mem.head = (MEM_HEAD*)&heapHead[i];
			for (;mem.head->next != NULL; mem.head = mem.head->next)
				if (free.head < mem.head->next)
					break;
			prev = mem;
#ifdef DEBUG
			if ((mem.head != (MEM_HEAD*)&heapHead[i]) && (free.ui < (mem.ui + mem.head->size)) )
			{
				printk("kfree() : 0x%x is already free\n",free.head);
				goto EXIT;
			}
#endif
			/* Υ꡼ȷҤ */
			next.head = prev.head->next;
			if ((next.ui == (free.ui + heapHead[i].size)) && ((next.ui / PAGE_SIZE) == (free.ui / PAGE_SIZE)) )
			{
				free.head->next = next.head->next;
				free.head->size = next.head->size + heapHead[i].size;
			}
			else
			{
				free.head->next = next.head;
				free.head->size = heapHead[i].size;
			}

			/* Ĥʤ꡼ڡˤʤäڡ */
			if (free.head->size == PAGE_SIZE)
			{
				prev.head->next = free.head->next;
				getPhysTableFromAddr(free.head)->heap_num = 0;
				unlinkPhysTable(free.ui);
				goto EXIT;
			}

			/* Υ꡼ȷҤ */
			if (((prev.ui + prev.head->size) == free.ui) && ((prev.ui / PAGE_SIZE) == (free.ui / PAGE_SIZE)) )
			{
				prev.head->next = free.head->next;
				prev.head->size += free.head->size;
				
			}
			else
				prev.head->next = free.head;

			/* Ĥʤ꡼ڡˤʤäڡ */
			if (prev.head->size == PAGE_SIZE)
			{
				for (mem.head = (MEM_HEAD*)&heapHead[i]; mem.head->next != prev.head; mem.head = mem.head->next);
				mem.head->next = free.head->next;
				getPhysTableFromAddr(prev.head)->heap_num = 0;
				unlinkPhysTable(prev.ui);
				goto EXIT;
			}
		}
EXIT:	exit_spinlock(&heapHead[i].gate);
	}
	else
	{
		getPhysTableFromAddr(ptr)->heap_num = 0;
		m = (uint)ptr;
		for (i -= HEAP_NUM(); i > 0; --i)
		{
			unlinkPhysTable(m);
			m += PAGE_SIZE;
		}
	}
}


/***********************************************************************************
 *
 * ڡ̥饹
 *
 * ̵§
 *  ȤƤʤڡȥ꡼ɬꥢ롣
 *
 * public
 *  getPageDirEntryAddr()
 *  getPageEntryAddr()
 *  flashPageDir()
 *  getLastLinearAddr()
 *
 ***********************************************************************************/

enum{
	PAGE_DIR_SIZE=0x400000,		/* Page directory size */

	/* Page entry flag */
	PAGE_PRESEN=		0x1,	/* Is presence */
	PAGE_RW=			0x2,	/* Is read and write,not read only */
	PAGE_USER=			0x4,	/* Privilege is user,not supervisor */
	PAGE_CASH_DISABLE=	0x10,	/* Disable cash,not able cash */
	PAGE_4M=			0x80,	/* Page size is 4M,not 4K */

	/* ڡȥ꡼ΰѥե饰 */
	PT_COPY_ON_WRITE=0x200,		/* ԡ饤ȥե饰 */
};


/*
 * PUBLIC
 * ɥ쥹ڡǥ쥯ȥꥨȥ꡼ɥ쥹롣
 * parameters : ɥ쥹,ڡǥ쥯ȥꥢɥ쥹
 * return : ڡǥ쥯ȥꥨȥ꡼ɥ쥹
 */
static inline uint *getPageDirEntryAddr(uint addr,uint *page_dir)
{
	return &page_dir[addr>>22];
}


/*
 * PUBLIC
 * ɥ쥹ڡơ֥륨ȥ꡼ɥ쥹롣
 * parameters : ɥ쥹,ڡơ֥륢ɥ쥹
 * return : ڡơ֥륨ȥ꡼ɥ쥹
 */
static inline uint *getPageEntryAddr(uint addr,uint *ptbl)
{
	return &ptbl[(addr>>12)&0x3ff];
}


/*
 * PUBLIC
 * ɥ쥹ڡơ֥륨ȥ꡼ɥ쥹롣
 * parameters : ɥ쥹,ڡǥ쥯ȥꥢɥ쥹
 * return : ڡơ֥륨ȥ꡼ɥ쥹
 */
/*static uint *getPageEntryAddrFromLinearAddr(uint addr,uint *page_dir)
{
	uint *ptbl;


	ptbl=(uint*)(*getPageDirEntryAddr(addr,page_dir)&~(PAGE_SIZE-1));
	return getPageEntryAddr(addr,ptbl);
}
*/

/*
 * PUBLIC
 * flash page directory
 * parameters : page directory address
 */
static inline void flashPageDir(uint *pdir)
{
	asm volatile(
		"movl	%%eax,%%cr3"
		::"a"(pdir)
	);
}


/*
 * GLOBAL
 * 饹ȳƥ˥ɥ쥹롣
 * return : last allocate addrress
 */
uint getLastLinearAddr()
{
	return ((MM_STRUCT*)get_current_task()->mm_struct)->lastPageAddr;
}


/***********************************************************************************
 *
 * ڡХååץ饹
 *
 * ڡȥ꡼ΥХåå׻Υ쥤ȡ
 *  0bit=0,123bit=¸֥åֹ,2431bit=֥åȥ
 *
 ***********************************************************************************/

enum{
	PT_TYPE_PAGING=0x9a,	/* ڡХååץǥХѡƥֹʲˡ */
	PB_START_SECTER=2,		/* Хåå׳ϥ */
	BIT_NUM=8,				/* Хȥӥåȿ */
};


/* PRIVATE,ӥåȥޥåפǥХ֥ͤåΰ֤롣 */
static uchar emptyBlock[]={
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,
	0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,0,
};
static uchar *pbBitMap;			/* PRIVATE,֥åӥåȥޥåס */
static int pbBitMapCurrent;		/* PRIVATE,ӥåȥޥåθߤΥХȰ֡ */
static int pbBitMapSize;		/* PRIVATE,ӥåȥޥåץ */
static int pbDin;				/* PRIVATE,ХååץǥХ inode */
static int pbSectors;			/* PRIVATE,ڡ/ */


/*
 * PRIVATE
 * ڡХååפ롣
 * return : ֥å or failed=-1
 */
static int getEmptyBackup()
{
	int bit;
	int i;


	i=pbBitMapCurrent;

	do
	{
		if(pbBitMap[i]!=0xff)
		{
			bit=emptyBlock[pbBitMap[i]];
			pbBitMap[i]|=1<<bit;
			pbBitMapCurrent=i;

			return (i*BIT_NUM+bit)*pbSectors+PB_START_SECTER;
		}

		if(++i==pbBitMapSize)i=0;
	}while(i!=pbBitMapCurrent);

	return -1;
}


/*
 * PRIVATE
 * ڡȥ꡼֥åֹ롣
 * parameters : page entry
 * return : block number
 */
static inline uint getBlock(uint pentry)
{
	return (pentry&0xffffff)>>1;
}


/*
 * PRIVATE
 * ڡȥ꡼˥֥åֹꤹ롣
 * parameters : page entry address,block number
 */
static inline void setBlock(uint *pentry,uint block)
{
	*pentry&=0xff000000;
	*pentry|=block<<1;
}


/*
 * PRIVATE
 * ֥å˥åȤ롣
 * parameters : block number
 */
static inline void setBlockEmpty(uint pentry)
{
	int i;


	i=(getBlock(pentry)-PB_START_SECTER)/pbSectors;
	pbBitMap[i/BIT_NUM]&=(uchar)~(1<<(i%BIT_NUM));
}


/*
 * machine depend
 * PUBLIC
 * ڡХååץǥХλȲ1䤹
 * parameters : page entry
 */
static inline void incBackupCount(uint *pentry)
{
	union{
		uint ui;
		uchar uc[4];
	}value;


	value.ui = *pentry;
	++value.uc[3];
	*pentry = value.ui;
}


/*
 * machine depend
 * PUBLIC
 * ڡХååץǥХλȲ1餹
 * parameters : page entry
 */
static inline void decBackupCount(uint *pentry)
{
	union{
		uint ui;
		uchar uc[4];
	}value;


	value.ui = *pentry;
	if (value.uc[3] == 0)
		setBlockEmpty(*pentry);
}


/*
 * PUBLIC
 * Back up used page into page store device
 * parameters : Хååʪɥ쥹,ץơ֥,ڡȥꥢɥ쥹
 * returns : 0 or Error number
 */
static int backupPage(uint phaddr,PROC *proc,uint *pentry)
{
	int blk;


	enter_spinlock(&((MM_STRUCT*)proc->mm_struct)->pageDirGate);
	{
		/* Ǥ˥꡼ϳƤ롣 */
		if (((*pentry & PAGE_PRESEN) == 0) || (phaddr != (*pentry & ~(PAGE_SIZE - 1))) )
			goto EXIT;

		/* page tableԺߤ */
		*pentry &= ~PAGE_PRESEN;

		/* ꤵץ¹ʤpage tableTBLեå夹 */
		if((proc->cpu!=get_current_cpu())&&(cputask[proc->cpu].current_task==proc))
			issue_interrupt_to_cpu(proc->cpu,FLASH_PAGEDIR_VECT);

		/* Store page. */
		if ((blk = getEmptyBackup()) == -1)
			goto ERR;
		if (phaddr < KERNEL_END)
		{
			if (write_cache(pbDin,(void*)phaddr,pbSectors,blk) != pbSectors)
				goto ERR;
		}
		else
		{
			int error=0;
			uint *pdir;
			uint *pentry;
			uint tmp;

			pdir=((MM_STRUCT*)get_current_task()->mm_struct)->pageDir;
			pentry=getPageEntryAddr(USER_BEG,(uint*)(*getPageDirEntryAddr(USER_BEG,pdir)&~(PAGE_SIZE-1)));
			tmp=*pentry;
			*pentry=phaddr|PAGE_PRESEN|PAGE_USER|PAGE_RW;
			flashPageDir(pdir);

			if(write_cache(pbDin,(void*)USER_BEG,pbSectors,blk)!=pbSectors)error=1;

			*pentry=tmp;
			flashPageDir(pdir);
			if(error==1)goto ERR;
		}

		/* ХååץƥȤγơ */
		if(*pentry&PT_COPY_ON_WRITE)*pentry=2;
		else *pentry=1;
		*pentry<<=24;
		setBlock(pentry,blk);
	}
EXIT:
	exit_spinlock(&((MM_STRUCT*)proc->mm_struct)->pageDirGate);

	return 0;

ERR:
	*pentry|=PAGE_PRESEN;
	exit_spinlock(&((MM_STRUCT*)proc->mm_struct)->pageDirGate);

	return -1;
}


/*
 * PUBLIC
 * ڡХååץǥХ꡼˽᤹
 * parmeters : memory buffer,device block
 * return : 0 or error=-1
 */
static int restorePage(void *buf,uint *pentry)
{
	/* ǥХɤ߹ߡ */
	if (read_cache(pbDin,buf,pbSectors,getBlock(*pentry)) != pbSectors)
		return -1;

	/* ȥ󥿤򸺤餹 */
	decBackupCount(pentry);

	return 0;
}


/*
 * GLOBAL
 * ڡХååѥǥХΥޥȡ
 * parameters : device path
 * return : 0 or error number
 */
int initBackupDev(const char *dev_path)
{
	DEV_STAT dev_stat;


	/* Device open. */
	if ((pbDin = mountPageBackupDev(dev_path)) < 0)
		return pbDin;

	/* ѡƥ󥿥פγǧ */
	if(get_devstat(pbDin,&dev_stat)==-1)return -1;
	if(dev_stat.prt_type!=PT_TYPE_PAGING)return -1;
	pbSectors=PAGE_SIZE/dev_stat.sect_size;

	/* ӥåȥޥåפγơ */
	pbBitMapSize=(dev_stat.all_sect-PB_START_SECTER)/pbSectors/BIT_NUM;
	if((pbBitMap=(char*)allocMultiKernelPage(ROUNDUP_DIV(pbBitMapSize,PAGE_SIZE)))==NULL)return -ENOMEM;
	memset(pbBitMap,0,pbBitMapSize);
	pbBitMapCurrent=0;

	return 0;
}


/***********************************************************************************
 *
 * ڡ饹
 *
 * ڡȤξ
 * ȥȤǤ뤳
 *
 * 桼å
 *  0xfebfffff 顼ʥС
 *  0xfebffffb Ķѿ
 *                 
 *               
 *                 
 *             Ķѿɥ쥹
 *             ɥ쥹
 *             Ķѿɥ쥹ݥ
 *             ɥ쥹ݥ
 *             
 *
 ***********************************************************************************/

/*
 * PRIVATE
 * ڡȥ꡼򥳥ԡ饤Ȥꤹ롣
 * ȥ꡼ɬ¸ߤƤΤȤ롣
 * parameters : page entry address
 */
static inline void setCopyOnWrite(uint *pentry)
{
	if((*pentry&PAGE_PRESEN)==0)incBackupCount(pentry);		/* Хåå */
	else
	{
			*pentry&=~PAGE_RW;						/* ߶ػߤˤ롣 */
			*pentry|=PT_COPY_ON_WRITE;				/* ԡ饤ȥե饰ꤹ롣 */
			linkPhysTable(*pentry&~(PAGE_SIZE-1));
	}
}


/*
 * PRIVATE
 * ڡȥڡơ֥롣
 * ڡǥ쥯ȥñ̤ǳ롣
 * Ƥ줿ڡϥɥ쥹Ϣ³ƤȤơ롣
 * parameters : ꡼¤,Ϥɥ쥹,ɥ쥹
 */
static inline void releasePage(MM_STRUCT *mm_struct,uint begin,uint end)
{
	uint *dir_ent,*ptbl;
	uint addr;
	int i;


	enter_spinlock(&mm_struct->pageDirGate);
	{
		for(addr=begin;addr<end;addr+=PAGE_DIR_SIZE)
		{
			if(*(dir_ent=getPageDirEntryAddr(addr,mm_struct->pageDir))==0)continue;

			ptbl=(uint*)(*dir_ent&~(PAGE_SIZE-1));

			i=0;
			while(ptbl[i]==0)++i;
			for(;i<PAGE_SIZE/sizeof(uint);++i)
			{
				if(ptbl[i]&PAGE_PRESEN)unlinkPhysTable(ptbl[i]&~(PAGE_SIZE-1));	/* ڡ¸ߤ롣 */
				else if(ptbl[i]!=0)decBackupCount(&ptbl[i]);					/* ڡХååפƤ롣 */
				else break;														/* ڡƤƤʤ */
			}

			/* ڡơ֥γ */
			unlinkPhysTable((uint)ptbl);
			*dir_ent=0;
		}
	}
	exit_spinlock(&mm_struct->pageDirGate);
}


/*
 * PRIVATE
 * δĶѿХȿ׻
 * parameters : ,Ķѿ,ȥХåե
 * return : Хȿ
 */
static inline int calcArgLen(char **argv,char **envp,int *argc,int *envc)
{
	int size=0;
	int i;


	for(i=0;argv[i]!=NULL;++i)size+=strlen(argv[i])+1;	/*  */
	size+=(i+1)*sizeof(char*);							/* ɥ쥹󥵥 */
	size+=sizeof(char**);								/* ɥ쥹ݥ󥿡 */
	*argc=i;

	for(i=0;envp[i]!=NULL;++i)size+=strlen(argv[i])+1;	/* Ķѿ */
	size+=(i+1)*sizeof(char*);							/* Ķѿɥ쥹󥵥 */
	size+=sizeof(char**);								/* Ķѿɥ쥹ݥ󥿡 */
	*envc=i;

	return ROUNDUP(size+sizeof(int),sizeof(int));		/* +argc. */
}


/*
 * PRIVATE
 * ʸ򥳥ԡʸ󥵥+1֤
 * parameters : ԡХåե,ԡʸ
 * return : ʸ󥵥
 */
static inline int cpystr(char *s1,const char *s2)
{
	int i;


	i=0;
	while((s1[i]=s2[i])!='\0')++i;

	return i+1;
}


/*
 * GLOBAL
 * forkˤ꡼ƥȤ򥳥ԡ
 * parameters : Destination MM_STRUCT,Return stack offset
 * return : New MM_STRUCT address or error=NULL
 */
void *forkPage(MM_STRUCT *org_mm,void **stack)
{
	void *user_stack;
	uint *pdir,*ptbl,*org_pdir,*org_ptbl;
	MM_STRUCT *mmstruct;
	int i,j;


	/* ꡼¤ΤƤ롣 */
	if((mmstruct=(MM_STRUCT*)kmalloc(sizeof(MM_STRUCT)))==NULL)return NULL;
	mmstruct->pageDirGate=0;

	/* ƤΥڡǥ쥯ȥҤ˥ԡ롣 */
	org_pdir=org_mm->pageDir;
	if((pdir=(uint*)allocKernelPage())==NULL)return NULL;
	memcpy(pdir,org_pdir,PAGE_SIZE);
	mmstruct->pageDir=pdir;

	/* ͥ륹åƤ롣 */
	if((ptbl=allocKernelPage())==NULL)goto ERR;
	memset(ptbl,0,PAGE_SIZE);
	pdir[KERNEL_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW;
	if((*stack=allocKernelPage())==NULL)goto ERR;
	ptbl[PAGE_SIZE/sizeof(uint)-1]=(uint)*stack|PAGE_PRESEN|PAGE_RW;

	/*
	 * Userΰ򥳥ԡ饤Ȥꤹ롣
	 * ƤΥڡơ֥륨ȥ꡼񤭹߲Ĥʤ顢񤭹ԲĤˤƥԡ饤ȥե饰ꤹ롣
	 * ҤΥڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤹ롣
	 * 桼åΤڡơ֥ȥ桼åڡϿ˳Ƥ롣
	 */
	enter_spinlock(&org_mm->pageDirGate);
	{
		for(i=USER_BEG/PAGE_DIR_SIZE,j=0;i<USER_STACK_BEG/PAGE_DIR_SIZE;++i)
		{
			if(pdir[i]==0)break;

			org_ptbl=(uint*)(pdir[i]&~(PAGE_SIZE-1));
			for(j=0;j<PAGE_SIZE/sizeof(uint);++j)
			{
				if(org_ptbl[j]==0)break;
				setCopyOnWrite(&org_ptbl[j]);
			}

			/* ǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ΩƤ롣 */
			pdir[i]|=PT_COPY_ON_WRITE;
			linkPhysTable(pdir[i]&~(PAGE_SIZE-1));
			org_pdir[i]|=PT_COPY_ON_WRITE;
		}
		mmstruct->lastPageAddr=(i-1)*PAGE_DIR_SIZE+j*PAGE_SIZE-1;

		/* 桼åγơ */
		if((ptbl=(uint*)allocKernelPage())==NULL)goto ERR;
		if((user_stack = allocUserPage(&ptbl[PAGE_SIZE/sizeof(uint)-1]))==NULL)goto ERR2;
		if(pdir[USER_STACK_BEG/PAGE_DIR_SIZE]!=0)
		{
			org_ptbl=(uint*)(pdir[USER_STACK_BEG/PAGE_DIR_SIZE]&~(PAGE_SIZE-1));

			/* ԡ饤ȤΥե饰ΩƤ롣 */
			i=PAGE_SIZE/sizeof(uint)-2;
			if(org_ptbl[i]!=0)
			{
				while(i>=0)
				{
					setCopyOnWrite(&org_ptbl[i]);
					if(org_ptbl[--i]==0)break;
				}
			}

			memcpy(ptbl,org_ptbl,PAGE_SIZE);
			memcpy(user_stack,(void*)(org_ptbl[PAGE_SIZE/sizeof(uint)-1]&~(PAGE_SIZE-1)),PAGE_SIZE);
		}
		else memset(ptbl,0,PAGE_SIZE);

		ptbl[PAGE_SIZE/sizeof(uint)-1]=(uint)user_stack|PAGE_PRESEN|PAGE_RW|PAGE_USER;
		pdir[USER_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW|PAGE_USER;
	}
	exit_spinlock(&org_mm->pageDirGate);

	return mmstruct;
ERR2:
	unlinkPhysTable((uint)ptbl);
ERR:
	unlinkPhysTable((uint)pdir);
	kfree(mmstruct);

	return NULL;
}


/*
 * GLOBAL
 * Хʥե꡼˥ɤ롣
 * OPEN_Fݥ󥿤NULLʤ꡼0ꥢ롣
 * ɲͽ굡ǽ
 *  Ǥ˥ɺѤƱ¹ԥեɤ߼ꥻơߥ򥳥ԡ饤Ȥˤ롣
 * parametersOPEN_Fݥ󥿡ƥХȿɥХȿɳϥ˥ɥ쥹ڡ°ɹߤΤ=LB_R,ɤ߽=LB_WR
 * return : 0 or error=-1
 */
int loadBinary(OPEN_F *open_f,size_t size,size_t load_size,uint address,int attribute)
{
	void *page;
	uint *pdir;
	uint *ptbl;
	uint *pentry;
	uint addr,last;
	MM_STRUCT *mm_struct=(MM_STRUCT*)get_current_task()->mm_struct;


	pdir=mm_struct->pageDir;
	last=address+size;

/*	enter_spinlock(&mm_struct->pageDirGate);*/
	{
		/* ɥʬ꡼Ƥ롣 */
		for(addr=address;addr<last;addr+=PAGE_SIZE)
		{
			if((ptbl=(uint*)(*getPageDirEntryAddr(addr,pdir)&~(PAGE_SIZE-1)))==NULL)
			{
				/* ڡơ֥γơ */
				if((ptbl=(uint*)allocKernelPage())==NULL)goto ERR;
				memset(ptbl,0,PAGE_SIZE);
				*getPageDirEntryAddr(addr,pdir)=(uint)ptbl|PAGE_PRESEN|PAGE_USER|PAGE_RW;
			}

			/* ꡼°ꤹ롣 */
			pentry=getPageEntryAddr(addr,ptbl);
			if ((page = allocUserPage(pentry))==NULL)goto ERR;
			*pentry=(uint)page|PAGE_PRESEN|PAGE_USER|PAGE_RW;
		}
	}
/*	exit_spinlock(&mm_struct->pageDirGate);*/

	/* ڡǥ쥯ȥ򹹿롣 */
	flashPageDir(pdir);

	/* ե뤫꡼ɤ߹ࡣ */
	if(exec_read(open_f,(void*)address,load_size)!=load_size)return -1;
	memset((char*)address+load_size,0,size-load_size);

	/* ڡ°ɹߤʤꤷľ */
	if(attribute==LB_R)
	{
		for(addr=address;addr<last;addr+=PAGE_SIZE)
		{
			ptbl=(uint*)(*getPageDirEntryAddr(addr,pdir)&~(PAGE_SIZE-1));
			*getPageEntryAddr(addr,ptbl)&=~PAGE_RW;
		}

		/* ڡǥ쥯ȥ򹹿롣 */
		flashPageDir(pdir);

		/* ɹߥڡΥ饹ȥɥ쥹򹹿롣 */
		if(mm_struct->lastReadPage<last)mm_struct->lastReadPage=last-1;
	}

	/* 饹ȥڡɥ쥹򹹿롣 */
	if(mm_struct->lastPageAddr<last)mm_struct->lastPageAddr=last-1;

	return 0;

ERR:
	exit_spinlock(&mm_struct->pageDirGate);

	return -1;
}


/*
 * GLOBAL
 * å˰ȴĶѿ򥳥ԡưꤹ롣
 * parameters : ,Ķѿ
 * return : åƬɥ쥹
 */
uint setArgAndEnv(char **argv,char **envp)
{
	void *buf;
	uint stack;
	char *str;
	char *tmp=NULL;
	uint diff;
	int size;
	int argc,envc;
	int i;


	/* NULLʤ鲾Ϳ롣 */
	if(argv==NULL)argv=&tmp;
	if(envp==NULL)envp=&tmp;

	/* "sizeof(SYS_INFO)+sizeof(int)"ϥƥǼѤmain()Υ꥿󥢥ɥ쥹Ǽѡ */
	if((size=calcArgLen(argv,envp,&argc,&envc))+sizeof(SYS_INFO)+sizeof(int)>PAGE_SIZE)return 0;

	if((buf=allocKernelPage())==NULL)return 0;
	diff=USER_ESP_BEG-(uint)buf-(size+sizeof(SYS_INFO));
	stack=(uint)buf;

	*(int*)stack=argc;												/* argc. */
	stack+=sizeof(int);
	*(uint*)stack=stack+sizeof(char**)*2+diff;						/* argv. */
	stack+=sizeof(char**);
	*(uint*)stack=stack+sizeof(char**)+sizeof(char*)*(argc+1)+diff;	/* envp. */
	stack+=sizeof(char**);

	str=(char*)((char**)stack+(argc+envc+2));

	/* argvΥԡ */
	for(i=0;i<argc;++i)
	{
		((char**)stack)[i]=str+diff;
		str+=cpystr(str,argv[i]);
	}
	((char**)stack)[i]=NULL;
	stack+=sizeof(char*)*(i+1);

	/* envpΥԡ */
	for(i=0;i<envc;++i)
	{
		((char**)stack)[i]=str+diff;
		str+=cpystr(str,envp[i]);
	}
	((char**)stack)[i]=NULL;

	/* Хåե饹å˥ԡ */
	memcpy((void*)(USER_ESP_BEG-size-sizeof(SYS_INFO)),buf,size);

	unlinkPhysTable((uint)buf);

	return USER_ESP_BEG-size-sizeof(SYS_INFO)-sizeof(int);
}


/*
 * GLOBAL
 * 桼ƥȥڡȥǡڡ롣
 * parameters : ꡼¤
 */
void releaseUserTextDataPage(void *mm_struct)
{
	releasePage(mm_struct,USER_BEG,USER_STACK_BEG);
}


/*
 * GLOBAL
 * ͥڡȥڡǥ쥯ȥ롣
 * parameters : ꡼¤
 */
void releasePageDir(void *mm_struct)
{
	/* 桼ڡ롣 */
	releasePage(mm_struct,USER_BEG,USER_END);

	/* ͥ륹åڡ롣 */
	releasePage(mm_struct,KERNEL_STACK_BEG,KERNEL_END);

	/* ڡǥ쥯ȥ롣 */
	unlinkPhysTable((uint)((MM_STRUCT*)mm_struct)->pageDir);

	kfree(mm_struct);
}


/*
 * GLOBAL
 * ڡե㳰
 * todo
 *  桼åڡԺߤνθľ(¤ߤ)
 * parameters : page fault address,Exception frame
 */
static void printErr(uint errnum,uint addr,uint eip,uint cs,uint esp,uint ss)
{
	if(cs==KERNEL_CODE_DES)
	{
#ifdef DEBUG	
		printSyscallEntry(5);
#endif		
		printk("error number=0x%x fault address=0x%x eip=0x%x cs=0x%x process=%x\n",
			errnum,addr,eip,cs,get_current_task());
	}		
	else
		printk("error number=0x%x fault address=0x%x eip=0x%x cs=0x%x esp=0x%x,ss=0x%x\n",
			errnum,addr,eip,cs,esp,ss);
}

void pageFault(uint fault_addr,EXCEPT_FRAME frame)
{
	/* 顼ɥӥåȥޥ */
	enum{
		PRESEN=1,
		RW_MODE=2,
		USER_MODE=4,
		RSVBIT=8,
	};

	void *alloc_page;
	uint *pdir;
	uint *dentry;
	uint *current_pentry;
	int array;
	MM_STRUCT *mm_struct;


	mm_struct = get_current_task()->mm_struct;

	/* øڡȿ */
	if ((fault_addr < USER_BEG)   ||
	    (IOMAP_BEG <= fault_addr) ||
	    ((mm_struct->lastPageAddr < fault_addr) && (fault_addr < USER_STACK_BEG)) )
	{
		/* 桼ʥϥɥ餫ξ硣 */
		if((fault_addr==(uint)returnUserHandler)&&(getBeforeEsp()))
		{
			get_current_task()->nest_count-=1;
			returnUserHandler();
		}	

		printk("\nPage privilege violation!\n");
		printErr(frame.error,fault_addr,frame.eip,frame.cs,frame.user_esp,frame.user_ss);
		forceSendSignal(get_current_task(),SIGSEGV);
/***************************************/
idle();
/***************************************/
		return;
	}

	pdir=mm_struct->pageDir;
	dentry=getPageDirEntryAddr(fault_addr,pdir);

	if((frame.error&PRESEN)==0)	/* ڡԺߡ */
	{
		/* ڡǥ쥯ȥγơ */
		if(*dentry==0)
		{
			if ((*dentry = (uint)allocKernelPage()) == 0)
			{
				printk("Fail alloc physical page!\n");
				sys_exit(1);
			}
			memset ((void*)*dentry,0,PAGE_SIZE);
			*dentry |= PAGE_PRESEN | PAGE_RW | PAGE_USER;
		}

		/* ʪڡγơ */
		current_pentry = getPageEntryAddr(fault_addr,(uint*)(*dentry&~(PAGE_SIZE-1)));
		if ((alloc_page = allocUserPage(current_pentry)) == NULL)
		{
			printk("Fail alloc physical page!\n ");
			sys_exit(1);
		}

		enter_spinlock(&mm_struct->pageDirGate);
		{
			/* Хååפꡣ */
			if (*current_pentry != 0)
				if (restorePage(alloc_page,current_pentry) == -1)
				{
					printk("Fail restore page!\n ");
					exit_spinlock(&mm_struct->pageDirGate);
					kfree(alloc_page);
					forceSendSignal(get_current_task(),SIGSEGV);
					return;
				}

			*current_pentry = (uint)alloc_page | PAGE_PRESEN | PAGE_RW | PAGE_USER;
		}
		exit_spinlock(&mm_struct->pageDirGate);
	}
	else	/* ڡȿ */
	{
		current_pentry=getPageEntryAddr(fault_addr,(uint*)(*dentry&~(PAGE_SIZE-1)));

		/* ԡ饤Ƚ */
		if(*current_pentry&PT_COPY_ON_WRITE)
		{
			/* ʪ꡼ȥȤǧ */
			if(delPhysRefCount(*current_pentry)==0)
			{
				uint *new_entry=current_pentry;

				/*
				 * ڡǥ쥯ȥꥨȥ꡼˥ԡ饤ȥե饰ꤵƤϡ
				 * ڡơ֥Ƥ롣
				 */
				if(pdir[fault_addr/PAGE_DIR_SIZE]&PT_COPY_ON_WRITE)
				{
					void *alloc_tbl;

					array=fault_addr/PAGE_DIR_SIZE;

					/* ʪ꡼ȥȤǧ */
					if(delPhysRefCount(pdir[array])==0)
					{
						if((alloc_tbl=allocKernelPage())==NULL)
						{
							printk("Fail alloc physical page!\n ");
							sys_exit(1);
						}

						memcpy(alloc_tbl,(void*)(pdir[array]&~(PAGE_SIZE-1)),PAGE_SIZE);
						pdir[array]=((pdir[array]&(PAGE_SIZE-1))|(uint)alloc_tbl)&~PT_COPY_ON_WRITE;
						new_entry=(uint*)(((uint)current_pentry&(PAGE_SIZE-1))|(uint)alloc_tbl);
					}
					else pdir[array]&=~PT_COPY_ON_WRITE;
				}

				/* ʪڡơڡƤ򥳥ԡ롣 */
				if((alloc_page=allocUserPage(new_entry))==NULL)
				{
					printk("Fail alloc physical page!\n");
					sys_exit(1);
				}
				memcpy(alloc_page,(void*)(*current_pentry&~(PAGE_SIZE-1)),PAGE_SIZE);
				*new_entry=(uint)alloc_page|PAGE_PRESEN|PAGE_RW|PAGE_USER;
			}
			else *current_pentry=(*current_pentry&~PT_COPY_ON_WRITE)|PAGE_RW;
		}
		else	/* ɤ߹ߥڡȿ */
		{
			printk("\nRead only page violation!\n");
			printErr(frame.error,fault_addr,frame.eip,frame.cs,frame.user_esp,frame.user_ss);
			forceSendSignal(get_current_task(),SIGSEGV);

			return;
		}
	}

	/* TBL򹹿롣 */
	flashPageDir(pdir);

	return;
}


/*
 * GLOBAL
 * ƥॳǥХåե˽񤭹˥Хåեɥ쥹å롣
 * parameter : memory address
 * return : ok=0 or error=-1
 */
int checkMem(void *mem)
{
	if(((uint)mem>=USER_ESP_BEG)||((uint)mem<USER_BEG))
		return -1;

	return 0;
}


/*
 * GLOBAL
 * get physical address from linear address
 * parameters : linear address,state queue
 * return : physical address or srror=NULL state bit:1=ڡԺ,2=ڡ߶ػ,4=ڡ¸ߤʤ
 */
void *getPhysAddrFromLinearAddr(void *liner_addr,int *state)
{
	*state=0;
	return (void*)(*getPageEntryAddr((uint)liner_addr,((MM_STRUCT*)get_current_task()->mm_struct)->pageDir)&~(PAGE_SIZE-1));
}


/*
 * GLOBAL
 * update virtual memory system
 * parameters : memory manage structure
 */
void updateVm(void *mm_struct)
{
	flashPageDir(((MM_STRUCT*)mm_struct)->pageDir);
}


/*
 * GLOBAL
 * get page directory address
 * return : page directory address
 */
uint *getPageDir()
{
	return ((MM_STRUCT*)get_current_task()->mm_struct)->pageDir;
}


/*
 * GLOBAL
 * 桼ʥϥɥ顼¹ѡ
 * ͥ륹åڡȥ꡼֤
 */
uint *getKernelStackEntry()
{
	uint *ptbl;


	ptbl=(uint*)(*getPageDirEntryAddr(KERNEL_ESP_BEG-1,((MM_STRUCT*)get_current_task()->mm_struct)->pageDir)&~(PAGE_SIZE-1));
	return getPageEntryAddr(KERNEL_ESP_BEG-1,ptbl);
}


/*
 * GLOBAL
 * ͥڡơ֥ꤹ
 * return : MM_STRUCTɥ쥹 or error=NULL
 */
void *initPaging()
{
	void *stack;/*,*user_page;*/
	uint *pdir,*ptbl;
	MM_STRUCT *mstruct;
	int i;


	/* ͥڡǥ쥯ȥ */
	if((pdir=(uint*)allocKernelPage())==NULL)return NULL;
	memset(pdir,0,PAGE_SIZE);
	for(i=0;i<KERNEL_STACK_BEG/PAGE_DIR_SIZE;++i)
		pdir[i]=i*PAGE_DIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M;

	/* ͥ륹åڡƤ */
	if((ptbl=(uint*)allocKernelPage())==NULL)return NULL;
	memset(ptbl,0,PAGE_SIZE);
	pdir[KERNEL_STACK_BEG/PAGE_DIR_SIZE]=(uint)ptbl|PAGE_PRESEN|PAGE_RW;
	if((stack=allocKernelPage())==NULL)return NULL;
	ptbl[PAGE_SIZE/sizeof(uint)-1]=(uint)stack|PAGE_PRESEN|PAGE_RW;

	/* ꡼ޥåץIOڡѥǥ쥯ȥ */
	for(i=IOMAP_BEG/PAGE_DIR_SIZE;i<PAGE_SIZE/sizeof(uint);++i)
	   	pdir[i]=i*PAGE_DIR_SIZE|PAGE_PRESEN|PAGE_RW|PAGE_4M|PAGE_CASH_DISABLE;

	/* ڡ󥰳 */
	asm volatile(
			"movl	%%eax,%%cr3\n"			/* Set page directory address */
			"movl	$0x10,%%eax\n"
			"movl	%%eax,%%cr4\n"			/* 4Mڡĥ */
			"movl	%%cr0,%%eax\n"
			"orl	$0x80010000,%%eax\n"	/* Enable paging,Enable wp(ѡХν񤭹ݸ) */
			"movl	%%eax,%%cr0\n"
			"jmp	1f\n"
		"1:"
		::"a"(pdir)
	);

	/* ꡼¤Τν */
	if((mstruct=(MM_STRUCT*)kmalloc(sizeof(MM_STRUCT)))==NULL)return NULL;
	mstruct->pageDir=pdir;
	mstruct->pageDirGate=0;
	mstruct->lastReadPage=0;
	mstruct->lastPageAddr=0;

	return (void*)mstruct;
}


/***********************************************************************************
 *
 * ƥॳ
 *
 ***********************************************************************************/

/*
 * 桼ڡΥɥ쥹ޤǳƤ롣
 */
int sys_brk(void *end_addr)
{
	MM_STRUCT *mm_struct;


	mm_struct=(MM_STRUCT*)get_current_task()->mm_struct;
	if((uint)end_addr<=mm_struct->lastPageAddr)return 0;
	if((uint)end_addr>=USER_STACK_BEG)return -ENOMEM;
	mm_struct->lastPageAddr=ROUNDUP((uint)end_addr,PAGE_SIZE)-1;

	return 0;
}


/***********************************************************************************
 *
 * ؿ
 *
 ***********************************************************************************/

/*
 * GLOBAL
 * ꡼ƥν
 */
void initMm()
{
	/* Find size of physical memory  */
	printk("Memory size = %d MB\n",findAllMemsize()/0x100000);

	/* ʪ꡼ơ֥ */
	initPhysMemTable();
}
/************************************************************************/
int test_mm(uint *page)
{
	printk("40000c39=%x 40000080=%x\n",*(uint*)((uint)page + 0xc39),*(uint*)((uint)page + 0x80));

	return 0;
}
/*************************************************************************/
