/*
 * bootload.S
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * ǽBIOSˤäfloppyɤ륳ɤʤΤǡ512ХȰʲˤʤФʤʤ
 * ϡsetupɤSTART_ADDRESS˥ɤơϤȤŪǤ롣
 *
 * ɤ˥ޥץåƥѤMPFloatingPointerStructure򸡺롣
 * <>ebpMPFloatingPointerStructureɥ쥹Ǽ˻Ѥ롣
 *
 */


#define ASM_FILE


#include "config.h"


/* ɤsetupΥХʥꥵͤmake˼ư */
SETUP_SIZE=129160

BOOT_SEGMENT=0x07C0					/* BIOSˤɤ륻 */
SS_SEGMENT=0x9000					/* StackϰͤƻѲǽ꡼ΰü */
SP_INIT=0x10000-0x400				/* åݥ */
CHANGE_SEGMENT=(0x90000-0x400)>>4	/* Τΰư襻 */
SETUP_SEGMENT=START_ADDRESS>>4		/* setup⥸塼Υɥ */

MP_SIGN=0x5f504d5f					/* MP Floating Pointer Structureѥ */

SECTOR_SIZE=512						/* եåԡΣ */
SECTOR_NUM=18						/* եåԡΣȥåΥ */

VIDEO_ADDRESS=0xb8000				/* ӥǥ꡼ɥ쥹 */


.text
.code16
.globl _start
_start:
	movw	$SS_SEGMENT,%ax
	movw	%ax,%ss
	movw	$SP_INIT,%sp
	movw	$BOOT_SEGMENT,%ax
	movw	%ax,%ds

	/*
	 * ꡼setupɤǾ񤭤MPFloatingPointerStructure򸡺
	 *
	 * õϼΣս
	 *	1 EDBC(Ȥ0x40e˵)ǽ1kХ
	 *	2 BIOS(0xf0000)64kХ
	 *	3 ١꡼(640k)Ǹ1kХ
	 */
	xorl	%ebp,%ebp
	pushw	%ds
	xorw	%ax,%ax
	movw	%ax,%ds
	movw	0x40e,%ax
	popw	%ds
	pushw	$0x400
	pushw	%ax
	call	search_sign
	orl		%ebp,%ebp
	jnz		end
	pushw	$0
	pushw	$0xf000
	call	search_sign
	orl		%ebp,%ebp
	jnz		end
	pushw	$0x400
	pushw	$(0xa000-0x40)
	call	search_sign
end:

	/*
	 * Υɤsetupɥɥ쥹Υɥ쥹˰ư
	 */
	cld
	movw	$CHANGE_SEGMENT,%ax
	movw	%ax,%es
	xorw	%si,%si
	xorw	%di,%di
	movw	$SECTOR_SIZE>>1,%cx
	rep
	movsw
	ljmp	$CHANGE_SEGMENT,$change_end
change_end:
	movw	$CHANGE_SEGMENT,%ax
	movw	%ax,%ds

	/*
	 * BIOSߤȤäsetupХʥSETUP_SEGMENT˥ɤ
	 */
	pushw	$80*24
	pushw	$load_message
	call	print_ascii		/* ɥåɽ */

	/*  */
	movw	$SETUP_SEGMENT,%ax
	andw	$0xf000,%ax
	movw	%ax,%es				/* ɤ߹襻 */
	movw	$SETUP_SEGMENT,%bx
	andw	$0xfff,%bx
	shlw	$4,%bx				/* ɤ߹襢ɥ쥹 */
	movb	$2,%cl				/* ɤ߹߳ϥֹ */
	movb	$0,%ch				/* ϥȥåֹ */
	movw	$0,%dx				/* ǥμ dl=0(եåԡ) إåֹ dh=0 */
	movw	$(SETUP_SIZE+SECTOR_SIZE-1)>>9,%si		/* ɤ߹ߥ>>9 = /512 */

	/* ɤ߹߳ */
loop:
	movw	$SECTOR_NUM+1,%ax
	subb	%cl,%al			/* 1ȥåɤ߹ߥ */
	movw	%ax,%di
	shlw	$9,%di			/* *512Х */
	addw	%bx,%di			/* 1Read64KbyteۤƤ뤫å */
	jnc		1f				/* ĶƤʤʤ饸 */
	xorw	%di,%di
	subw	%bx,%di
	shrw	$9,%di			/* /512Х */
	movw	%di,%ax			/* ax=64Kbyteۤʤɤ߹ߥ */
1:	cmpw	%si,%ax			/* ɤ߹ߥɤ߹Secter礭å */
	jbe		read
	movw	%si,%ax
read:
	movb	$2,%ah
	int		$0x13
	jc		read_error
	incw	mark_position
	pushw	mark_position
	pushw	$load_mark
	call	print_ascii		/* ɥޡɽ */
	subw	%ax,%si			/* al=ɤ߹ */
	jz		end_loop		/* Ĥꥻ0ʤ齪λ */

	addb	%al,%cl
	cmpb	$SECTOR_NUM,%cl
	jbe		1f				/* ȥåΥĶƤʤХ */
	movb	$1,%cl
	xorb	$1,%dh			/* إåֹ */
	incb	%ch
	subb	%dh,%ch			/* ȥåֹ Trackοʤ head 0,track 0head 1,track0head 0,track 1... */
1:	shlw	$9,%ax			/* x512byte */
	addw	%ax,%bx			/* ɤ߹襢ɥ쥹 */
	jnz		loop
	movw	%es,%ax			/* ɥ쥹0ä饻Ȥ0x1000ʤ */
	addw	$0x1000,%ax
	movw	%ax,%es
	jmp		loop
end_loop:

	/* FloppyMotorߤ */
	movb	$0,%al
	movw	$0x3f2,%dx
	outb	%dx

	/*
	 * ɤåȥåץɤ˥פ
	 */
	ljmp	$SETUP_SEGMENT,$0


/*
 * MPFloatingPointerStructure򸡺
 *  : ɥ쥹ȡоݥХȿ
 */
search_sign:
	pushw	%bp
	movw	%sp,%bp
	movw	4(%bp),%ax
	movw	6(%bp),%cx
	popw	%bp
	pushw	%ds
	movw	%ax,%ds
	xorl	%ebx,%ebx

1:	movl	(%bx),%eax
	cmpl	$MP_SIGN,%eax
	je		2f
	addw	$4,%bx
	cmpw	%cx,%bx
	je		3f
	jmp		1b

2:	movw	%ds,%dx
	movw	%dx,%bp
	shll	$4,%ebp
	addl	%ebx,%ebp
3:	popw	%ds
	ret		$4


/*
 * եåԡɤ߹ߥ顼ν
 * 顼ɤɽƥȥåפ
 */
read_error:
	shrw	$8,%ax
	pushw	$80*24+30
	pushw	%ax
	call	print_binary
	pushw	$80*24
	pushw	$read_error_message
	call	print_ascii
	cli
	hlt


/*
 * ʸդʸɽ
 *  : ʸ󥢥ɥ쥹ɽϰ
 */
print_ascii:
	pushw	%dx
	pushw	%si
	pushw	%di
	pushw	%bp
	pushw	%es

	movw	$VIDEO_ADDRESS>>4,%dx
	movw	%dx,%es
	movw	%sp,%bp
	movw	12(%bp),%si
	movw	14(%bp),%di
	shlw	$1,%di
1:	movb	(%si),%dl
	cmpb	$0,%dl
	je		2f
	movb	%dl,%es:(%di)
	incw	%si
	addw	$2,%di
	jmp		1b

2:	popw	%es
	popw	%bp
	popw	%di
	popw	%si
	popw	%dx
	ret		$4


/*
 * 2ХȥХʥͤɽ
 *  : Хʥ͡ɽϰ
 */
print_binary:
	pushw	%ax
	pushw	%bx
	pushw	%dx
	pushw	%bp
	pushw	%ds

	movw	$VIDEO_ADDRESS>>4,%ax
	movw	%ax,%ds
	movw	%sp,%bp
	movw	12(%bp),%ax
	movw	14(%bp),%bx
	shlw	$1,%bx
	shlw	$1,14(%bp)
	addw	$6,%bx
1:	movw	%ax,%dx
	andw	$0xf,%dx
	cmpw	$9,%dx
	jbe		2f
	addw	$7,%dx
2:	addw	$0x30,%dx
	movb	%dl,(%bx)
	shrw	$4,%ax
	subw	$2,%bx
	cmpw	14(%bp),%bx
	jge		1b

	popw	%ds
	popw	%bp
	popw	%dx
	popw	%bx
	popw	%ax
	ret		$4


load_message:
	.string	"Start loading."

load_mark:
	.string	"."

mark_position:
	.word	24*80+13

read_error_message:
	.string	"Floppy read error!"
